/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.gui.HistoryTextField;
import org.gjt.sp.jedit.gui.MultiFileSearchDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.search.CurrentBufferSet;
import org.gjt.sp.jedit.search.SearchAndReplace;
import org.gjt.sp.jedit.search.SearchFileSet;

public class SearchDialog
extends EnhancedDialog {
    private View view;
    private SearchFileSet fileset;
    private HistoryTextField find;
    private HistoryTextField replace;
    private JCheckBox keepDialog;
    private JCheckBox ignoreCase;
    private JCheckBox regexp;
    private JCheckBox multifile;
    private JButton multifileBtn;
    private JButton findBtn;
    private JButton replaceSelection;
    private JButton replaceAll;
    private JButton cancel;

    public SearchDialog(View view, String defaultFind) {
        super(view, jEdit.getProperty("search.title"), false);
        this.view = view;
        this.fileset = SearchAndReplace.getSearchFileSet();
        this.find = new HistoryTextField("find");
        this.find.setText(defaultFind);
        this.replace = new HistoryTextField("replace");
        this.keepDialog = new JCheckBox(jEdit.getProperty("search.keepDialog"), "on".equals(jEdit.getProperty("search.keepDialog.toggle")));
        this.ignoreCase = new JCheckBox(jEdit.getProperty("search.ignoreCase"), SearchAndReplace.getIgnoreCase());
        this.regexp = new JCheckBox(jEdit.getProperty("search.regexp"), SearchAndReplace.getRegexp());
        this.multifile = new JCheckBox();
        this.multifile.getModel().setSelected(!(this.fileset instanceof CurrentBufferSet));
        this.multifileBtn = new JButton(jEdit.getProperty("search.multifile"));
        this.findBtn = new JButton(jEdit.getProperty("search.findBtn"));
        this.replaceSelection = new JButton(jEdit.getProperty("search.replaceSelection"));
        this.replaceSelection.setMnemonic(jEdit.getProperty("search.replaceSelection.mnemonic").charAt(0));
        this.replaceAll = new JButton(jEdit.getProperty("search.replaceAll"));
        this.replaceAll.setMnemonic(jEdit.getProperty("search.replaceAll.mnemonic").charAt(0));
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.fill = 1;
        JLabel label = new JLabel(jEdit.getProperty("search.find"), 4);
        layout.setConstraints(label, constraints);
        panel.add(label);
        constraints.gridx = 1;
        constraints.gridwidth = 0;
        constraints.weightx = 1.0;
        layout.setConstraints(this.find, constraints);
        panel.add(this.find);
        constraints.gridx = 0;
        constraints.gridwidth = 1;
        constraints.gridy = 1;
        constraints.weightx = 0.0;
        label = new JLabel(jEdit.getProperty("search.replace"), 4);
        layout.setConstraints(label, constraints);
        panel.add(label);
        constraints.gridx = 1;
        constraints.gridwidth = 0;
        constraints.weightx = 1.0;
        layout.setConstraints(this.replace, constraints);
        panel.add(this.replace);
        this.getContentPane().add("North", panel);
        panel = new JPanel();
        panel.add(this.keepDialog);
        panel.add(this.ignoreCase);
        panel.add(this.regexp);
        panel.add(this.multifile);
        panel.add(this.multifileBtn);
        this.getContentPane().add("Center", panel);
        panel = new JPanel();
        panel.add(this.findBtn);
        panel.add(this.replaceSelection);
        panel.add(this.replaceAll);
        panel.add(this.cancel);
        this.getRootPane().setDefaultButton(this.findBtn);
        this.getContentPane().add("South", panel);
        ActionHandler actionListener = new ActionHandler();
        this.multifile.addActionListener(actionListener);
        this.multifileBtn.addActionListener(actionListener);
        this.findBtn.addActionListener(actionListener);
        this.replaceSelection.addActionListener(actionListener);
        this.replaceAll.addActionListener(actionListener);
        this.cancel.addActionListener(actionListener);
        this.pack();
        GUIUtilities.loadGeometry(this, "search");
        this.show();
        this.find.requestFocus();
    }

    public void ok() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.save();
        if (SearchAndReplace.find(this.view)) {
            this.disposeOrKeepDialog();
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void cancel() {
        GUIUtilities.saveGeometry(this, "search");
        this.dispose();
    }

    private void save() {
        this.find.addCurrentToHistory();
        SearchAndReplace.setSearchString(this.find.getText());
        this.replace.addCurrentToHistory();
        SearchAndReplace.setReplaceString(this.replace.getText());
        jEdit.setProperty("search.keepDialog.toggle", this.keepDialog.getModel().isSelected() ? "on" : "off");
        SearchAndReplace.setIgnoreCase(this.ignoreCase.getModel().isSelected());
        SearchAndReplace.setRegexp(this.regexp.getModel().isSelected());
        SearchAndReplace.setSearchFileSet(this.fileset);
    }

    private void disposeOrKeepDialog() {
        if (this.keepDialog.getModel().isSelected()) {
            return;
        }
        this.dispose();
    }

    private void showMultiFileDialog() {
        SearchFileSet fs = new MultiFileSearchDialog(this.view, this.fileset).getSearchFileSet();
        if (fs != null) {
            this.fileset = fs;
        }
        this.multifile.getModel().setSelected(!(this.fileset instanceof CurrentBufferSet));
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            Buffer buffer = SearchDialog.this.view.getBuffer();
            if (source == SearchDialog.this.cancel) {
                SearchDialog.this.dispose();
            } else if (source == SearchDialog.this.findBtn) {
                SearchDialog.this.ok();
            } else if (source == SearchDialog.this.replaceSelection) {
                SearchDialog.this.save();
                if (SearchAndReplace.replace(SearchDialog.this.view)) {
                    SearchDialog.this.disposeOrKeepDialog();
                } else {
                    SearchDialog.this.getToolkit().beep();
                }
            } else if (source == SearchDialog.this.replaceAll) {
                SearchDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                SearchDialog.this.save();
                if (SearchAndReplace.replaceAll(SearchDialog.this.view)) {
                    SearchDialog.this.disposeOrKeepDialog();
                } else {
                    SearchDialog.this.getToolkit().beep();
                }
                SearchDialog.this.setCursor(Cursor.getPredefinedCursor(0));
            } else if (source == SearchDialog.this.multifileBtn) {
                SearchDialog.this.showMultiFileDialog();
            } else if (source == SearchDialog.this.multifile) {
                if (SearchDialog.this.multifile.getModel().isSelected()) {
                    SearchDialog.this.showMultiFileDialog();
                } else {
                    SearchDialog.this.fileset = new CurrentBufferSet();
                }
            }
        }
    }
}

