/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.jEdit;

public class PastePrevious
extends EnhancedDialog
implements ActionListener,
ListSelectionListener,
MouseListener {
    private View view;
    private JList clips;
    private HistoryModel clipHistory;
    private JButton insert;
    private JButton cancel;

    public PastePrevious(View view) {
        super(view, jEdit.getProperty("pasteprev.title"), true);
        this.view = view;
        Container content = this.getContentPane();
        this.clipHistory = HistoryModel.getModel("clipboard");
        this.clips = new JList(new AbstractListModel(){

            public int getSize() {
                return PastePrevious.this.clipHistory.getSize();
            }

            public Object getElementAt(int index) {
                return PastePrevious.this.clipHistory.getItem(index);
            }
        });
        this.clips.setVisibleRowCount(16);
        this.clips.setFont(view.getTextArea().getPainter().getFont());
        this.clips.addMouseListener(this);
        this.clips.addListSelectionListener(this);
        this.insert = new JButton(jEdit.getProperty("pasteprev.insert"));
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        content.setLayout(new BorderLayout());
        content.add((Component)new JLabel(jEdit.getProperty("pasteprev.caption")), "North");
        JScrollPane scroller = new JScrollPane(this.clips);
        Dimension dim = scroller.getPreferredSize();
        scroller.setPreferredSize(new Dimension(640, dim.height));
        content.add((Component)scroller, "Center");
        JPanel panel = new JPanel();
        panel.add(this.insert);
        panel.add(this.cancel);
        content.add((Component)panel, "South");
        this.updateButtons();
        this.getRootPane().setDefaultButton(this.insert);
        this.insert.addActionListener(this);
        this.cancel.addActionListener(this);
        Dimension screen = this.getToolkit().getScreenSize();
        this.pack();
        this.setLocation((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2);
        this.show();
        this.clips.requestFocus();
    }

    public void ok() {
        int selected = this.clips.getSelectedIndex();
        if (selected == -1) {
            this.view.getToolkit().beep();
            return;
        }
        String clip = this.clipHistory.getItem(selected);
        int repeatCount = this.view.getTextArea().getInputHandler().getRepeatCount();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < repeatCount) {
            buf.append(clip);
            ++i;
        }
        this.view.getTextArea().setSelectedText(buf.toString());
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.insert) {
            this.ok();
        } else if (source == this.cancel) {
            this.cancel();
        }
    }

    public void mouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.ok();
        }
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
    }

    public void valueChanged(ListSelectionEvent evt) {
        this.updateButtons();
    }

    private void updateButtons() {
        int selected = this.clips.getSelectedIndex();
        this.insert.setEnabled(selected != -1);
    }
}

