/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.OptionGroup;
import org.gjt.sp.jedit.OptionPane;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.AbbrevsOptionPane;
import org.gjt.sp.jedit.options.CommandShortcutsOptionPane;
import org.gjt.sp.jedit.options.EditorOptionPane;
import org.gjt.sp.jedit.options.FileFilterOptionPane;
import org.gjt.sp.jedit.options.GeneralOptionPane;
import org.gjt.sp.jedit.options.GutterOptionPane;
import org.gjt.sp.jedit.options.MacroShortcutsOptionPane;
import org.gjt.sp.jedit.options.StyleOptionPane;
import org.gjt.sp.util.Log;

public class OptionsDialog
extends EnhancedDialog
implements ActionListener,
TreeSelectionListener {
    private Hashtable panes;
    private JTree paneTree;
    private JPanel cardPanel;
    private JLabel currentLabel;
    private JButton ok;
    private JButton cancel;
    private JButton apply;
    private OptionGroup jEditGroup;
    private OptionGroup pluginsGroup;

    public OptionsDialog(View view) {
        super(view, jEdit.getProperty("options.title"), true);
        view.showWaitCursor();
        this.getContentPane().setLayout(new BorderLayout());
        JPanel stage = new JPanel(new BorderLayout(4, 8));
        stage.setBorder(BorderFactory.createCompoundBorder(new SoftBevelBorder(0), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.getContentPane().add((Component)stage, "Center");
        this.currentLabel = new JLabel();
        this.currentLabel.setHorizontalAlignment(2);
        this.currentLabel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.black));
        stage.add((Component)this.currentLabel, "North");
        this.cardPanel = new JPanel(new CardLayout());
        stage.add((Component)this.cardPanel, "Center");
        this.paneTree = new JTree(this.createOptionTreeModel());
        this.paneTree.setCellRenderer(new PaneNameRenderer());
        this.paneTree.putClientProperty("JTree.lineStyle", "Angled");
        this.paneTree.setShowsRootHandles(true);
        this.paneTree.setRootVisible(false);
        this.getContentPane().add((Component)new JScrollPane(this.paneTree, 22, 30), "West");
        JPanel buttons = new JPanel();
        this.getContentPane().add((Component)buttons, "South");
        this.ok = new JButton(jEdit.getProperty("common.ok"));
        this.ok.addActionListener(this);
        buttons.add(this.ok);
        this.getRootPane().setDefaultButton(this.ok);
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        this.cancel.addActionListener(this);
        buttons.add(this.cancel);
        TreePath jEditPath = new TreePath(new Object[]{this.paneTree.getModel().getRoot(), this.jEditGroup});
        this.paneTree.getSelectionModel().addTreeSelectionListener(this);
        this.paneTree.setSelectionPath(jEditPath.pathByAddingChild(this.jEditGroup.getMember(0)));
        this.paneTree.addMouseListener(new MouseHandler());
        view.hideWaitCursor();
        Dimension screen = this.getToolkit().getScreenSize();
        this.pack();
        this.setLocation((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2);
        this.show();
    }

    public void addOptionGroup(OptionGroup group) {
        this.addOptionGroup(group, this.pluginsGroup);
    }

    public void addOptionPane(OptionPane pane) {
        this.addOptionPane(pane, this.pluginsGroup);
    }

    public void ok() {
        this.ok(true);
    }

    public void cancel() {
        this.dispose();
    }

    public void ok(boolean dispose) {
        OptionTreeModel m = (OptionTreeModel)this.paneTree.getModel();
        ((OptionGroup)m.getRoot()).save();
        jEdit.propertiesChanged();
        if (dispose) {
            this.dispose();
        }
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.ok) {
            this.ok();
        } else if (source == this.cancel) {
            this.cancel();
        } else if (source == this.apply) {
            this.ok(false);
        }
    }

    public void valueChanged(TreeSelectionEvent evt) {
        TreePath path = evt.getPath();
        if (path == null || !(path.getLastPathComponent() instanceof OptionPane)) {
            return;
        }
        Object[] nodes = path.getPath();
        StringBuffer buf = new StringBuffer();
        String name = null;
        int lastIdx = nodes.length - 1;
        int i = this.paneTree.isRootVisible() ? 0 : 1;
        while (i <= lastIdx) {
            block11: {
                block10: {
                    block9: {
                        if (!(nodes[i] instanceof OptionPane)) break block9;
                        name = ((OptionPane)nodes[i]).getName();
                        break block10;
                    }
                    if (!(nodes[i] instanceof OptionGroup)) break block11;
                    name = ((OptionGroup)nodes[i]).getName();
                }
                if (name != null) {
                    String label = jEdit.getProperty("options." + name + ".label");
                    if (label == null) {
                        buf.append(name);
                    } else {
                        buf.append(label);
                    }
                }
                if (i != lastIdx) {
                    buf.append(": ");
                }
            }
            ++i;
        }
        this.currentLabel.setText(buf.toString());
        ((CardLayout)this.cardPanel.getLayout()).show(this.cardPanel, name);
    }

    private OptionTreeModel createOptionTreeModel() {
        OptionTreeModel paneTreeModel = new OptionTreeModel();
        OptionGroup rootGroup = (OptionGroup)paneTreeModel.getRoot();
        this.jEditGroup = new OptionGroup("jedit");
        this.addOptionPane(new GeneralOptionPane(), this.jEditGroup);
        this.addOptionPane(new EditorOptionPane(), this.jEditGroup);
        this.addOptionPane(new GutterOptionPane(), this.jEditGroup);
        this.addOptionPane(new StyleOptionPane(), this.jEditGroup);
        this.addOptionPane(new FileFilterOptionPane(), this.jEditGroup);
        OptionGroup shortcutsGroup = new OptionGroup("shortcuts");
        shortcutsGroup.addOptionPane(new CommandShortcutsOptionPane());
        shortcutsGroup.addOptionPane(new MacroShortcutsOptionPane());
        this.addOptionGroup(shortcutsGroup, this.jEditGroup);
        this.addOptionPane(new AbbrevsOptionPane(), this.jEditGroup);
        this.addOptionGroup(this.jEditGroup, rootGroup);
        this.pluginsGroup = new OptionGroup("plugins");
        EditPlugin[] plugins = jEdit.getPlugins();
        int i = 0;
        while (i < plugins.length) {
            EditPlugin ep = plugins[i];
            try {
                ep.createOptionPanes(this);
            }
            catch (Throwable t) {
                Log.log(9, ep, "Error creating option pane");
                Log.log(9, ep, t);
            }
            ++i;
        }
        if (this.pluginsGroup.getMemberCount() > 0) {
            this.addOptionGroup(this.pluginsGroup, rootGroup);
        }
        return paneTreeModel;
    }

    private void addOptionGroup(OptionGroup child, OptionGroup parent) {
        Enumeration enume = child.getMembers();
        while (enume.hasMoreElements()) {
            Object elem = enume.nextElement();
            if (elem instanceof OptionPane) {
                this.addOptionPane((OptionPane)elem, child);
                continue;
            }
            if (!(elem instanceof OptionGroup)) continue;
            this.addOptionGroup((OptionGroup)elem, child);
        }
        parent.addOptionGroup(child);
    }

    private void addOptionPane(OptionPane pane, OptionGroup parent) {
        String name = pane.getName();
        this.cardPanel.add(pane.getComponent(), name);
        parent.addOptionPane(pane);
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        public void mouseClicked(MouseEvent evt) {
            TreePath path = OptionsDialog.this.paneTree.getPathForLocation(evt.getX(), evt.getY());
            if (path == null) {
                return;
            }
            Object node = path.getLastPathComponent();
            if (node instanceof OptionGroup) {
                if (OptionsDialog.this.paneTree.isCollapsed(path)) {
                    OptionsDialog.this.paneTree.expandPath(path);
                } else {
                    OptionsDialog.this.paneTree.collapsePath(path);
                }
            }
        }
    }

    class OptionTreeModel
    implements TreeModel {
        private OptionGroup root = new OptionGroup("root");
        private EventListenerList listenerList = new EventListenerList();

        OptionTreeModel() {
        }

        public void addTreeModelListener(TreeModelListener l) {
            this.listenerList.add(TreeModelListener.class, l);
        }

        public void removeTreeModelListener(TreeModelListener l) {
            this.listenerList.remove(TreeModelListener.class, l);
        }

        public Object getChild(Object parent, int index) {
            if (parent instanceof OptionGroup) {
                return ((OptionGroup)parent).getMember(index);
            }
            return null;
        }

        public int getChildCount(Object parent) {
            if (parent instanceof OptionGroup) {
                return ((OptionGroup)parent).getMemberCount();
            }
            return 0;
        }

        public int getIndexOfChild(Object parent, Object child) {
            if (parent instanceof OptionGroup) {
                return ((OptionGroup)parent).getMemberIndex(child);
            }
            return -1;
        }

        public Object getRoot() {
            return this.root;
        }

        public boolean isLeaf(Object node) {
            return node instanceof OptionPane;
        }

        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        protected void fireNodesChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
            Object[] listeners = this.listenerList.getListenerList();
            TreeModelEvent modelEvent = null;
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == TreeModelListener.class) {
                    if (modelEvent == null) {
                        modelEvent = new TreeModelEvent(source, path, childIndices, children);
                    }
                    ((TreeModelListener)listeners[i + 1]).treeNodesChanged(modelEvent);
                }
                i -= 2;
            }
        }

        protected void fireNodesInserted(Object source, Object[] path, int[] childIndices, Object[] children) {
            Object[] listeners = this.listenerList.getListenerList();
            TreeModelEvent modelEvent = null;
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == TreeModelListener.class) {
                    if (modelEvent == null) {
                        modelEvent = new TreeModelEvent(source, path, childIndices, children);
                    }
                    ((TreeModelListener)listeners[i + 1]).treeNodesInserted(modelEvent);
                }
                i -= 2;
            }
        }

        protected void fireNodesRemoved(Object source, Object[] path, int[] childIndices, Object[] children) {
            Object[] listeners = this.listenerList.getListenerList();
            TreeModelEvent modelEvent = null;
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == TreeModelListener.class) {
                    if (modelEvent == null) {
                        modelEvent = new TreeModelEvent(source, path, childIndices, children);
                    }
                    ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(modelEvent);
                }
                i -= 2;
            }
        }

        protected void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object[] children) {
            Object[] listeners = this.listenerList.getListenerList();
            TreeModelEvent modelEvent = null;
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == TreeModelListener.class) {
                    if (modelEvent == null) {
                        modelEvent = new TreeModelEvent(source, path, childIndices, children);
                    }
                    ((TreeModelListener)listeners[i + 1]).treeStructureChanged(modelEvent);
                }
                i -= 2;
            }
        }
    }

    class PaneNameRenderer
    extends JLabel
    implements TreeCellRenderer {
        private Border noFocusBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        private Border focusBorder = BorderFactory.createLineBorder(UIManager.getColor("Tree.selectionBorderColor"));
        private Font paneFont;
        private Font groupFont;

        public PaneNameRenderer() {
            this.setOpaque(true);
            this.paneFont = UIManager.getFont("Tree.font");
            this.groupFont = new Font(this.paneFont.getName(), this.paneFont.getStyle() | 1, this.paneFont.getSize());
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (selected) {
                this.setBackground(UIManager.getColor("Tree.selectionBackground"));
                this.setForeground(UIManager.getColor("Tree.selectionForeground"));
            } else {
                this.setBackground(tree.getBackground());
                this.setForeground(tree.getForeground());
            }
            String name = null;
            if (value instanceof OptionGroup) {
                name = ((OptionGroup)value).getName();
                this.setFont(this.groupFont);
            } else if (value instanceof OptionPane) {
                name = ((OptionPane)value).getName();
                this.setFont(this.paneFont);
            }
            if (name == null) {
                this.setText(null);
            } else {
                String label = jEdit.getProperty("options." + name + ".label");
                if (label == null) {
                    this.setText(name);
                } else {
                    this.setText(label);
                }
            }
            this.setBorder(hasFocus ? this.focusBorder : this.noFocusBorder);
            return this;
        }
    }
}

