/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.MenuItemModel;
import org.gjt.sp.jedit.jEdit;

public class MenuModel
extends MenuItemModel {
    public static final Object SEPARATOR = "-";
    protected Vector children = new Vector();

    public MenuModel(String name) {
        super(name);
        String menuItems = jEdit.getProperty(name);
        if (menuItems != null) {
            StringTokenizer st = new StringTokenizer(menuItems);
            while (st.hasMoreTokens()) {
                String menuItemName = st.nextToken();
                if (menuItemName.equals("-")) {
                    this.children.addElement(SEPARATOR);
                    continue;
                }
                if (menuItemName.startsWith("%")) {
                    this.children.addElement(GUIUtilities.loadMenuModel(menuItemName.substring(1)));
                    continue;
                }
                this.children.addElement(GUIUtilities.loadMenuItemModel(menuItemName));
            }
        }
    }

    public JMenuItem create(View view) {
        JMenu menu = view.getMenu(this.name);
        if (menu != null) {
            return menu;
        }
        menu = new JMenu(this.label);
        menu.setMnemonic(this.mnemonic);
        Enumeration enume = this.children.elements();
        while (enume.hasMoreElements()) {
            Object obj = enume.nextElement();
            if (obj == SEPARATOR) {
                menu.addSeparator();
                continue;
            }
            menu.add(((MenuItemModel)obj).create(view));
        }
        return menu;
    }

    public JPopupMenu createPopup(View view) {
        JPopupMenu menu = new JPopupMenu();
        menu.setInvoker(view);
        Enumeration enume = this.children.elements();
        while (enume.hasMoreElements()) {
            Object obj = enume.nextElement();
            if (obj == SEPARATOR) {
                menu.addSeparator();
                continue;
            }
            MenuItemModel menuItem = (MenuItemModel)obj;
            menu.add(menuItem.create(view));
        }
        return menu;
    }
}

