/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedButton;
import org.gjt.sp.jedit.gui.EnhancedCheckBoxMenuItem;
import org.gjt.sp.jedit.gui.EnhancedMenuItem;
import org.gjt.sp.jedit.jEdit;

public class MenuItemModel {
    protected ImageIcon icon;
    protected String name;
    protected String label;
    protected String toolTip;
    protected char mnemonic;
    protected EditAction action;
    protected String arg;

    public MenuItemModel(String name) {
        URL url;
        this.name = name;
        int index = name.indexOf(64);
        if (index != -1) {
            this.arg = name.substring(index + 1);
            this.action = jEdit.getAction(name.substring(0, index));
        } else {
            this.arg = null;
            this.action = jEdit.getAction(name);
        }
        this.label = jEdit.getProperty(name.concat(".label"));
        if (this.label == null) {
            this.label = name;
        }
        if ((index = this.label.indexOf(36)) != -1 && this.label.length() - index > 1) {
            this.mnemonic = Character.toLowerCase(this.label.charAt(index + 1));
            this.label = this.label.substring(0, index).concat(this.label.substring(++index));
        } else {
            this.mnemonic = '\u0000';
        }
        String iconName = jEdit.getProperty(String.valueOf(name) + ".icon");
        if (iconName != null && (url = this.getClass().getResource("/org/gjt/sp/jedit/toolbar/" + iconName)) != null) {
            this.icon = new ImageIcon(url);
            this.toolTip = GUIUtilities.prettifyMenuLabel(this.label);
            String shortcut = jEdit.getProperty(String.valueOf(name) + ".shortcut");
            if (shortcut != null) {
                this.toolTip = String.valueOf(this.toolTip) + " (" + shortcut + ")";
            }
        }
    }

    public JMenuItem create(View view) {
        JMenuItem mi = this.action != null && this.action.isToggle() ? new EnhancedCheckBoxMenuItem(this.label, this.action, this.arg) : new EnhancedMenuItem(this.label, null, this.action, this.arg);
        if (this.mnemonic != '\u0000') {
            mi.setMnemonic(this.mnemonic);
        }
        return mi;
    }

    public EnhancedButton createButton() {
        return new EnhancedButton(this.icon, this.toolTip, this.action, this.arg);
    }
}

