/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.gui.HistoryTextField;
import org.gjt.sp.jedit.gui.MultiFileSearchDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.search.CurrentBufferSet;
import org.gjt.sp.jedit.search.SearchAndReplace;
import org.gjt.sp.jedit.search.SearchFileSet;
import org.gjt.sp.jedit.search.SearchMatcher;
import org.gjt.sp.util.Log;

public class HyperSearch
extends EnhancedDialog
implements EBComponent {
    private View view;
    private SearchFileSet fileset;
    private HistoryTextField find;
    private JCheckBox ignoreCase;
    private JCheckBox regexp;
    private JCheckBox multifile;
    private JButton multifileBtn;
    private JButton findBtn;
    private JButton close;
    private JList results;
    private DefaultListModel resultModel;

    public HyperSearch(View view, String defaultFind) {
        super(view, jEdit.getProperty("hypersearch.title"), false);
        this.view = view;
        this.fileset = SearchAndReplace.getSearchFileSet();
        this.resultModel = new DefaultListModel();
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel(jEdit.getProperty("hypersearch.find")), "West");
        this.find = new HistoryTextField("find");
        panel.add((Component)this.find, "Center");
        content.add((Component)panel, "North");
        JPanel stretchPanel = new JPanel(new BorderLayout());
        panel = new JPanel();
        this.ignoreCase = new JCheckBox(jEdit.getProperty("search.ignoreCase"), SearchAndReplace.getIgnoreCase());
        this.regexp = new JCheckBox(jEdit.getProperty("search.regexp"), SearchAndReplace.getRegexp());
        this.multifile = new JCheckBox();
        this.multifile.getModel().setSelected(!(this.fileset instanceof CurrentBufferSet));
        this.multifileBtn = new JButton(jEdit.getProperty("search.multifile"));
        panel.add(this.ignoreCase);
        panel.add(this.regexp);
        panel.add(this.multifile);
        panel.add(this.multifileBtn);
        this.findBtn = new JButton(jEdit.getProperty("hypersearch.findBtn"));
        panel.add(this.findBtn);
        this.getRootPane().setDefaultButton(this.findBtn);
        this.close = new JButton(jEdit.getProperty("common.close"));
        panel.add(this.close);
        stretchPanel.add((Component)panel, "North");
        this.results = new JList();
        this.results.setVisibleRowCount(10);
        this.results.addListSelectionListener(new ListHandler());
        stretchPanel.add((Component)new JScrollPane(this.results), "Center");
        content.add((Component)stretchPanel, "Center");
        ActionHandler actionListener = new ActionHandler();
        this.multifile.addActionListener(actionListener);
        this.multifileBtn.addActionListener(actionListener);
        this.find.addActionListener(actionListener);
        this.findBtn.addActionListener(actionListener);
        this.close.addActionListener(actionListener);
        if (defaultFind != null) {
            this.find.setText(defaultFind);
            this.save();
        }
        EditBus.addToBus(this);
        this.pack();
        GUIUtilities.loadGeometry(this, "hypersearch");
        this.show();
        if (defaultFind != null) {
            this.doHyperSearch();
        }
        this.find.requestFocus();
    }

    public void save() {
        this.find.addCurrentToHistory();
        SearchAndReplace.setSearchString(this.find.getText());
        SearchAndReplace.setIgnoreCase(this.ignoreCase.getModel().isSelected());
        SearchAndReplace.setRegexp(this.regexp.getModel().isSelected());
        SearchAndReplace.setSearchFileSet(this.fileset);
    }

    public void ok() {
        this.save();
        this.doHyperSearch();
    }

    public void cancel() {
        EditBus.removeFromBus(this);
        GUIUtilities.saveGeometry(this, "hypersearch");
        this.dispose();
    }

    public void handleMessage(EBMessage msg) {
        block4: {
            Buffer buffer;
            BufferUpdate bmsg;
            block5: {
                if (!(msg instanceof BufferUpdate)) break block4;
                bmsg = (BufferUpdate)msg;
                buffer = bmsg.getBuffer();
                if (bmsg.getWhat() != BufferUpdate.CREATED) break block5;
                int i = this.resultModel.getSize() - 1;
                while (i >= 0) {
                    SearchResult result = (SearchResult)this.resultModel.elementAt(i);
                    if (buffer.getPath().equals(result.path)) {
                        result.bufferOpened(buffer);
                    }
                    --i;
                }
                break block4;
            }
            if (bmsg.getWhat() != BufferUpdate.CLOSED) break block4;
            int i = this.resultModel.getSize() - 1;
            while (i >= 0) {
                SearchResult result = (SearchResult)this.resultModel.elementAt(i);
                if (buffer == result.buffer) {
                    result.bufferClosed();
                }
                --i;
            }
        }
    }

    private void doHyperSearch() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.resultModel.removeAllElements();
            SearchMatcher matcher = SearchAndReplace.getSearchMatcher();
            if (matcher == null) {
                this.view.getToolkit().beep();
                return;
            }
            SearchFileSet fileset = SearchAndReplace.getSearchFileSet();
            Buffer buffer = fileset.getFirstBuffer(this.view);
            do {
                this.doHyperSearch(buffer, matcher);
            } while ((buffer = fileset.getNextBuffer(this.view, buffer)) != null);
            if (this.resultModel.isEmpty()) {
                this.view.getToolkit().beep();
            }
            this.results.setModel(this.resultModel);
        }
        catch (Exception e) {
            Log.log(9, this, e);
            Object[] args = new Object[]{e.getMessage()};
            if (args[0] == null) {
                args[0] = e.toString();
            }
            GUIUtilities.error(this.view, "searcherror", args);
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private boolean doHyperSearch(Buffer buffer, SearchMatcher matcher) throws Exception {
        boolean retVal = false;
        buffer.loadIfNecessary(null);
        Element map = buffer.getDefaultRootElement();
        int lines = map.getElementCount();
        int i = 0;
        while (i < lines) {
            Element lineElement = map.getElement(i);
            int start = lineElement.getStartOffset();
            String lineString = buffer.getText(start, lineElement.getEndOffset() - start - 1);
            int[] match = matcher.nextMatch(lineString);
            if (match != null) {
                this.resultModel.addElement(new SearchResult(buffer, i));
                retVal = true;
            }
            ++i;
        }
        return retVal;
    }

    private void showMultiFileDialog() {
        SearchFileSet fs = new MultiFileSearchDialog(this.view, this.fileset).getSearchFileSet();
        if (fs != null) {
            this.fileset = fs;
        }
        this.multifile.getModel().setSelected(!(this.fileset instanceof CurrentBufferSet));
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == HyperSearch.this.close) {
                HyperSearch.this.cancel();
            } else if (source == HyperSearch.this.findBtn || source == HyperSearch.this.find) {
                HyperSearch.this.ok();
            } else if (source == HyperSearch.this.multifileBtn) {
                HyperSearch.this.showMultiFileDialog();
            } else if (source == HyperSearch.this.multifile) {
                if (HyperSearch.this.multifile.getModel().isSelected()) {
                    HyperSearch.this.showMultiFileDialog();
                } else {
                    HyperSearch.this.fileset = new CurrentBufferSet();
                }
            }
        }
    }

    class ListHandler
    implements ListSelectionListener {
        ListHandler() {
        }

        public void valueChanged(ListSelectionEvent evt) {
            if (HyperSearch.this.results.isSelectionEmpty() || evt.getValueIsAdjusting()) {
                return;
            }
            SearchResult result = (SearchResult)HyperSearch.this.results.getSelectedValue();
            Buffer buffer = result.getBuffer();
            int pos = result.linePos.getOffset();
            HyperSearch.this.view.setBuffer(buffer);
            HyperSearch.this.view.getTextArea().setCaretPosition(pos);
        }
    }

    class SearchResult {
        String path;
        Buffer buffer;
        int line;
        Position linePos;
        String str;

        SearchResult(Buffer buffer, int line) {
            this.path = buffer.getPath();
            this.line = line;
            if (!buffer.isTemporary()) {
                this.bufferOpened(buffer);
            }
            this.str = String.valueOf(buffer.getName()) + ":" + (line + 1) + ":" + this.getLine(buffer, buffer.getDefaultRootElement().getElement(line));
        }

        String getLine(Buffer buffer, Element elem) {
            if (elem == null) {
                return "";
            }
            try {
                return buffer.getText(elem.getStartOffset(), elem.getEndOffset() - elem.getStartOffset() - 1);
            }
            catch (BadLocationException bl) {
                Log.log(9, this, bl);
                return "";
            }
        }

        public void bufferOpened(Buffer buffer) {
            this.buffer = buffer;
            buffer.loadIfNecessary(null);
            Element map = buffer.getDefaultRootElement();
            Element elem = map.getElement(this.line);
            if (elem == null) {
                elem = map.getElement(map.getElementCount() - 1);
            }
            try {
                this.linePos = buffer.createPosition(elem.getStartOffset());
            }
            catch (BadLocationException bl) {
                Log.log(9, this, bl);
            }
        }

        public void bufferClosed() {
            this.buffer = null;
            this.linePos = null;
        }

        public Buffer getBuffer() {
            if (this.buffer == null) {
                jEdit.openFile(null, null, this.path, false, false);
            }
            return this.buffer;
        }

        public String toString() {
            return this.str;
        }
    }
}

