/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class HistoryModel {
    private String name;
    private int max;
    private Vector data;
    private static Hashtable models;

    public HistoryModel(String name) {
        this.name = name;
        try {
            this.max = Integer.parseInt(jEdit.getProperty("history"));
        }
        catch (NumberFormatException nf) {
            this.max = 25;
        }
        this.data = new Vector(this.max);
    }

    public void addItem(String text) {
        if (text == null || text.length() == 0) {
            return;
        }
        int index = this.data.indexOf(text);
        if (index != -1) {
            this.data.removeElementAt(index);
        }
        this.data.insertElementAt(text, 0);
        if (this.getSize() > this.max) {
            this.data.removeElementAt(this.getSize() - 1);
        }
    }

    public String getItem(int index) {
        return (String)this.data.elementAt(index);
    }

    public int getSize() {
        return this.data.size();
    }

    public String getName() {
        return this.name;
    }

    public static HistoryModel getModel(String name) {
        HistoryModel model;
        if (models == null) {
            models = new Hashtable();
        }
        if ((model = (HistoryModel)models.get(name)) == null) {
            model = new HistoryModel(name);
            models.put(name, model);
        }
        return model;
    }

    public static void loadHistory(String path) {
        if (models == null) {
            models = new Hashtable();
        }
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(path));
            HistoryModel currentModel = null;
            while ((line = in.readLine()) != null) {
                if (line.startsWith("[") && line.endsWith("]")) {
                    if (currentModel != null) {
                        models.put(currentModel.getName(), currentModel);
                    }
                    currentModel = new HistoryModel(line.substring(1, line.length() - 1));
                    continue;
                }
                if (currentModel == null) {
                    throw new IOException("History data starts before model name");
                }
                currentModel.addItemToEnd(MiscUtilities.escapesToChars(line));
            }
            if (currentModel != null) {
                models.put(currentModel.getName(), currentModel);
            }
            in.close();
        }
        catch (FileNotFoundException fnf) {
            Log.log(1, HistoryModel.class, fnf);
        }
        catch (IOException io) {
            Log.log(9, HistoryModel.class, io);
        }
    }

    public static void saveHistory(String path) {
        String lineSep = System.getProperty("line.separator");
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(path));
            if (models == null) {
                out.close();
                return;
            }
            Enumeration modelEnum = models.elements();
            while (modelEnum.hasMoreElements()) {
                HistoryModel model = (HistoryModel)modelEnum.nextElement();
                out.write(91);
                out.write(model.getName());
                out.write(93);
                out.write(lineSep);
                int i = 0;
                while (i < model.getSize()) {
                    out.write(MiscUtilities.charsToEscapes(model.getItem(i)));
                    out.write(lineSep);
                    ++i;
                }
            }
            out.close();
        }
        catch (IOException io) {
            Log.log(9, HistoryModel.class, io);
        }
    }

    private void addItemToEnd(String item) {
        this.data.addElement(item);
    }
}

