/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class HelpViewer
extends JFrame {
    private static HelpViewer helpViewer;
    private JButton back;
    private JButton forward;
    private JEditorPane viewer;
    private JTextField urlField;
    private URL[] history;
    private int historyPos;

    public static void gotoURL(URL url) {
        if (helpViewer == null) {
            helpViewer = new HelpViewer(url);
        } else {
            helpViewer.gotoURL(url, true);
        }
    }

    public HelpViewer(URL url) {
        super(jEdit.getProperty("helpviewer.title"));
        this.setIconImage(GUIUtilities.getEditorIcon());
        this.history = new URL[25];
        ActionHandler actionListener = new ActionHandler();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add("West", new JLabel(jEdit.getProperty("helpviewer.url")));
        this.urlField = new JTextField();
        this.urlField.addKeyListener(new KeyHandler());
        panel.add(this.urlField);
        this.getContentPane().add("North", panel);
        this.viewer = new JEditorPane();
        this.viewer.setEditable(false);
        this.viewer.addHyperlinkListener(new LinkHandler());
        this.getContentPane().add("Center", new JScrollPane(this.viewer));
        panel = new JPanel();
        this.back = new JButton(jEdit.getProperty("helpviewer.back"));
        this.back.setIcon(new ImageIcon(this.getClass().getResource("/org/gjt/sp/jedit/toolbar/Left.gif")));
        this.back.addActionListener(actionListener);
        panel.add(this.back);
        this.forward = new JButton(jEdit.getProperty("helpviewer.forward"));
        this.forward.setIcon(new ImageIcon(this.getClass().getResource("/org/gjt/sp/jedit/toolbar/Right.gif")));
        this.forward.addActionListener(actionListener);
        panel.add(this.forward);
        this.back.setPreferredSize(this.forward.getPreferredSize());
        this.getContentPane().add("South", panel);
        this.gotoURL(url, true);
        this.setDefaultCloseOperation(2);
        this.setSize(600, 400);
        GUIUtilities.loadGeometry(this, "helpviewer");
        this.show();
    }

    public void gotoURL(URL url, boolean addToHistory) {
        this.viewer.setCursor(Cursor.getDefaultCursor());
        try {
            this.urlField.setText(url.toString());
            this.viewer.setPage(url);
            if (addToHistory) {
                this.history[this.historyPos++] = url;
                if (this.history.length == this.historyPos) {
                    System.arraycopy(this.history, 1, this.history, 0, this.history.length);
                }
                this.history[this.historyPos] = null;
            }
        }
        catch (IOException io) {
            Log.log(9, this, io);
            Object[] args = new String[]{io.getMessage()};
            GUIUtilities.error(this, "ioerror", args);
        }
    }

    public void dispose() {
        GUIUtilities.saveGeometry(this, "helpviewer");
        if (helpViewer == this) {
            helpViewer = null;
        }
        super.dispose();
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == HelpViewer.this.back) {
                if (HelpViewer.this.historyPos <= 1) {
                    HelpViewer.this.getToolkit().beep();
                } else {
                    URL[] uRLArray = HelpViewer.this.history;
                    HelpViewer helpViewer = HelpViewer.this;
                    int n = helpViewer.historyPos - 1;
                    helpViewer.historyPos = n;
                    URL url = uRLArray[n - 1];
                    HelpViewer.this.gotoURL(url, false);
                }
            } else if (source == HelpViewer.this.forward) {
                if (HelpViewer.this.history.length - HelpViewer.this.historyPos <= 1) {
                    HelpViewer.this.getToolkit().beep();
                } else {
                    URL url = HelpViewer.this.history[HelpViewer.this.historyPos];
                    if (url == null) {
                        HelpViewer.this.getToolkit().beep();
                    } else {
                        HelpViewer helpViewer = HelpViewer.this;
                        helpViewer.historyPos = helpViewer.historyPos + 1;
                        HelpViewer.this.gotoURL(url, false);
                    }
                }
            }
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        public void keyPressed(KeyEvent evt) {
            if (evt.getKeyCode() == 10) {
                try {
                    HelpViewer.this.gotoURL(new URL(HelpViewer.this.urlField.getText()), true);
                }
                catch (MalformedURLException mu) {
                    Log.log(9, this, mu);
                    Object[] args = new String[]{HelpViewer.this.urlField.getText()};
                    GUIUtilities.error(HelpViewer.this, "badurl", args);
                }
            }
        }
    }

    class LinkHandler
    implements HyperlinkListener {
        LinkHandler() {
        }

        public void hyperlinkUpdate(HyperlinkEvent evt) {
            if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                if (evt instanceof HTMLFrameHyperlinkEvent) {
                    ((HTMLDocument)HelpViewer.this.viewer.getDocument()).processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)evt);
                } else {
                    URL url = evt.getURL();
                    if (url != null) {
                        HelpViewer.this.gotoURL(url, true);
                    }
                }
            } else if (evt.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                HelpViewer.this.viewer.setCursor(Cursor.getPredefinedCursor(12));
            } else if (evt.getEventType() == HyperlinkEvent.EventType.EXITED) {
                HelpViewer.this.viewer.setCursor(Cursor.getDefaultCursor());
            }
        }
    }
}

