/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class FontComboBox
extends JComboBox {
    private static final String[] HIDEFONTS = new String[]{".bold", ".italic"};

    public FontComboBox() {
        this(FontComboBox.getAvailableFontFamilyNames());
    }

    public FontComboBox(String[] fontFamilyNames) {
        super(fontFamilyNames);
        this.setRenderer(new FontRenderer());
    }

    public static String[] getAvailableFontFamilyNames() {
        return Toolkit.getDefaultToolkit().getFontList();
    }

    private class FontRenderer
    extends JLabel
    implements ListCellRenderer {
        private ListCellRenderer defaultRenderer = new DefaultListCellRenderer();

        private FontRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (index == -1) {
                String fontFamily = (String)value;
                this.setText(fontFamily);
                Font renderFont = new Font(fontFamily, FontComboBox.this.getFont().getStyle(), FontComboBox.this.getFont().getSize());
                super.setFont(renderFont);
                return this;
            }
            return this.defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }

        public void setFont(Font font) {
        }
    }
}

