/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.jEdit;

public class EnhancedMenuItem
extends JMenuItem {
    private String keyBinding;
    private String keyBindingProp;
    private EditAction action;
    private static Font acceleratorFont = UIManager.getFont("MenuItem.acceleratorFont");
    private static Color acceleratorForeground;
    private static Color acceleratorSelectionForeground;

    static {
        acceleratorFont = new Font("Monospaced", acceleratorFont.getStyle(), acceleratorFont.getSize());
        acceleratorForeground = UIManager.getColor("MenuItem.acceleratorForeground");
        acceleratorSelectionForeground = UIManager.getColor("MenuItem.acceleratorSelectionForeground");
    }

    public EnhancedMenuItem(String label, String keyBinding, EditAction action, String actionCommand) {
        super(label);
        this.keyBinding = keyBinding;
        this.action = action;
        if (action != null) {
            this.setEnabled(true);
            this.addActionListener(action);
            this.keyBindingProp = String.valueOf(action.getName()) + ".shortcut";
        } else {
            this.setEnabled(false);
        }
        this.setActionCommand(actionCommand);
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        String keyBinding = this.getKeyBinding();
        if (keyBinding != null) {
            d.width += this.getToolkit().getFontMetrics(acceleratorFont).stringWidth(keyBinding) + 30;
        }
        return d;
    }

    public void paint(Graphics g) {
        super.paint(g);
        String keyBinding = this.getKeyBinding();
        if (keyBinding != null) {
            g.setFont(acceleratorFont);
            g.setColor(this.getModel().isArmed() ? acceleratorSelectionForeground : acceleratorForeground);
            FontMetrics fm = g.getFontMetrics();
            Insets insets = this.getInsets();
            g.drawString(keyBinding, this.getWidth() - (fm.stringWidth(keyBinding) + insets.right + insets.left), this.getFont().getSize() + (insets.top - 1));
        }
    }

    public String getActionCommand() {
        return this.getModel().getActionCommand();
    }

    private String getKeyBinding() {
        if (this.action == null) {
            return null;
        }
        if (this.keyBinding == null && this.getActionCommand() == null) {
            return jEdit.getProperty(this.keyBindingProp);
        }
        return this.keyBinding;
    }
}

