/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;

public class CloseDialog
extends EnhancedDialog {
    public HashMap show2Name = new HashMap();
    private View view;
    private JList bufferList;
    private DefaultListModel bufferModel;
    private JButton save;
    private JButton discard;
    private JButton cancel;
    private boolean ok;

    public CloseDialog(View view) {
        super(view, jEdit.getProperty("close.title"), true);
        try {
            this.view = view;
            this.getContentPane().add("North", new JLabel(jEdit.getProperty("close.caption")));
            this.bufferModel = new DefaultListModel();
            this.bufferList = new JList(this.bufferModel);
            this.bufferList.setVisibleRowCount(10);
            this.bufferList.addListSelectionListener(new ListHandler());
            Buffer[] buffers = jEdit.getBuffers();
            int i = 0;
            while (i < buffers.length) {
                Buffer buffer = buffers[i];
                if (buffer.isDirty()) {
                    String t = "\u5f53\u524d\u7f16\u8f91\u5185\u5bb9" + (i > 0 ? String.valueOf(i) : "");
                    this.bufferModel.addElement(t);
                    this.show2Name.put(t, buffer.getPath());
                }
                ++i;
            }
            this.getContentPane().add("Center", new JScrollPane(this.bufferList));
            ActionHandler actionListener = new ActionHandler();
            JPanel buttons = new JPanel();
            this.save = new JButton(jEdit.getProperty("close.save"));
            buttons.add(this.save);
            this.save.setMnemonic(jEdit.getProperty("close.save.mnemonic").charAt(0));
            this.save.addActionListener(actionListener);
            this.discard = new JButton(jEdit.getProperty("close.discard"));
            buttons.add(this.discard);
            this.discard.setMnemonic(jEdit.getProperty("close.discard.mnemonic").charAt(0));
            this.discard.addActionListener(actionListener);
            this.cancel = new JButton(jEdit.getProperty("common.cancel"));
            buttons.add(this.cancel);
            this.cancel.addActionListener(actionListener);
            this.bufferList.setSelectedIndex(0);
            this.getContentPane().add("South", buttons);
            Dimension screen = this.getToolkit().getScreenSize();
            this.pack();
            this.setLocation((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2);
            this.show();
        }
        catch (Exception ee) {
            this.alert(ee.getClass().getName());
        }
    }

    public void alert(String s) {
        JOptionPane.showMessageDialog(null, s, "\u63d0\u793a", 2);
    }

    public boolean isOK() {
        return this.ok;
    }

    public void ok() {
    }

    public void cancel() {
        this.dispose();
    }

    private void updateButtons() {
        int index = this.bufferList.getSelectedIndex();
        this.save.getModel().setEnabled(index != -1);
        this.discard.getModel().setEnabled(index != -1);
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == CloseDialog.this.save) {
                Object[] paths = CloseDialog.this.bufferList.getSelectedValues();
                int i = 0;
                while (i < paths.length) {
                    String path = CloseDialog.this.show2Name.get((String)paths[i]).toString();
                    Buffer buffer = jEdit.getBuffer(path);
                    if (!buffer.save(CloseDialog.this.view, null)) {
                        return;
                    }
                    jEdit._closeBuffer(CloseDialog.this.view, buffer);
                    CloseDialog.this.bufferModel.removeElement((String)paths[i]);
                    ++i;
                }
                CloseDialog.this.updateButtons();
                if (CloseDialog.this.bufferModel.getSize() == 0) {
                    CloseDialog.this.ok = true;
                    CloseDialog.this.dispose();
                }
            } else if (source == CloseDialog.this.discard) {
                Object[] paths = CloseDialog.this.bufferList.getSelectedValues();
                int i = 0;
                while (i < paths.length) {
                    String path = CloseDialog.this.show2Name.get((String)paths[i]).toString();
                    Buffer buffer = jEdit.getBuffer(path);
                    jEdit._closeBuffer(CloseDialog.this.view, buffer);
                    CloseDialog.this.bufferModel.removeElement((String)paths[i]);
                    ++i;
                }
                CloseDialog.this.updateButtons();
                if (CloseDialog.this.bufferModel.getSize() == 0) {
                    CloseDialog.this.ok = true;
                    CloseDialog.this.dispose();
                }
            } else if (source == CloseDialog.this.cancel) {
                CloseDialog.this.cancel();
            }
        }
    }

    class ListHandler
    implements ListSelectionListener {
        ListHandler() {
        }

        public void valueChanged(ListSelectionEvent evt) {
            int index = CloseDialog.this.bufferList.getSelectedIndex();
            if (index != -1) {
                String path = (String)CloseDialog.this.bufferModel.getElementAt(index);
                path = CloseDialog.this.show2Name.get(path).toString();
                Buffer buffer = jEdit.getBuffer(path);
                CloseDialog.this.view.setBuffer(buffer);
            }
            CloseDialog.this.updateButtons();
        }
    }
}

