/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;

public class BufferTabs
extends JTabbedPane {
    private View view;
    private Vector buffers;
    private boolean removing;
    private boolean updating;
    private static ImageIcon newDirtyIcon = new ImageIcon(BufferTabs.class.getResource("/org/gjt/sp/jedit/new_dirty.gif"));
    private static ImageIcon newIcon = new ImageIcon(BufferTabs.class.getResource("/org/gjt/sp/jedit/new.gif"));
    private static ImageIcon dirtyIcon = new ImageIcon(BufferTabs.class.getResource("/org/gjt/sp/jedit/dirty.gif"));
    private static ImageIcon normalIcon = new ImageIcon(BufferTabs.class.getResource("/org/gjt/sp/jedit/normal.gif"));

    public BufferTabs(View view) {
        this.view = view;
        this.buffers = new Vector();
        Buffer buffer = jEdit.getFirstBuffer();
        while (buffer != null) {
            this.addBufferTab(buffer);
            buffer = buffer.getNext();
        }
        this.update();
        this.addChangeListener(new ChangeHandler());
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public boolean isRequestFocusEnabled() {
        return false;
    }

    public void addBufferTab(Buffer buffer) {
        int index = buffer.getIndex();
        int selectedIndex = this.getSelectedIndex();
        this.buffers.insertElementAt(buffer, index);
        this.insertTab(buffer.getName(), this.getIcon(buffer), new Magic(buffer), "", index);
        if (index <= selectedIndex) {
            this.setSelectedIndex(++selectedIndex);
        }
    }

    public void removeBufferTab(Buffer buffer) {
        Magic comp;
        int index = this.buffers.indexOf(buffer);
        int selectedIndex = this.getSelectedIndex();
        this.buffers.removeElementAt(index);
        this.removeTabAt(index);
        if (index < selectedIndex) {
            if (selectedIndex != 0) {
                --selectedIndex;
            }
            this.setSelectedIndex(selectedIndex);
        } else if (index == selectedIndex && (comp = (Magic)this.getSelectedComponent()) != null) {
            comp.update();
        }
    }

    public void updateBufferTab(Buffer buffer) {
        if (buffer.isDirty()) {
            int index = buffer.getIndex();
            this.setIconAt(index, this.getIcon(buffer));
        } else {
            this.updating = true;
            this.removeBufferTab(buffer);
            this.addBufferTab(buffer);
            this.updating = false;
            if (this.view.getBuffer() == buffer) {
                this.selectBufferTab(buffer);
            }
        }
    }

    public void selectBufferTab(Buffer buffer) {
        int selectedIndex;
        int index = buffer.getIndex();
        if (index == (selectedIndex = this.getSelectedIndex())) {
            this.update();
        } else {
            this.setSelectedIndex(index);
        }
    }

    public void update() {
        ((Magic)this.getSelectedComponent()).update();
    }

    private ImageIcon getIcon(Buffer buffer) {
        if (buffer.isNewFile()) {
            if (buffer.isDirty()) {
                return newDirtyIcon;
            }
            return newIcon;
        }
        if (buffer.isDirty()) {
            return dirtyIcon;
        }
        return normalIcon;
    }

    class ChangeHandler
    implements ChangeListener {
        ChangeHandler() {
        }

        public void stateChanged(ChangeEvent evt) {
            if (BufferTabs.this.updating) {
                return;
            }
            int index = BufferTabs.this.getSelectedIndex();
            Buffer buffer = jEdit.getFirstBuffer();
            while (buffer != null) {
                if (index == 0) break;
                buffer = buffer.getNext();
                --index;
            }
            Magic comp = (Magic)BufferTabs.this.getSelectedComponent();
            if (comp != null) {
                comp.select();
            }
        }
    }

    class Magic
    extends JPanel {
        Buffer buffer;

        Magic(Buffer buffer) {
            super(new BorderLayout());
            this.buffer = buffer;
        }

        void select() {
            BufferTabs.this.view.setBuffer(this.buffer);
            this.update();
        }

        void update() {
            JComponent comp = BufferTabs.this.view.getSplitPane() == null ? BufferTabs.this.view.getTextArea() : BufferTabs.this.view.getSplitPane();
            this.add("Center", comp);
            this.revalidate();
            BufferTabs.this.view.focusOnTextArea();
        }

        public boolean isValidateRoot() {
            return true;
        }
    }
}

