/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;

public class BufferOptions
extends EnhancedDialog {
    private View view;
    private Buffer buffer;
    private JComboBox tabSize;
    private Mode[] modes;
    private JComboBox mode;
    private JComboBox lineSeparator;
    private JCheckBox indentOnTab;
    private JCheckBox indentOnEnter;
    private JCheckBox syntax;
    private JCheckBox noTabs;
    private JButton ok;
    private JButton cancel;

    public BufferOptions(View view) {
        super(view, jEdit.getProperty("buffer_options.title"), true);
        this.view = view;
        this.buffer = view.getBuffer();
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = 0;
        cons.gridx = 0;
        cons.gridwidth = 3;
        cons.gridheight = 1;
        cons.fill = 1;
        cons.weightx = 1.0;
        JLabel label = new JLabel(jEdit.getProperty("options.editor.tabSize"), 4);
        layout.setConstraints(label, cons);
        panel.add(label);
        cons.gridx = 3;
        cons.gridwidth = 1;
        String[] tabSizes = new String[]{"8", "4"};
        this.tabSize = new JComboBox<String>(tabSizes);
        this.tabSize.setEditable(true);
        this.tabSize.setSelectedItem(this.buffer.getProperty("tabSize"));
        layout.setConstraints(this.tabSize, cons);
        panel.add(this.tabSize);
        cons.gridx = 0;
        cons.gridy = 1;
        cons.gridwidth = 3;
        label = new JLabel(jEdit.getProperty("buffer_options.mode"), 4);
        layout.setConstraints(label, cons);
        panel.add(label);
        cons.gridx = 3;
        cons.gridwidth = 1;
        this.modes = jEdit.getModes();
        String[] modeNames = new String[this.modes.length];
        int i = 0;
        while (i < this.modes.length) {
            modeNames[i] = this.modes[i].getName();
            ++i;
        }
        this.mode = new JComboBox<String>(modeNames);
        this.mode.setSelectedItem(this.buffer.getMode().getName());
        layout.setConstraints(this.mode, cons);
        panel.add(this.mode);
        cons.gridx = 0;
        cons.gridy = 2;
        cons.gridwidth = 3;
        label = new JLabel(jEdit.getProperty("buffer_options.lineSeparator"), 4);
        layout.setConstraints(label, cons);
        panel.add(label);
        cons.gridx = 3;
        cons.gridwidth = 1;
        String[] lineSeps = new String[]{jEdit.getProperty("lineSep.unix"), jEdit.getProperty("lineSep.windows"), jEdit.getProperty("lineSep.mac")};
        this.lineSeparator = new JComboBox<String>(lineSeps);
        String lineSep = (String)this.buffer.getProperty("lineSeparator");
        if (lineSep == null) {
            lineSep = System.getProperty("line.separator");
        }
        if ("\n".equals(lineSep)) {
            this.lineSeparator.setSelectedIndex(0);
        } else if ("\r\n".equals(lineSep)) {
            this.lineSeparator.setSelectedIndex(1);
        } else if ("\r".equals(lineSep)) {
            this.lineSeparator.setSelectedIndex(2);
        }
        layout.setConstraints(this.lineSeparator, cons);
        panel.add(this.lineSeparator);
        cons.gridx = 0;
        cons.gridy = 3;
        cons.gridwidth = 0;
        cons.fill = 0;
        cons.anchor = 17;
        this.syntax = new JCheckBox(jEdit.getProperty("options.editor.syntax"));
        this.syntax.getModel().setSelected("on".equals(this.buffer.getProperty("syntax")));
        layout.setConstraints(this.syntax, cons);
        panel.add(this.syntax);
        cons.gridy = 4;
        this.indentOnTab = new JCheckBox(jEdit.getProperty("options.editor.indentOnTab"));
        this.indentOnTab.getModel().setSelected("on".equals(this.buffer.getProperty("indentOnTab")));
        layout.setConstraints(this.indentOnTab, cons);
        panel.add(this.indentOnTab);
        cons.gridy = 5;
        this.indentOnEnter = new JCheckBox(jEdit.getProperty("options.editor.indentOnEnter"));
        this.indentOnEnter.getModel().setSelected("on".equals(this.buffer.getProperty("indentOnEnter")));
        layout.setConstraints(this.indentOnEnter, cons);
        panel.add(this.indentOnEnter);
        cons.gridy = 6;
        this.noTabs = new JCheckBox(jEdit.getProperty("options.editor.noTabs"));
        this.noTabs.getModel().setSelected("yes".equals(this.buffer.getProperty("noTabs")));
        layout.setConstraints(this.noTabs, cons);
        panel.add(this.noTabs);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("Center", panel);
        ActionHandler actionListener = new ActionHandler();
        panel = new JPanel();
        this.ok = new JButton(jEdit.getProperty("common.ok"));
        this.ok.addActionListener(actionListener);
        this.getRootPane().setDefaultButton(this.ok);
        panel.add(this.ok);
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        this.cancel.addActionListener(actionListener);
        panel.add(this.cancel);
        this.getContentPane().add("South", panel);
        Dimension screen = this.getToolkit().getScreenSize();
        this.pack();
        this.setLocation((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2);
        this.show();
    }

    public void ok() {
        String lineSep;
        try {
            this.buffer.putProperty("tabSize", new Integer(this.tabSize.getSelectedItem().toString()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int index = this.mode.getSelectedIndex();
        this.buffer.setMode(this.modes[index]);
        index = this.lineSeparator.getSelectedIndex();
        if (index == 0) {
            lineSep = "\n";
        } else if (index == 1) {
            lineSep = "\r\n";
        } else if (index == 2) {
            lineSep = "\r";
        } else {
            throw new InternalError();
        }
        this.buffer.putProperty("lineSeparator", lineSep);
        this.buffer.putProperty("syntax", this.syntax.getModel().isSelected() ? "on" : "off");
        this.buffer.putProperty("indentOnTab", this.indentOnTab.getModel().isSelected() ? "on" : "off");
        this.buffer.putProperty("indentOnEnter", this.indentOnEnter.getModel().isSelected() ? "on" : "off");
        this.buffer.putProperty("noTabs", this.noTabs.getModel().isSelected() ? "yes" : "no");
        this.buffer.propertiesChanged();
        this.dispose();
        this.view.getTextArea().getPainter().repaint();
    }

    public void cancel() {
        this.dispose();
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == BufferOptions.this.ok) {
                BufferOptions.this.ok();
            } else if (source == BufferOptions.this.cancel) {
                BufferOptions.this.cancel();
            }
        }
    }
}

