/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.actions;

import java.awt.event.ActionEvent;
import javax.swing.text.BadLocationException;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.util.Log;

public class word_count
extends EditAction {
    public void actionPerformed(ActionEvent evt) {
        View view = word_count.getView(evt);
        Buffer buffer = view.getBuffer();
        String selection = view.getTextArea().getSelectedText();
        if (selection != null) {
            this.doWordCount(view, selection);
            return;
        }
        try {
            this.doWordCount(view, buffer.getText(0, buffer.getLength()));
        }
        catch (BadLocationException bl) {
            Log.log(9, this, bl);
        }
    }

    private void doWordCount(View view, String text) {
        char[] chars = text.toCharArray();
        int characters = chars.length;
        int words = characters == 0 ? 0 : 1;
        int lines = 1;
        boolean word = false;
        int i = 0;
        while (i < chars.length) {
            switch (chars[i]) {
                case '\n': 
                case '\r': {
                    ++lines;
                }
                case '\t': 
                case ' ': {
                    if (!word) break;
                    ++words;
                    word = false;
                    break;
                }
                default: {
                    word = true;
                }
            }
            ++i;
        }
        Object[] args = new Object[]{new Integer(characters), new Integer(words), new Integer(lines)};
        GUIUtilities.message(view, "wordcount", args);
    }
}

