/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.actions;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.event.ActionEvent;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.syntax.SyntaxUtilities;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.jedit.syntax.TokenMarker;
import org.gjt.sp.jedit.textarea.JEditTextArea;

public class print
extends EditAction {
    public void actionPerformed(ActionEvent evt) {
        int rightMargin;
        int bottomMargin;
        int leftMargin;
        int topMargin;
        View view = print.getView(evt);
        Buffer buffer = view.getBuffer();
        PrintJob job = view.getToolkit().getPrintJob(view, buffer.getName(), null);
        if (job == null) {
            return;
        }
        int ppi = job.getPageResolution();
        try {
            topMargin = (int)(Float.valueOf(jEdit.getProperty("buffer.margin.top")).floatValue() * (float)ppi);
        }
        catch (NumberFormatException nf) {
            topMargin = ppi / 2;
        }
        try {
            leftMargin = (int)(Float.valueOf(jEdit.getProperty("buffer.margin.left")).floatValue() * (float)ppi);
        }
        catch (NumberFormatException nf) {
            leftMargin = ppi / 2;
        }
        try {
            bottomMargin = (int)(Float.valueOf(jEdit.getProperty("buffer.margin.bottom")).floatValue() * (float)ppi);
        }
        catch (NumberFormatException nf) {
            bottomMargin = topMargin;
        }
        try {
            rightMargin = (int)(Float.valueOf(jEdit.getProperty("buffer.margin.right")).floatValue() * (float)ppi);
        }
        catch (NumberFormatException nf) {
            rightMargin = leftMargin;
        }
        String header = buffer.getPath();
        JEditTextArea textArea = view.getTextArea();
        int tabSize = buffer.getTabSize() * textArea.getToolkit().getFontMetrics(textArea.getFont()).charWidth('m');
        Segment lineSegment = new Segment();
        TokenMarker tokenMarker = textArea.getTokenMarker();
        SyntaxStyle[] styles = textArea.getPainter().getStyles();
        PrintTabExpander expander = new PrintTabExpander(leftMargin, tabSize);
        Graphics gfx = null;
        Font font = textArea.getPainter().getFont();
        FontMetrics fm = null;
        Dimension pageDimension = job.getPageDimension();
        int pageWidth = pageDimension.width;
        int pageHeight = pageDimension.height;
        int y = 0;
        int i = 0;
        while (i < textArea.getLineCount()) {
            if (gfx == null) {
                gfx = job.getGraphics();
                gfx.setFont(font);
                gfx.setColor(Color.lightGray);
                fm = gfx.getFontMetrics();
                gfx.fillRect(leftMargin, topMargin, pageWidth - leftMargin - rightMargin, fm.getHeight());
                gfx.setColor(Color.black);
                y = topMargin + fm.getHeight() - fm.getDescent() - fm.getLeading();
                gfx.drawString(header, leftMargin, y);
                y += fm.getHeight();
            }
            y += fm.getHeight();
            textArea.getLineText(i, lineSegment);
            if (tokenMarker == null) {
                gfx.setColor(Color.black);
                gfx.setFont(font);
                Utilities.drawTabbedText(lineSegment, leftMargin, y, gfx, (TabExpander)expander, 0);
            } else {
                gfx.setColor(Color.black);
                gfx.setFont(font);
                Token tokens = tokenMarker.markTokens(lineSegment, i);
                SyntaxUtilities.paintSyntaxLine(lineSegment, tokens, styles, expander, gfx, leftMargin, y);
            }
            if (y > pageHeight - bottomMargin || i == textArea.getLineCount() - 1) {
                gfx.dispose();
                gfx = null;
            }
            ++i;
        }
        job.end();
    }

    class PrintTabExpander
    implements TabExpander {
        private int leftMargin;
        private int tabSize;

        public PrintTabExpander(int leftMargin, int tabSize) {
            this.leftMargin = leftMargin;
            this.tabSize = tabSize;
        }

        public float nextTabStop(float x, int tabOffset) {
            int ntabs = ((int)x - this.leftMargin) / this.tabSize;
            return (ntabs + 1) * this.tabSize + this.leftMargin;
        }
    }
}

