/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.actions;

import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.text.BadLocationException;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.util.Log;

public class complete_word
extends EditAction {
    private boolean createSet = true;
    private boolean forward = true;
    private Vector wordSet = new Vector();
    private View view;
    private Buffer buffer;
    private JEditTextArea textArea;
    private String separators;
    private String line;
    private String word;
    private int dot;
    private int dotdot;
    private int lineNo;
    private int start;
    private int len;
    private int wordStart;
    private int lineCount;
    private int count = 1;
    private int myLength;
    private int[] array;

    public void actionPerformed(ActionEvent evt) {
        this.view = complete_word.getView(evt);
        this.buffer = this.view.getBuffer();
        this.textArea = this.view.getTextArea();
        this.separators = (String)this.buffer.getProperty("noWordSep");
        this.dot = this.textArea.getSelectionStart();
        this.lineNo = this.textArea.getSelectionStartLine();
        this.start = this.textArea.getLineStartOffset(this.lineNo);
        this.len = this.textArea.getLineEndOffset(this.lineNo) - this.start - 1;
        this.lineCount = this.textArea.getLineCount();
        if (this.createSet) {
            this.word = this.getWord();
            this.firstTurn(this.word);
        } else {
            String newString = this.getWord();
            if (newString == null) {
                this.createSet = true;
                return;
            }
            int wordLength = this.word.length();
            if (newString.length() < wordLength || !this.wordSet.contains(newString.substring(this.word.length())) || this.dotdot + this.myLength < this.dot) {
                this.createSet = true;
                this.count = 1;
                this.firstTurn(newString);
                return;
            }
            int size = this.wordSet.size() - 1;
            if (size > 0) {
                if (this.count < size & this.forward) {
                    this.textArea.setSelectionStart(this.dotdot);
                    this.textArea.setSelectedText((String)this.wordSet.elementAt(this.count));
                    this.myLength = ((String)this.wordSet.elementAt(this.count)).length();
                    ++this.count;
                } else {
                    this.textArea.setSelectionStart(this.dotdot);
                    this.textArea.setSelectedText((String)this.wordSet.elementAt(this.count));
                    this.myLength = ((String)this.wordSet.elementAt(this.count)).length();
                    this.count = 0;
                }
            } else {
                this.createSet = true;
                return;
            }
        }
    }

    private void firstTurn(String string) {
        this.word = string;
        if (string == null) {
            return;
        }
        this.wordSet.removeAllElements();
        this.array = null;
        this.fillWordSet(this.wordSet, string);
        if (this.wordSet.isEmpty()) {
            return;
        }
        if (this.wordSet.size() == 1) {
            this.dotdot = this.textArea.getSelectionStart();
            this.textArea.setSelectedText((String)this.wordSet.elementAt(0));
            this.myLength = ((String)this.wordSet.elementAt(0)).length();
            return;
        }
        this.dotdot = this.textArea.getSelectionStart();
        this.textArea.setSelectedText((String)this.wordSet.elementAt(0));
        this.myLength = ((String)this.wordSet.elementAt(0)).length();
        this.createSet = false;
    }

    private void addString(Vector vector, String string) {
        if (!vector.contains(string)) {
            vector.addElement(string);
        }
    }

    private void fillWordSet(Vector vector, String string) {
        try {
            int i = this.lineCount - 1;
            while (i >= 0) {
                int lineStart = this.textArea.getLineStartOffset(i);
                int lineLen = this.textArea.getLineEndOffset(i) - lineStart - 1;
                this.line = this.buffer.getText(lineStart, lineLen);
                int[] array = this.getIndexOfWord(this.line, string, this.separators);
                int y = 0;
                while (y < array.length) {
                    int index = array[y];
                    if (index != -1) {
                        int wordEnd = lineLen;
                        int j = index + 1;
                        block7: while (j < lineLen) {
                            char c = this.line.charAt(j);
                            switch (c) {
                                case '\t': 
                                case ' ': {
                                    wordEnd = j;
                                    break block7;
                                }
                                default: {
                                    if (!(Character.isLetterOrDigit(c) || this.separators != null && this.separators.indexOf(c) != -1)) {
                                        wordEnd = j;
                                        break block7;
                                    }
                                    ++j;
                                }
                            }
                        }
                        String temp = this.line.substring(index + string.length(), wordEnd);
                        if (temp.length() != 0) {
                            this.addString(vector, temp);
                        }
                    }
                    ++y;
                }
                --i;
            }
            this.array = null;
        }
        catch (BadLocationException bl) {
            Log.log(9, this, bl);
        }
    }

    private String getWord() {
        try {
            this.line = this.buffer.getText(this.start, this.len);
            this.wordStart = this.start;
            int i = this.dot - 1;
            block5: while (i >= this.start) {
                char c = this.line.charAt(i - this.start);
                switch (c) {
                    case '\t': 
                    case ' ': {
                        this.wordStart = i + 1;
                        break block5;
                    }
                    default: {
                        if (!(Character.isLetterOrDigit(c) || this.separators != null && this.separators.indexOf(c) != -1)) {
                            this.wordStart = i + 1;
                            break block5;
                        }
                        --i;
                    }
                }
            }
            if (this.wordStart == this.dot) {
                this.view.getToolkit().beep();
                return null;
            }
        }
        catch (BadLocationException bl) {
            Log.log(9, this, bl);
        }
        return this.line.substring(this.wordStart - this.start, this.dot - this.start);
    }

    private int[] getIndexOfWord(String line, String word, String separators) {
        this.array = new int[line.length()];
        int i = 0;
        while (i < line.length()) {
            if (i == 0 && line.regionMatches(0, word, 0, word.length())) {
                this.array[i] = 0;
            } else {
                char c = line.charAt(i);
                if (!(Character.isLetterOrDigit(c) || separators != null && separators.indexOf(c) != -1)) {
                    this.array[i] = -1;
                    if (line.regionMatches(i + 1, word, 0, word.length())) {
                        this.array[i] = i + 1;
                    }
                } else {
                    this.array[i] = -1;
                }
            }
            ++i;
        }
        return this.array;
    }
}

