/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Stack;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.gjt.sp.jedit.textarea.JEditTextArea;

class StatusBar
extends JComponent {
    Stack status = new Stack();
    JEditTextArea textArea;

    StatusBar(JEditTextArea textArea) {
        this.textArea = textArea;
        this.setDoubleBuffered(true);
        this.setFont(UIManager.getFont("Label.font"));
        this.setForeground(UIManager.getColor("Label.foreground"));
        this.setBackground(UIManager.getColor("Label.background"));
    }

    void pushStatus(String str) {
        this.status.push(str);
        this.repaint();
    }

    void popStatus() {
        if (this.status.isEmpty()) {
            return;
        }
        this.status.pop();
        this.repaint();
    }

    public void paint(Graphics g) {
        FontMetrics fm = g.getFontMetrics();
        int dot2 = this.textArea.getCaretPosition();
        int currLine = this.textArea.getCaretLine();
        int start = this.textArea.getLineStartOffset(currLine);
        int numLines = this.textArea.getLineCount();
        String str = this.status.isEmpty() ? "col " + (dot2 - start + 1) + " line " + (currLine + 1) + "/" + numLines + " " + (currLine + 1) * 100 / numLines + "%" : (String)this.status.peek();
        g.drawString(str, 0, (this.getHeight() + fm.getAscent()) / 2);
    }

    public Dimension getPreferredSize() {
        return new Dimension(200, 0);
    }
}

