/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.util.Log;

public class Registers {
    private static Register[] registers;

    static {
        Registers.setRegister('$', new ClipboardRegister());
    }

    public static Register getRegister(char name) {
        if (registers == null || name >= registers.length) {
            return null;
        }
        return registers[name];
    }

    public static void setRegister(char name, Register newRegister) {
        if (registers == null) {
            registers = new Register[name + '\u0001'];
            Registers.registers[name] = newRegister;
        } else if (name >= registers.length) {
            Register[] newRegisters = new Register[Math.min(65536, name * 2)];
            System.arraycopy(registers, 0, newRegisters, 0, registers.length);
            registers = newRegisters;
            Registers.registers[name] = newRegister;
        } else {
            Register register = registers[name];
            if (register instanceof ClipboardRegister) {
                if (newRegister instanceof StringRegister) {
                    ((ClipboardRegister)register).setValue(newRegister.toString());
                }
            } else {
                if (register != null) {
                    register.dispose();
                }
                Registers.registers[name] = newRegister;
            }
        }
    }

    public static void clearRegister(char name) {
        if (name >= registers.length) {
            return;
        }
        Register register = registers[name];
        if (register instanceof ClipboardRegister) {
            ((ClipboardRegister)register).setValue("");
        } else {
            if (register != null) {
                register.dispose();
            }
            Registers.registers[name] = null;
        }
    }

    public static Register[] getRegisters() {
        return registers;
    }

    private Registers() {
    }

    public static class CaretRegister
    implements Register,
    EBComponent {
        private String path;
        private int offset;
        private Buffer buffer;
        private Position pos;

        public CaretRegister(Buffer buffer, int offset) {
            this.path = buffer.getPath();
            this.offset = offset;
            this.buffer = buffer;
            try {
                this.pos = buffer.createPosition(offset);
            }
            catch (BadLocationException bl) {
                Log.log(9, this, bl);
            }
            EditBus.addToBus(this);
        }

        public String toString() {
            if (this.buffer == null) {
                return String.valueOf(this.path) + ":" + this.offset;
            }
            return String.valueOf(this.buffer.getPath()) + ":" + this.pos.getOffset();
        }

        public void dispose() {
            EditBus.removeFromBus(this);
        }

        public Buffer getBuffer() {
            if (this.buffer == null) {
                return jEdit.openFile(null, null, this.path, false, false);
            }
            return this.buffer;
        }

        public int getOffset() {
            if (this.pos == null) {
                return this.offset;
            }
            return this.pos.getOffset();
        }

        public void handleMessage(EBMessage msg) {
            if (msg instanceof BufferUpdate) {
                this.handleBufferUpdate((BufferUpdate)msg);
            }
        }

        private void handleBufferUpdate(BufferUpdate msg) {
            Buffer _buffer = msg.getBuffer();
            if (msg.getWhat() == BufferUpdate.CREATED) {
                if (this.buffer == null && _buffer.getPath().equals(this.path)) {
                    this.buffer = _buffer;
                    try {
                        this.pos = this.buffer.createPosition(this.offset);
                    }
                    catch (BadLocationException bl) {
                        Log.log(9, this, bl);
                    }
                }
            } else if (msg.getWhat() == BufferUpdate.CLOSED && _buffer == this.buffer) {
                this.buffer = null;
                this.offset = this.pos.getOffset();
                this.pos = null;
            }
        }
    }

    public static class ClipboardRegister
    implements Register {
        public void setValue(String value) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection selection = new StringSelection(value);
            clipboard.setContents(selection, null);
        }

        public String toString() {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            try {
                String selection = (String)clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor);
                return selection.replace('\r', '\n');
            }
            catch (Exception e) {
                Log.log(5, this, e);
                return null;
            }
        }

        public void dispose() {
        }
    }

    public static interface Register {
        public String toString();

        public void dispose();
    }

    public static class StringRegister
    implements Register {
        private String value;

        public StringRegister(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public void dispose() {
        }
    }
}

