/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.util.Enumeration;
import java.util.Vector;
import org.gjt.sp.jedit.OptionPane;
import org.gjt.sp.util.Log;

public class OptionGroup {
    private String name;
    private Vector members;

    public OptionGroup(String name) {
        this.name = name;
        this.members = new Vector();
    }

    public String getName() {
        return this.name;
    }

    public void addOptionGroup(OptionGroup group) {
        if (this.members.indexOf(group) != -1) {
            return;
        }
        this.members.addElement(group);
    }

    public void addOptionPane(OptionPane pane) {
        if (this.members.indexOf(pane) != -1) {
            return;
        }
        this.members.addElement(pane);
    }

    public Enumeration getMembers() {
        return this.members.elements();
    }

    public Object getMember(int index) {
        return index >= 0 && index < this.members.size() ? this.members.elementAt(index) : null;
    }

    public int getMemberIndex(Object member) {
        return this.members.indexOf(member);
    }

    public int getMemberCount() {
        return this.members.size();
    }

    public void save() {
        Enumeration enume = this.members.elements();
        while (enume.hasMoreElements()) {
            Object elem = enume.nextElement();
            try {
                if (elem instanceof OptionPane) {
                    ((OptionPane)elem).save();
                    continue;
                }
                if (!(elem instanceof OptionGroup)) continue;
                ((OptionGroup)elem).save();
            }
            catch (Throwable t) {
                Log.log(9, elem, "Error saving option pane");
                Log.log(9, elem, t);
            }
        }
    }
}

