/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import gnu.regexp.RE;
import gnu.regexp.REException;
import javax.swing.text.BadLocationException;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.syntax.TokenMarker;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.TextUtilities;
import org.gjt.sp.util.Log;

public class Mode {
    protected RE filenameRE;
    protected RE firstlineRE;
    private String name;

    public Mode(String name) {
        this.name = name;
        try {
            String firstlineGlob;
            String filenameGlob = (String)this.getProperty("filenameGlob");
            if (filenameGlob != null) {
                this.filenameRE = new RE(MiscUtilities.globToRE(filenameGlob), 2);
            }
            if ((firstlineGlob = (String)this.getProperty("firstlineGlob")) != null) {
                this.firstlineRE = new RE(MiscUtilities.globToRE(firstlineGlob), 2);
            }
        }
        catch (REException re) {
            Log.log(9, this, "Invalid filename/firstline globs in mode " + name);
            Log.log(9, this, re);
        }
        this.initKeyBindings();
    }

    public void enter(Buffer buffer) {
    }

    public void enterView(View view) {
    }

    public void leave(Buffer buffer) {
    }

    public void leaveView(View view) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean indentLine(Buffer buffer, View view, int lineIndex, boolean force) {
        JEditTextArea textArea = view.getTextArea();
        String openBrackets = (String)this.getProperty("indentOpenBrackets");
        String closeBrackets = (String)this.getProperty("indentCloseBrackets");
        if (openBrackets == null) {
            openBrackets = "";
        }
        if (closeBrackets == null) {
            closeBrackets = "";
        }
        int tabSize = buffer.getTabSize();
        boolean noTabs = "yes".equals(buffer.getProperty("noTabs"));
        if (lineIndex == 0) {
            return false;
        }
        String line = textArea.getLineText(lineIndex);
        int start = textArea.getLineStartOffset(lineIndex);
        String prevLine = null;
        int i = lineIndex - 1;
        while (i >= 0) {
            if (textArea.getLineLength(i) != 0) {
                prevLine = textArea.getLineText(i);
                break;
            }
            --i;
        }
        if (prevLine == null) {
            return false;
        }
        boolean prevLineStart = true;
        int prevLineIndent = 0;
        int prevLineBrackets = 0;
        int i2 = 0;
        while (i2 < prevLine.length()) {
            char c = prevLine.charAt(i2);
            switch (c) {
                case ' ': {
                    if (!prevLineStart) break;
                    ++prevLineIndent;
                    break;
                }
                case '\t': {
                    if (!prevLineStart) break;
                    prevLineIndent += tabSize - prevLineIndent % tabSize;
                    break;
                }
                default: {
                    prevLineStart = false;
                    if (closeBrackets.indexOf(c) != -1) {
                        prevLineBrackets = Math.max(prevLineBrackets - 1, 0);
                        break;
                    }
                    if (openBrackets.indexOf(c) == -1) break;
                    ++prevLineBrackets;
                }
            }
            ++i2;
        }
        boolean lineStart = true;
        int lineIndent = 0;
        int lineWidth = 0;
        int lineBrackets = 0;
        int closeBracketIndex = -1;
        int i3 = 0;
        while (i3 < line.length()) {
            char c = line.charAt(i3);
            switch (c) {
                case ' ': {
                    if (!lineStart) break;
                    ++lineIndent;
                    ++lineWidth;
                    break;
                }
                case '\t': {
                    if (!lineStart) break;
                    lineIndent += tabSize - lineIndent % tabSize;
                    ++lineWidth;
                    break;
                }
                default: {
                    lineStart = false;
                    if (closeBrackets.indexOf(c) != -1) {
                        if (lineBrackets == 0) {
                            closeBracketIndex = i3;
                            break;
                        }
                        --lineBrackets;
                        break;
                    }
                    if (openBrackets.indexOf(c) == -1) break;
                    ++lineBrackets;
                }
            }
            ++i3;
        }
        try {
            if (closeBracketIndex != -1) {
                int offset = TextUtilities.findMatchingBracket(buffer, start + closeBracketIndex);
                if (offset == -1) {
                    return false;
                }
                String closeLine = textArea.getLineText(textArea.getLineOfOffset(offset));
                prevLineIndent = MiscUtilities.getLeadingWhiteSpaceWidth(closeLine, tabSize);
            } else {
                prevLineIndent += prevLineBrackets * tabSize;
            }
            if (!force && lineIndent >= prevLineIndent) {
                return false;
            }
            buffer.remove(start, lineWidth);
            buffer.insertString(start, MiscUtilities.createWhiteSpace(prevLineIndent, noTabs ? 0 : tabSize), null);
            return true;
        }
        catch (BadLocationException bl) {
            Log.log(9, this, bl);
            return false;
        }
    }

    public TokenMarker createTokenMarker() {
        String clazz = (String)this.getProperty("tokenMarker");
        if (clazz == null) {
            return null;
        }
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            Class<?> cls = loader == null ? Class.forName(clazz) : loader.loadClass(clazz);
            return (TokenMarker)cls.newInstance();
        }
        catch (Exception e) {
            Log.log(9, this, e);
            return null;
        }
    }

    public Object getProperty(String key) {
        String value = jEdit.getProperty("mode." + this.name + "." + key);
        if (value == null) {
            return null;
        }
        try {
            return new Integer(value);
        }
        catch (NumberFormatException nf) {
            return value;
        }
    }

    public boolean accept(Buffer buffer, String fileName, String firstLine) {
        if (this.filenameRE != null && this.filenameRE.isMatch(fileName)) {
            return true;
        }
        return this.firstlineRE != null && this.firstlineRE.isMatch(firstLine);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.getName() + "]";
    }

    void initKeyBindings() {
        String indentCloseBrackets = (String)this.getProperty("indentCloseBrackets");
        if (indentCloseBrackets != null) {
            EditAction action = jEdit.getAction("indent-lines");
            int i = 0;
            while (i < indentCloseBrackets.length()) {
                jEdit.getInputHandler().addKeyBinding(indentCloseBrackets.substring(i, i + 1), action);
                ++i;
            }
        }
    }
}

