/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.MacrosChanged;
import org.gjt.sp.jedit.textarea.InputHandler;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.util.Log;

public class Macros {
    private static Vector macros;
    private static String lastMacro;

    public static void loadMacros() {
        macros = new Vector();
        Macros.loadMacros(macros, "", new File(MiscUtilities.constructPath(jEdit.getJEditHome(), "macros")));
        String settings = jEdit.getSettingsDirectory();
        if (settings != null) {
            Macros.loadMacros(macros, "", new File(MiscUtilities.constructPath(settings, "macros")));
        }
        EditBus.send(new MacrosChanged(null));
    }

    public static Vector getMacros() {
        return macros;
    }

    public static void beginRecording(View view, String name, Buffer buffer) {
        lastMacro = name;
        view.getTextArea().getInputHandler().setMacroRecorder(new BufferRecorder(view, buffer));
    }

    public static void endRecording(View view) {
        InputHandler inputHandler = view.getTextArea().getInputHandler();
        BufferRecorder recorder = (BufferRecorder)inputHandler.getMacroRecorder();
        if (recorder != null) {
            if (lastMacro != null) {
                view.setBuffer(recorder.buffer);
            }
            inputHandler.setMacroRecorder(null);
        }
    }

    public static void playMacro(View view, String name) {
        lastMacro = name;
        if (name == null) {
            Buffer buffer = jEdit.getBuffer(MiscUtilities.constructPath(jEdit.getSettingsDirectory(), "macros", "__temporary__.macro"));
            if (buffer == null) {
                view.getToolkit().beep();
                return;
            }
            Macros.playMacroFromBuffer(view, "__temporary__.macro", buffer);
            return;
        }
        String fileName = MiscUtilities.constructPath(jEdit.getSettingsDirectory(), "macros", name);
        Buffer buffer = jEdit.getBuffer(fileName);
        if (buffer == null) {
            Macros.playMacroFromFile(view, name, fileName);
        } else {
            Macros.playMacroFromBuffer(view, name, buffer);
        }
    }

    public static boolean playMacroCommand(View view, String macro, int lineNo, String line) {
        String actionCommand;
        String action;
        if (line.length() == 0 || line.charAt(0) == '#') {
            return true;
        }
        int index = line.indexOf(64);
        if (index == -1) {
            action = line;
            actionCommand = null;
        } else {
            action = line.substring(0, index);
            actionCommand = line.substring(index + 1);
        }
        ActionListener _action = jEdit.getAction(action);
        if (_action == null) {
            _action = InputHandler.getAction(action);
        }
        if (_action == null) {
            Object[] args = new Object[]{macro, new Integer(lineNo), action};
            GUIUtilities.error(view, "macro-error", args);
            return false;
        }
        JEditTextArea textArea = view.getTextArea();
        textArea.getInputHandler().executeAction(_action, textArea, actionCommand);
        return true;
    }

    public static String getLastMacro() {
        return lastMacro;
    }

    private static void loadMacros(Vector vector, String path, File directory) {
        Object[] macroFiles = directory.list();
        if (macroFiles == null) {
            return;
        }
        MiscUtilities.quicksort(macroFiles, (MiscUtilities.Compare)new MiscUtilities.StringICaseCompare());
        int i = 0;
        while (i < macroFiles.length) {
            Object name = macroFiles[i];
            File file = new File(directory, (String)name);
            if (((String)name).toLowerCase().endsWith(".macro")) {
                String label = ((String)name).substring(0, ((String)name).length() - 6);
                vector.addElement(new Macro(label, String.valueOf(path) + label, file.getPath()));
            } else if (file.isDirectory()) {
                Vector<Object> submenu = new Vector<Object>();
                submenu.addElement(name);
                Macros.loadMacros(submenu, String.valueOf(path) + (String)name + '/', file);
                vector.addElement(submenu);
            }
            ++i;
        }
    }

    private static void playMacroFromBuffer(View view, String macro, Buffer buffer) {
        buffer.loadIfNecessary(view);
        try {
            Element map = buffer.getDefaultRootElement();
            int i = 0;
            while (i < map.getElementCount()) {
                Element lineElement = map.getElement(i);
                if (Macros.playMacroCommand(view, macro, i, buffer.getText(lineElement.getStartOffset(), lineElement.getEndOffset() - lineElement.getStartOffset() - 1))) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException bl) {
            Log.log(9, Macros.class, bl);
        }
    }

    private static void playMacroFromFile(View view, String macro, String path) {
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(path));
            int lineNo = 1;
            while ((line = in.readLine()) != null) {
                if (!Macros.playMacroCommand(view, macro, lineNo, line)) break;
                ++lineNo;
            }
            in.close();
        }
        catch (IOException io) {
            Log.log(9, Macros.class, io);
            Object[] args = new String[]{io.getMessage()};
            GUIUtilities.error(view, "ioerror", args);
        }
    }

    private static String getActionName(ActionListener listener) {
        if (listener instanceof EditAction) {
            return ((EditAction)listener).getName();
        }
        return InputHandler.getActionName(listener);
    }

    static class BufferRecorder
    implements InputHandler.MacroRecorder {
        View view;
        Buffer buffer;
        boolean lastWasInsert;

        BufferRecorder(View view, Buffer buffer) {
            this.view = view;
            this.buffer = buffer;
        }

        public void actionPerformed(ActionListener listener, String actionCommand) {
            if (this.buffer.isClosed()) {
                this.view.getTextArea().getInputHandler().setMacroRecorder(null);
                this.view.popStatus();
                return;
            }
            String name = Macros.getActionName(listener);
            if (name == null) {
                return;
            }
            if (name.equals("insert-char")) {
                if (this.lastWasInsert) {
                    this.append(actionCommand);
                    return;
                }
                this.lastWasInsert = true;
            } else {
                this.lastWasInsert = false;
            }
            if (actionCommand == null) {
                this.append("\n" + name);
            } else {
                this.append("\n" + name + "@" + actionCommand);
            }
        }

        private void append(String str) {
            try {
                this.buffer.insertString(this.buffer.getLength(), str, null);
            }
            catch (BadLocationException bl) {
                Log.log(9, this, bl);
            }
        }
    }

    public static class Macro {
        public String label;
        public String name;
        public String path;

        public Macro(String label, String name, final String path) {
            this.label = label;
            this.name = name;
            this.path = path;
            String binding = jEdit.getProperty(String.valueOf(name) + ".shortcut");
            if (binding != null) {
                final EditAction action = jEdit.getAction("play-macro");
                jEdit.getInputHandler().addKeyBinding(binding, new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        action.actionPerformed(new ActionEvent(evt.getSource(), evt.getID(), path));
                    }
                });
            }
        }

        public String toString() {
            return String.valueOf(this.label) + ":" + this.name + ":" + this.path;
        }
    }
}

