/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.JPopupMenu;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.textarea.InputHandler;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.util.Log;

public abstract class EditAction
implements ActionListener {
    private String name;

    public EditAction() {
    }

    public EditAction(String name) {
        this.name = name;
    }

    public final String getName() {
        if (this.name == null) {
            String clazz = this.getClass().getName();
            clazz = clazz.substring("org.gjt.sp.jedit.actions.".length());
            this.name = clazz = clazz.replace('_', '-');
        }
        return this.name;
    }

    public static View getView(EventObject evt) {
        Object o;
        if (evt != null && (o = evt.getSource()) instanceof Component) {
            return EditAction.getView((Component)o);
        }
        return null;
    }

    public static Buffer getBuffer(EventObject evt) {
        View view = EditAction.getView(evt);
        if (view != null) {
            return view.getBuffer();
        }
        return null;
    }

    public static View getView(Component comp) {
        while (true) {
            if (comp instanceof View) {
                return (View)comp;
            }
            if (comp instanceof JPopupMenu) {
                comp = ((JPopupMenu)comp).getInvoker();
                continue;
            }
            if (comp == null) break;
            comp = comp.getParent();
        }
        return null;
    }

    public boolean isToggle() {
        return false;
    }

    public boolean isSelected(Component comp) {
        return false;
    }

    public static class Wrapper
    extends EditAction
    implements InputHandler.Wrapper {
        private EditAction action;

        public Wrapper(String name) {
            super(name);
        }

        public Wrapper(EditAction action) {
            super(action.name);
            this.action = action;
        }

        public void actionPerformed(ActionEvent evt) {
            this.loadIfNecessary();
            Object o = evt.getSource();
            JEditTextArea textArea = null;
            if (o instanceof JEditTextArea) {
                textArea = (JEditTextArea)o;
            } else {
                View view = EditAction.getView(evt);
                textArea = view.getTextArea();
            }
            textArea.getInputHandler().executeAction(this.action, textArea, evt.getActionCommand());
        }

        public boolean isToggle() {
            if (this.action == null) {
                return false;
            }
            return this.action.isToggle();
        }

        public boolean isSelected(Component comp) {
            if (this.action == null) {
                return false;
            }
            return this.action.isSelected(comp);
        }

        public void loadIfNecessary() {
            if (this.action != null) {
                return;
            }
            String className = "org.gjt.sp.jedit.actions." + this.getName().replace('-', '_');
            try {
                ClassLoader loader = this.getClass().getClassLoader();
                Class<?> clazz = loader == null ? Class.forName(className) : loader.loadClass(className);
                this.action = (EditAction)clazz.newInstance();
            }
            catch (Exception e) {
                Log.log(9, this, "Cannot load action " + className);
                Log.log(9, this, e);
            }
        }
    }
}

