/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import appletrpc.RPC;
import appletrpc.RPCParameter;
import java.awt.Component;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TreeMap;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.Marker;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.syntax.SyntaxDocument;
import org.gjt.sp.jedit.syntax.TokenMarker;
import org.gjt.sp.util.Log;
import org2.mozilla.javascript.Context;
import org2.mozilla.javascript.Scriptable;

public class Buffer
extends SyntaxDocument
implements EBComponent {
    public static final int IOBUFSIZE = 32768;
    public static final String LINESEP = "lineSeparator";
    public static final String SELECTION_START = "Buffer__selStart";
    public static final String SELECTION_END = "Buffer__selEnd";
    public static final String SELECTION_RECT = "Buffer__rect";
    public static final String SCROLL_VERT = "Buffer__scrollVert";
    public static final String SCROLL_HORIZ = "Buffer__scrollHoriz";
    public static final String OVERWRITE = "Buffer__overwrite";
    Buffer prev;
    Buffer next;
    private static final int CLOSED = 0;
    private static final int LOADED = 1;
    private static final int NEW_FILE = 2;
    private static final int AUTOSAVE_DIRTY = 3;
    private static final int DIRTY = 4;
    private static final int READ_ONLY = 5;
    private static final int BACKED_UP = 6;
    private static final int SYNTAX = 7;
    private static final int UNDO_IN_PROGRESS = 8;
    private static final int TEMPORARY = 9;
    private int flags;
    private File file;
    private long modTime;
    private File autosaveFile;
    private File markersFile;
    private URL url;
    private URL markersUrl;
    private String name;
    private String path;
    private String filepath;
    private String filename;
    private Mode mode;
    private UndoManager undo;
    private CompoundEdit compoundEdit;
    private int compoundEditCount;
    private Vector markers;
    private int savedSelStart;
    private int savedSelEnd;

    public void propertiesChanged() {
        this.setFlag(7, "on".equals(this.getProperty("syntax")));
    }

    public void loadIfNecessary(View view) {
        if (!this.getFlag(1) && !this.getFlag(0)) {
            this.load(view);
        }
    }

    public void load(View view) {
        if (view != null) {
            view.showWaitCursor();
        }
        if (!this.getFlag(2) && this.autosaveFile.exists() && !this.getFlag(1)) {
            Object[] args = new Object[]{this.autosaveFile.getPath()};
            GUIUtilities.message(view, "autosaveexists", args);
        }
        this.setFlag(1, false);
        this.undo = null;
        if (!this.getFlag(2)) {
            this.read(view);
            this.readMarkers();
        }
        if (!this.getFlag(9)) {
            this.setMode();
            this.propertiesChanged();
            EditBus.addToBus(this);
        }
        this.undo = new UndoManager();
        if (view != null) {
            view.hideWaitCursor();
        }
        this.setFlag(1, true);
        EditBus.send(new BufferUpdate(this, BufferUpdate.LOADING));
    }

    public void autosave() {
        if (this.getFlag(3)) {
            try {
                File autosaveTmp = new File(this.autosaveFile.getPath().concat("+tmp+#"));
                this.save(new FileOutputStream(autosaveTmp));
                this.autosaveFile.delete();
                autosaveTmp.renameTo(this.autosaveFile);
                this.setFlag(3, false);
            }
            catch (FileNotFoundException fnf) {
                Log.log(5, this, fnf);
            }
            catch (Exception e) {
                Log.log(9, this, e);
            }
        }
    }

    public boolean saveAs(View view) {
        String file = GUIUtilities.showFileDialog(view, this.getPath(), 1);
        if (file != null) {
            return this.save(view, file);
        }
        return false;
    }

    public boolean save(View view, String path) {
        boolean returnValue;
        File saveFile;
        URL saveUrl;
        if (!this.getFlag(1)) {
            return true;
        }
        if (path == null && this.getFlag(2)) {
            return this.saveAs(view);
        }
        if (path == null) {
            Object[] args;
            int result;
            saveUrl = this.url;
            path = this.path;
            saveFile = this.file;
            long newModTime = saveFile.lastModified();
            if (newModTime > this.modTime && (result = JOptionPane.showConfirmDialog(view, jEdit.getProperty("filechanged.message", args = new Object[]{path}), jEdit.getProperty("filechanged.title"), 0, 2)) != 0) {
                return false;
            }
        } else {
            try {
                saveUrl = new URL(path);
            }
            catch (MalformedURLException mu) {
                saveUrl = null;
            }
            saveFile = new File(path);
        }
        if (view != null) {
            view.showWaitCursor();
        }
        EditBus.send(new BufferUpdate(this, BufferUpdate.SAVING));
        try {
            OutputStream out;
            if (saveUrl != null) {
                URLConnection connection = saveUrl.openConnection();
                out = new ByteArrayOutputStream();
            } else {
                out = new FileOutputStream(saveFile);
            }
            if (path.endsWith(".gz")) {
                out = new GZIPOutputStream(out);
            }
            String t = this.save(out);
            String editingSource = out instanceof ByteArrayOutputStream ? ((ByteArrayOutputStream)out).toString("UTF-8") : t;
            if (jEdit.currentModeName.equals("javascript")) {
                this.syntaxCheck(editingSource, view);
            }
            RPCParameter p = new RPCParameter();
            p.put("path", "@");
            p.put("filename", this.filename);
            p.put("define", editingSource);
            String HomeURL = this.filepath;
            p = RPC.Call(String.valueOf(HomeURL) + "servlet/wiseoa.flow.appletrpc.LoadFlowFormConfig", "RemoteEditFile", p);
            if (!p.Success) {
                throw new IOException(p.ErrorText);
            }
            this.url = saveUrl;
            if (!this.path.equals(path)) {
                System.err.println("Repositioning buffer");
                jEdit.updatePosition(this);
                this.path = path;
            }
            this.file = saveFile;
            if (this.getFlag(2) || this.mode.getName().equals("text")) {
                this.setMode();
            }
            this.setFlag(3, false);
            this.setFlag(5, false);
            this.setFlag(2, false);
            this.setFlag(4, false);
            if (this.name.toLowerCase().endsWith(".macro")) {
                Macros.loadMacros();
            }
            EditBus.send(new BufferUpdate(this, BufferUpdate.DIRTY_CHANGED));
            this.autosaveFile.delete();
            this.modTime = this.file.lastModified();
            returnValue = true;
        }
        catch (IOException io) {
            Log.log(9, this, io);
            Object[] args = new Object[]{io.toString()};
            GUIUtilities.error(view, "ioerror", args);
            returnValue = false;
        }
        catch (BadLocationException bl) {
            Log.log(9, this, bl);
            returnValue = false;
        }
        if (view != null) {
            view.hideWaitCursor();
        }
        return returnValue;
    }

    /*
     * Unable to fully structure code
     */
    public void syntaxCheck(String script, View view) {
        block26: {
            block23: {
                block25: {
                    block24: {
                        if (!this.filename.endsWith(".js")) {
                            return;
                        }
                        if (!jEdit.currentModeName.equals("javascript")) {
                            return;
                        }
                        if (script.trim().equals("")) {
                            return;
                        }
                        cx = null;
                        scope = null;
                        try {
                            try {
                                cx = Context.enter();
                                scope = cx.initStandardObjects();
                                this.SafeAddScript(cx, (Scriptable)scope, script);
                                break block23;
                            }
                            catch (Exception er) {
                                Buffer.ShowInfo(null, er.getMessage());
                                if (view == null || scope == null) break block24;
                                cbm = (DefaultComboBoxModel)view.getFuncList().getModel();
                                view.getFuncList().removeActionListener(view.getFuncList().getActionListeners()[0]);
                                cbm.removeAllElements();
                                func = "";
                                map = new TreeMap<String, String>();
                                objs = scope.getIds();
                                oi = 0;
                                ** while (oi < objs.length)
                            }
                        }
                        catch (Throwable var6_30) {
                            if (view == null || scope == null) break block25;
                            cbm = (DefaultComboBoxModel)view.getFuncList().getModel();
                            view.getFuncList().removeActionListener(view.getFuncList().getActionListeners()[0]);
                            cbm.removeAllElements();
                            func = "";
                            map = new TreeMap<String, String>();
                            objs = scope.getIds();
                            oi = 0;
                            ** while (oi < objs.length)
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                obj = objs[oi];
                                if (obj instanceof String) {
                                    func = obj.toString();
                                    map.put(func, "1");
                                }
                            }
                            catch (Exception obj) {
                                // empty catch block
                            }
                            ++oi;
                            continue;
                        }
lbl37:
                        // 1 sources

                        it = map.keySet().iterator();
                        while (it.hasNext()) {
                            f = String.valueOf((String)it.next()) + "     ";
                            cbm.addElement(f);
                        }
                    }
                    view.funcListAddActionListener();
                    Context.exit();
                    break block26;
lbl-1000:
                    // 1 sources

                    {
                        try {
                            obj = objs[oi];
                            if (obj instanceof String) {
                                func = obj.toString();
                                map.put(func, "1");
                            }
                        }
                        catch (Exception obj) {
                            // empty catch block
                        }
                        ++oi;
                        continue;
                    }
lbl67:
                    // 1 sources

                    it = map.keySet().iterator();
                    while (it.hasNext()) {
                        f = String.valueOf((String)it.next()) + "     ";
                        cbm.addElement(f);
                    }
                }
                view.funcListAddActionListener();
                Context.exit();
                throw var6_30;
            }
            if (view != null && scope != null) {
                cbm = (DefaultComboBoxModel)view.getFuncList().getModel();
                view.getFuncList().removeActionListener(view.getFuncList().getActionListeners()[0]);
                cbm.removeAllElements();
                func = "";
                map = new TreeMap<String, String>();
                objs = scope.getIds();
                oi = 0;
                while (oi < objs.length) {
                    try {
                        obj = objs[oi];
                        if (obj instanceof String) {
                            func = obj.toString();
                            map.put(func, "1");
                        }
                    }
                    catch (Exception obj) {
                        // empty catch block
                    }
                    ++oi;
                }
                it = map.keySet().iterator();
                while (it.hasNext()) {
                    f = String.valueOf((String)it.next()) + "     ";
                    cbm.addElement(f);
                }
            }
            view.funcListAddActionListener();
            Context.exit();
        }
    }

    public void SafeAddScript(Context cx, Scriptable scope, String script) {
        if (script.trim().equals("")) {
            return;
        }
        try {
            cx.evaluateString(scope, script, "", 1, null);
        }
        catch (Exception e) {
            Buffer.ShowInfo(null, "\u811a\u672c\u6709\u9519\uff0c" + e.getMessage());
        }
    }

    public static void ShowInfo(Component parentComponent, String info) {
        JOptionPane.showMessageDialog(parentComponent, info, "\u63d0\u793a", 2);
    }

    public final URL getURL() {
        return this.url;
    }

    public final File getFile() {
        return this.file;
    }

    public final File getAutosaveFile() {
        return this.autosaveFile;
    }

    public final String getName() {
        return this.name;
    }

    public final String getPath() {
        return this.path;
    }

    public final boolean isClosed() {
        return this.getFlag(0);
    }

    public final boolean isLoaded() {
        return this.getFlag(1);
    }

    public final boolean isNewFile() {
        return this.getFlag(2);
    }

    public final boolean isDirty() {
        return this.getFlag(4);
    }

    public final boolean isReadOnly() {
        return this.getFlag(5);
    }

    public void setDirty(boolean d) {
        boolean old_d = this.getFlag(4);
        if (d) {
            if (!this.getFlag(1) || this.getFlag(5)) {
                return;
            }
            if (this.getFlag(4) && this.getFlag(3)) {
                return;
            }
            this.setFlag(4, true);
            this.setFlag(3, true);
        } else {
            this.setFlag(4, false);
        }
        if (d != old_d) {
            EditBus.send(new BufferUpdate(this, BufferUpdate.DIRTY_CHANGED));
        }
    }

    public boolean isTemporary() {
        return this.getFlag(9);
    }

    public boolean undo() {
        if (this.undo == null) {
            return false;
        }
        try {
            this.setFlag(8, true);
            this.undo.undo();
            return true;
        }
        catch (CannotUndoException cu) {
            Log.log(1, this, cu);
            return false;
        }
        finally {
            this.setFlag(8, false);
        }
    }

    public boolean redo() {
        if (this.undo == null) {
            return false;
        }
        try {
            this.setFlag(8, true);
            this.undo.redo();
            return true;
        }
        catch (CannotRedoException cr) {
            Log.log(1, this, cr);
            return false;
        }
        finally {
            this.setFlag(8, false);
        }
    }

    public void addUndoableEdit(UndoableEdit edit) {
        if (this.undo == null || this.getFlag(8) || !this.getFlag(1)) {
            return;
        }
        if (this.undo.canRedo() && !edit.isSignificant()) {
            return;
        }
        if (this.compoundEdit != null) {
            this.compoundEdit.addEdit(edit);
        } else {
            this.undo.addEdit(edit);
        }
    }

    public void beginCompoundEdit() {
        ++this.compoundEditCount;
        if (this.compoundEdit == null) {
            this.compoundEdit = new CompoundEdit();
        }
    }

    public void endCompoundEdit() {
        if (this.compoundEditCount == 0) {
            return;
        }
        --this.compoundEditCount;
        if (this.compoundEdit != null) {
            this.compoundEdit.end();
            if (this.compoundEdit.canUndo()) {
                this.undo.addEdit(this.compoundEdit);
            }
            this.compoundEdit = null;
        }
    }

    public int getTabSize() {
        return (Integer)this.getProperty("tabSize");
    }

    public final Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        View view;
        int i;
        if (mode == null) {
            throw new NullPointerException("Mode must be non-null");
        }
        if (this.mode == mode) {
            this.tokenizeLines();
            return;
        }
        View[] views = jEdit.getViews();
        Mode oldMode = this.mode;
        if (oldMode != null) {
            i = 0;
            while (i < views.length) {
                view = views[i];
                if (view.getBuffer() == this) {
                    oldMode.leaveView(view);
                }
                ++i;
            }
            oldMode.leave(this);
        }
        this.mode = mode;
        mode.enter(this);
        this.setTokenMarker(mode.createTokenMarker());
        i = 0;
        while (i < views.length) {
            view = views[i];
            if (view.getBuffer() == this) {
                mode.enterView(view);
            }
            ++i;
        }
        if (oldMode != null) {
            EditBus.send(new BufferUpdate(this, BufferUpdate.MODE_CHANGED));
        }
    }

    public void setMode() {
        Mode m;
        String userMode = (String)this.getProperty("mode");
        if (userMode != null && (m = jEdit.getMode(userMode)) != null) {
            this.setMode(m);
            return;
        }
        String nogzName = this.name.substring(0, this.name.length() - (this.name.endsWith(".gz") ? 3 : 0));
        Element lineElement = this.getDefaultRootElement().getElement(0);
        try {
            String line = this.getText(0, lineElement == null ? 0 : lineElement.getEndOffset() - 1);
            Mode[] modes = jEdit.getModes();
            int i = modes.length - 1;
            while (i >= 0) {
                if (modes[i].accept(this, nogzName, line)) {
                    this.setMode(modes[i]);
                    return;
                }
                --i;
            }
        }
        catch (BadLocationException bl) {
            Log.log(9, this, bl);
        }
        if (this.mode == null) {
            Mode defaultMode = jEdit.getMode(jEdit.getProperty("buffer.defaultMode"));
            if (defaultMode == null) {
                defaultMode = jEdit.getMode("text");
            }
            this.setMode(defaultMode);
        }
    }

    public final TokenMarker getTokenMarker() {
        if (this.getFlag(7)) {
            return super.getTokenMarker();
        }
        return null;
    }

    public final Enumeration getMarkers() {
        return this.markers.elements();
    }

    public void addMarker(String name, int start, int end2) {
        Marker markerN;
        this.setDirty(true);
        name = name.replace(';', ' ');
        try {
            markerN = new Marker(name, this.createPosition(start), this.createPosition(end2));
        }
        catch (BadLocationException bl) {
            Log.log(9, this, bl);
            return;
        }
        boolean added = false;
        if (this.getFlag(1)) {
            int i = 0;
            while (i < this.markers.size()) {
                Marker marker = (Marker)this.markers.elementAt(i);
                if (marker.getName().equals(name)) {
                    this.markers.removeElementAt(i);
                }
                if (marker.getStart() > start) {
                    this.markers.insertElementAt(markerN, i);
                    added = true;
                    break;
                }
                ++i;
            }
        }
        if (!added) {
            this.markers.addElement(markerN);
        }
        EditBus.send(new BufferUpdate(this, BufferUpdate.MARKERS_CHANGED));
    }

    public void removeMarker(String name) {
        this.setDirty(true);
        int i = 0;
        while (i < this.markers.size()) {
            Marker marker = (Marker)this.markers.elementAt(i);
            if (marker.getName().equals(name)) {
                this.markers.removeElementAt(i);
            }
            ++i;
        }
        EditBus.send(new BufferUpdate(this, BufferUpdate.MARKERS_CHANGED));
    }

    public Marker getMarker(String name) {
        Enumeration enume = this.getMarkers();
        while (enume.hasMoreElements()) {
            Marker marker = (Marker)enume.nextElement();
            if (!marker.getName().equals(name)) continue;
            return marker;
        }
        return null;
    }

    public final Buffer getNext() {
        return this.next;
    }

    public final Buffer getPrev() {
        return this.prev;
    }

    public final int getIndex() {
        int count = 0;
        Buffer buffer = this.prev;
        while (buffer != null) {
            ++count;
            buffer = buffer.prev;
        }
        return count;
    }

    public String toString() {
        return this.path;
    }

    public void handleMessage(EBMessage msg) {
        if (msg instanceof PropertiesChanged) {
            this.propertiesChanged();
        }
    }

    Buffer(URL url, String filepath, String filename, boolean readOnly, boolean newFile, boolean temp) {
        this.url = url;
        this.filepath = filepath;
        this.filename = filename;
        this.path = String.valueOf(filepath) + filename;
        this.setFlag(9, temp);
        this.setFlag(5, readOnly);
        this.markers = new Vector();
        this.addDocumentListener(new DocumentHandler());
        this.addUndoableEditListener(new UndoHandler());
        this.setDocumentProperties(new BufferProps());
        this.putProperty("i18n", Boolean.FALSE);
        this.setPath();
        if (url == null) {
            newFile |= !this.file.exists();
        }
        this.setFlag(2, newFile);
        if (newFile) {
            this.loadIfNecessary(null);
        }
    }

    void commitTemporary() {
        this.setFlag(9, false);
        if (this.getFlag(1)) {
            EditBus.addToBus(this);
        }
    }

    void close() {
        this.setFlag(0, true);
        this.autosaveFile.delete();
        if (this.getFlag(1)) {
            EditBus.removeFromBus(this);
        }
    }

    private void setFlag(int flag, boolean value) {
        this.flags = value ? (this.flags |= 1 << flag) : (this.flags &= ~(1 << flag));
    }

    private boolean getFlag(int flag) {
        int mask = 1 << flag;
        return (this.flags & mask) == mask;
    }

    private void setPath() {
        if (this.url == null) {
            this.file = new File(this.path);
            this.name = this.file.getName();
            this.markersFile = new File(this.file.getParent(), String.valueOf('.') + this.name + ".marks");
        } else {
            this.name = this.url.getFile();
            if (this.name.length() == 0) {
                this.name = this.url.getHost();
            }
            this.file = new File(this.name);
            this.name = this.file.getName();
            try {
                this.markersUrl = new URL(this.url, String.valueOf('.') + new File(this.name).getName() + ".marks");
            }
            catch (MalformedURLException mu) {
                this.markersUrl = null;
            }
        }
        if (this.autosaveFile != null) {
            this.autosaveFile.delete();
        }
        this.autosaveFile = new File(this.file.getParent(), String.valueOf('#') + this.name + '#');
    }

    private void read(View view) {
        if (this.file.exists()) {
            this.setFlag(5, !this.file.canWrite());
        }
        Object connection = null;
        StringBuffer sbuf = new StringBuffer(Math.max((int)this.file.length(), 131072));
        try {
            int len;
            InputStream _in = this.url != null ? this.url.openStream() : new FileInputStream(this.file);
            if (this.name.endsWith(".gz")) {
                _in = new GZIPInputStream(_in);
            }
            InputStreamReader in = new InputStreamReader(_in, "UTF-8");
            char[] buf = new char[32768];
            boolean CRLF = false;
            boolean CROnly = false;
            boolean lastWasCR = false;
            while ((len = in.read(buf, 0, buf.length)) != -1) {
                int lastLine = 0;
                int i = 0;
                while (i < len) {
                    switch (buf[i]) {
                        case '\r': {
                            if (lastWasCR) {
                                CROnly = true;
                                CRLF = false;
                            } else {
                                lastWasCR = true;
                            }
                            sbuf.append(buf, lastLine, i - lastLine);
                            sbuf.append('\n');
                            lastLine = i + 1;
                            break;
                        }
                        case '\n': {
                            if (lastWasCR) {
                                CROnly = false;
                                CRLF = true;
                                lastWasCR = false;
                                lastLine = i + 1;
                                break;
                            }
                            CROnly = false;
                            CRLF = false;
                            sbuf.append(buf, lastLine, i - lastLine);
                            sbuf.append('\n');
                            lastLine = i + 1;
                            break;
                        }
                        default: {
                            if (!lastWasCR) break;
                            CROnly = true;
                            CRLF = false;
                            lastWasCR = false;
                        }
                    }
                    ++i;
                }
                sbuf.append(buf, lastLine, len - lastLine);
            }
            if (CRLF) {
                this.putProperty(LINESEP, "\r\n");
            } else if (CROnly) {
                this.putProperty(LINESEP, "\r");
            } else {
                this.putProperty(LINESEP, "\n");
            }
            in.close();
            this.remove(0, this.getLength());
            int length = sbuf.length();
            if (length != 0) {
                char ch = sbuf.charAt(length - 1);
                if (length >= 2 && ch == '\u001a' && sbuf.charAt(length - 2) == '\n') {
                    sbuf.setLength(length - 2);
                } else if (ch == '\n') {
                    sbuf.setLength(length - 1);
                }
            }
            this.insertString(0, sbuf.toString(), null);
            Element map = this.getDefaultRootElement();
            int i = 0;
            while (i < Math.min(10, map.getElementCount())) {
                Element line = map.getElement(i);
                String text = this.getText(line.getStartOffset(), line.getEndOffset() - line.getStartOffset() - 1);
                this.processProperty(text);
                ++i;
            }
            this.setFlag(2, false);
            this.setFlag(5, false);
            this.setDirty(false);
            this.modTime = this.file.lastModified();
        }
        catch (BadLocationException bl) {
            Log.log(9, this, bl);
        }
        catch (FileNotFoundException fnf) {
            this.setFlag(2, true);
            Log.log(5, this, fnf);
        }
        catch (IOException io) {
            Log.log(9, this, io);
            Object[] args = new Object[]{io.toString()};
            GUIUtilities.error(view, "ioerror", args);
        }
    }

    private void processProperty(String prop) {
        StringBuffer buf = new StringBuffer();
        String name = null;
        boolean escape = false;
        int i = 0;
        while (i < prop.length()) {
            char c = prop.charAt(i);
            switch (c) {
                case ':': {
                    if (escape) {
                        escape = false;
                        buf.append(':');
                        break;
                    }
                    if (name != null) {
                        String value = buf.toString();
                        try {
                            this.putProperty(name, new Integer(value));
                        }
                        catch (NumberFormatException nf) {
                            this.putProperty(name, value);
                        }
                    }
                    buf.setLength(0);
                    break;
                }
                case '=': {
                    if (escape) {
                        escape = false;
                        buf.append('=');
                        break;
                    }
                    name = buf.toString();
                    buf.setLength(0);
                    break;
                }
                case '\\': {
                    if (escape) {
                        buf.append('\\');
                    }
                    escape = !escape;
                    break;
                }
                case 'n': {
                    if (escape) {
                        buf.append('\n');
                        escape = false;
                        break;
                    }
                }
                case 't': {
                    if (escape) {
                        buf.append('\t');
                        escape = false;
                        break;
                    }
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
    }

    private void readMarkers() {
        this.markers.removeAllElements();
        try {
            InputStream in = this.url != null ? this.markersUrl.openStream() : new FileInputStream(this.markersFile);
            StringBuffer buf = new StringBuffer();
            boolean eof = false;
            String name = null;
            int start = -1;
            int end2 = -1;
            block10: while (!eof) {
                int c = in.read();
                switch (c) {
                    case -1: {
                        eof = true;
                    }
                    case 10: 
                    case 13: 
                    case 59: {
                        if (buf.length() == 0) continue block10;
                        String str = buf.toString();
                        buf.setLength(0);
                        if (name == null) {
                            name = str;
                            continue block10;
                        }
                        if (start == -1) {
                            try {
                                start = Integer.parseInt(str);
                            }
                            catch (NumberFormatException nf) {
                                start = 0;
                            }
                            continue block10;
                        }
                        if (end2 != -1) continue block10;
                        try {
                            end2 = Integer.parseInt(str);
                        }
                        catch (NumberFormatException nf) {
                            end2 = 0;
                        }
                        this.addMarker(name, start, end2);
                        name = null;
                        start = -1;
                        end2 = -1;
                        continue block10;
                    }
                }
                buf.append((char)c);
            }
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String save(OutputStream _out) throws IOException, BadLocationException {
        StringBuffer ret = new StringBuffer();
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(_out, "UTF-8"), 32768);
        Segment lineSegment = new Segment();
        String newline = (String)this.getProperty(LINESEP);
        if (newline == null) {
            newline = System.getProperty("line.separator");
        }
        Element map = this.getDefaultRootElement();
        int i = 0;
        while (i < map.getElementCount()) {
            Element line = map.getElement(i);
            int start = line.getStartOffset();
            this.getText(start, line.getEndOffset() - start - 1, lineSegment);
            out.write(lineSegment.array, lineSegment.offset, lineSegment.count);
            out.write(newline);
            ret.append(lineSegment.array, lineSegment.offset, lineSegment.count);
            ret.append(newline);
            ++i;
        }
        out.close();
        return ret.toString();
    }

    private void backup(File file) {
        int backups;
        if (this.getFlag(6)) {
            return;
        }
        this.setFlag(6, true);
        try {
            backups = Integer.parseInt(jEdit.getProperty("backups"));
        }
        catch (NumberFormatException nf) {
            Log.log(9, this, nf);
            backups = 1;
        }
        if (backups == 0) {
            return;
        }
        String backupPrefix = jEdit.getProperty("backup.prefix", "");
        String backupSuffix = jEdit.getProperty("backup.suffix", "~");
        String backupDirectory = jEdit.getProperty("backup.directory");
        if (backupDirectory == null || backupDirectory.length() == 0) {
            backupDirectory = file.getParent();
        } else {
            backupDirectory = MiscUtilities.constructPath(System.getProperty("user.home"), backupDirectory);
            new File(backupDirectory).mkdirs();
        }
        String name = file.getName();
        if (backups == 1) {
            file.renameTo(new File(backupDirectory, String.valueOf(backupPrefix) + name + backupSuffix));
        } else {
            new File(backupDirectory, String.valueOf(backupPrefix) + name + backupSuffix + backups + backupSuffix).delete();
            int i = backups - 1;
            while (i > 0) {
                File backup = new File(backupDirectory, String.valueOf(backupPrefix) + name + backupSuffix + i + backupSuffix);
                backup.renameTo(new File(backupDirectory, String.valueOf(backupPrefix) + name + backupSuffix + (i + 1) + backupSuffix));
                --i;
            }
            file.renameTo(new File(backupDirectory, String.valueOf(backupPrefix) + name + backupSuffix + "1" + backupSuffix));
        }
    }

    class BufferProps
    extends Hashtable {
        BufferProps() {
        }

        public Object get(Object key) {
            Object o = super.get(key);
            if (o != null) {
                return o;
            }
            if (!(key instanceof String)) {
                return null;
            }
            if (Buffer.this.mode != null && (o = Buffer.this.mode.getProperty((String)key)) != null) {
                return o;
            }
            String value = jEdit.getProperty("buffer." + key);
            if (value == null) {
                return null;
            }
            try {
                return new Integer(value);
            }
            catch (NumberFormatException nf) {
                return value;
            }
        }
    }

    class DocumentHandler
    implements DocumentListener {
        DocumentHandler() {
        }

        public void insertUpdate(DocumentEvent evt) {
            Buffer.this.setDirty(true);
        }

        public void removeUpdate(DocumentEvent evt) {
            Buffer.this.setDirty(true);
        }

        public void changedUpdate(DocumentEvent evt) {
        }
    }

    class UndoHandler
    implements UndoableEditListener {
        UndoHandler() {
        }

        public void undoableEditHappened(UndoableEditEvent evt) {
            Buffer.this.addUndoableEdit(evt.getEdit());
        }
    }
}

