/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.woden.ErrorLocator;
import org.apache.woden.ErrorReporter;
import org.apache.woden.WSDLException;
import org.apache.woden.WSDLSource;
import org.apache.woden.XMLElement;
import org.apache.woden.internal.BaseWSDLReader;
import org.apache.woden.internal.DOMWSDLSource;
import org.apache.woden.internal.DOMXMLElement;
import org.apache.woden.internal.ErrorLocatorImpl;
import org.apache.woden.internal.WSDLContext;
import org.apache.woden.internal.resolver.DOMSchemaResolverAdapter;
import org.apache.woden.internal.resolver.EntityResolverAdapter;
import org.apache.woden.internal.schema.ImportedSchemaImpl;
import org.apache.woden.internal.schema.InlinedSchemaImpl;
import org.apache.woden.internal.util.StringUtils;
import org.apache.woden.internal.wsdl20.Constants;
import org.apache.woden.internal.wsdl20.validation.WSDLComponentValidator;
import org.apache.woden.internal.wsdl20.validation.WSDLDocumentValidator;
import org.apache.woden.internal.wsdl20.validation.WSDLValidator;
import org.apache.woden.internal.xpointer.DOMXMLElementEvaluator;
import org.apache.woden.schema.Schema;
import org.apache.woden.wsdl20.Description;
import org.apache.woden.wsdl20.extensions.ExtensionRegistry;
import org.apache.woden.wsdl20.xml.DescriptionElement;
import org.apache.woden.wsdl20.xml.ImportElement;
import org.apache.woden.wsdl20.xml.IncludeElement;
import org.apache.woden.wsdl20.xml.TypesElement;
import org.apache.woden.wsdl20.xml.WSDLElement;
import org.apache.woden.xml.XMLAttr;
import org.apache.woden.xpointer.InvalidXPointerException;
import org.apache.woden.xpointer.XPointer;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaException;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DOMWSDLReader
extends BaseWSDLReader {
    private static final String emptyString = "".intern();
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    static final String WSDL120_SCHEMA_SOURCE = "http://www.w3.org/2007/03/wsdl/wsdl20.xsd";
    static final String WSDL120_EXTENSIONS_SCHEMA_SOURCE = "http://www.w3.org/2007/03/wsdl/wsdl20-extensions.xsd";
    static final String W3C_XML_SCHEMA_SCHEMA_SOURCE = "http://www.w3.org/2001/XMLSchema.xsd";
    static final String[] schemas = new String[]{"http://www.w3.org/2007/03/wsdl/wsdl20.xsd", "http://www.w3.org/2007/03/wsdl/wsdl20-extensions.xsd", "http://www.w3.org/2001/XMLSchema.xsd"};
    private static final Log logger = LogFactory.getLog((Class)DOMWSDLReader.class);
    private Map fImportedSchemas = new Hashtable();
    private WSDLDocumentValidator docValidator = null;
    private WSDLComponentValidator compValidator = null;

    DOMWSDLReader(WSDLContext wsdlContext) throws WSDLException {
        super(wsdlContext);
    }

    public WSDLSource createWSDLSource() {
        return new DOMWSDLSource(this.getErrorReporter());
    }

    public Description readWSDL(String wsdlURI) throws WSDLException {
        URL url;
        try {
            url = StringUtils.getURL(null, (String)wsdlURI);
        }
        catch (MalformedURLException e) {
            String msg = this.getErrorReporter().getFormattedMessage("WSDL516", new Object[]{wsdlURI});
            throw new WSDLException("PARSER_ERROR", msg, (Throwable)e);
        }
        String wsdlURL = url.toString();
        InputSource inputSource = new InputSource(this.resolveURI(wsdlURL));
        return this.readWSDL(wsdlURL, inputSource);
    }

    public Description readWSDL(WSDLSource wsdlSource) throws WSDLException {
        Object source = wsdlSource.getSource();
        URI baseURI = wsdlSource.getBaseURI();
        String wsdlURL = null;
        if (baseURI != null) {
            URL url;
            try {
                url = StringUtils.getURL(null, (String)baseURI.toString());
            }
            catch (MalformedURLException e) {
                String msg = this.getErrorReporter().getFormattedMessage("WSDL516", new Object[]{baseURI.toString()});
                throw new WSDLException("PARSER_ERROR", msg, (Throwable)e);
            }
            wsdlURL = url.toString();
        }
        if (source instanceof Element) {
            return this.readWSDL(wsdlURL, (Element)source);
        }
        if (source instanceof Document) {
            return this.readWSDL(wsdlURL, (Document)source);
        }
        if (source instanceof InputSource) {
            return this.readWSDL(wsdlURL, (InputSource)source);
        }
        String sourceClass = source.getClass().getName();
        String readerClass = ((Object)((Object)this)).getClass().getName();
        String msg = this.getErrorReporter().getFormattedMessage("WSDL017", new Object[]{sourceClass, readerClass});
        throw new WSDLException("PARSER_ERROR", msg);
    }

    private Description readWSDL(String wsdlURL, Element docEl) throws WSDLException {
        XMLElement descEl = this.createXMLElement(docEl);
        DescriptionElement descElem = this.parseDescription(wsdlURL, descEl, null);
        Description descComp = descElem.toComponent();
        if (this.features.getValue("http://ws.apache.org/woden/features/validation")) {
            new WSDLValidator().validate(descComp, this.fWsdlContext);
        }
        return descComp;
    }

    private Description readWSDL(String wsdlURI, Document domDoc) throws WSDLException {
        XPointer xpointer;
        URI uri = null;
        try {
            uri = new URI(wsdlURI);
        }
        catch (URISyntaxException e) {
            String msg = this.getErrorReporter().getFormattedMessage("WSDL506", new Object[]{null, wsdlURI});
            throw new WSDLException("PARSER_ERROR", msg, (Throwable)e);
        }
        String fragment = uri.getFragment();
        if (fragment == null) {
            return this.readWSDL(wsdlURI, domDoc.getDocumentElement());
        }
        try {
            xpointer = new XPointer(fragment);
        }
        catch (InvalidXPointerException e) {
            String msg = this.getErrorReporter().getFormattedMessage("WSDL530", new Object[]{fragment, wsdlURI});
            throw new WSDLException("PARSER_ERROR", msg, (Throwable)e);
        }
        Element root = domDoc.getDocumentElement();
        DOMXMLElementEvaluator evaluator = new DOMXMLElementEvaluator(xpointer, root, this.getErrorReporter());
        Element result = evaluator.evaluateElement();
        if (result != null) {
            return this.readWSDL(wsdlURI, result);
        }
        String msg = this.getErrorReporter().getFormattedMessage("WSDL531", new Object[]{fragment, wsdlURI});
        throw new WSDLException("PARSER_ERROR", msg);
    }

    private Description readWSDL(String wsdlURI, InputSource inputSource) throws WSDLException {
        try {
            Document wsdlDocument = this.getDocument(inputSource, wsdlURI);
            return this.readWSDL(wsdlURI, wsdlDocument);
        }
        catch (IOException e) {
            String msg = this.getErrorReporter().getFormattedMessage("WSDL503", new Object[]{wsdlURI});
            throw new WSDLException("PARSER_ERROR", msg, (Throwable)e);
        }
    }

    protected Schema parseSchemaInline(XMLElement schemaEl, DescriptionElement desc) throws WSDLException {
        InlinedSchemaImpl schema = new InlinedSchemaImpl();
        schema.setXMLElement(schemaEl);
        schema.setId(schemaEl.getAttributeValue("id"));
        String tns = schemaEl.getAttributeValue("targetNamespace");
        if (tns != null) {
            schema.setNamespace(this.getURI(tns));
        }
        String baseURI = desc.getDocumentBaseURI() != null ? desc.getDocumentBaseURI().toString() : null;
        XmlSchema schemaDef = null;
        try {
            Element domSchemaEl = (Element)schemaEl.getSource();
            XmlSchemaCollection xsc = new XmlSchemaCollection();
            xsc.setBaseUri(baseURI);
            xsc.setSchemaResolver((URIResolver)new DOMSchemaResolverAdapter(this.getURIResolver(), schemaEl));
            schemaDef = xsc.read(domSchemaEl, baseURI);
        }
        catch (XmlSchemaException e) {
            this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL521", new Object[]{baseURI}, (short)1, (Exception)((Object)e));
        }
        catch (RuntimeException e) {
            this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL521", new Object[]{baseURI}, (short)2, (Exception)e);
        }
        if (schemaDef != null) {
            schema.setSchemaDefinition(schemaDef);
        } else {
            schema.setReferenceable(false);
        }
        return schema;
    }

    protected Schema parseSchemaImport(XMLElement importEl, DescriptionElement desc) throws WSDLException {
        XmlSchema x;
        Schema s;
        int j;
        Schema[] schemas;
        TypesElement typesElem;
        DescriptionElement nestedDesc;
        int i;
        String schemaLoc;
        ImportedSchemaImpl schema = new ImportedSchemaImpl();
        schema.setXMLElement(importEl);
        String importNS = importEl.getAttributeValue("namespace");
        if (importNS != null) {
            schema.setNamespace(this.getURI(importNS));
        }
        if ((schemaLoc = importEl.getAttributeValue("schemaLocation")) != null) {
            schema.setSchemaLocation(this.getURI(schemaLoc));
        }
        if (schema.getNamespace() == null) {
            schema.setReferenceable(false);
            return schema;
        }
        XmlSchema schemaDef = null;
        if (schema.getSchemaLocation() != null) {
            schemaDef = this.retrieveSchema(importEl, desc.getDocumentBaseURI(), schemaLoc);
        }
        if (schemaDef == null) {
            schemaDef = this.retrieveSchema(importEl, null, importNS);
        }
        if (schemaDef == null) {
            ImportElement[] imports = desc.getImportElements();
            block0: for (i = 0; i < imports.length; ++i) {
                ImportElement importElem = imports[i];
                nestedDesc = importElem.getDescriptionElement();
                if (nestedDesc == null || (typesElem = nestedDesc.getTypesElement()) == null) continue;
                schemas = typesElem.getSchemas(schema.getNamespace());
                for (j = 0; j < schemas.length; ++j) {
                    s = schemas[i];
                    x = s.getSchemaDefinition();
                    if (x == null) continue;
                    schemaDef = x;
                    continue block0;
                }
            }
        }
        if (schemaDef == null) {
            IncludeElement[] includes = desc.getIncludeElements();
            block2: for (i = 0; i < includes.length; ++i) {
                IncludeElement includeElem = includes[i];
                nestedDesc = includeElem.getDescriptionElement();
                if (nestedDesc == null || (typesElem = nestedDesc.getTypesElement()) == null) continue;
                schemas = typesElem.getSchemas(schema.getNamespace());
                for (j = 0; j < schemas.length; ++j) {
                    s = schemas[i];
                    x = s.getSchemaDefinition();
                    if (x == null) continue;
                    schemaDef = x;
                    continue block2;
                }
            }
        }
        if (schemaDef != null) {
            schema.setSchemaDefinition(schemaDef);
        } else {
            schema.setReferenceable(false);
        }
        return schema;
    }

    protected void parseExtensionAttributes(XMLElement extEl, Class wsdlClass, WSDLElement wsdlObj, DescriptionElement desc) throws WSDLException {
        Element domEl = (Element)extEl.getSource();
        NamedNodeMap nodeMap = domEl.getAttributes();
        int length = nodeMap.getLength();
        for (int i = 0; i < length; ++i) {
            ExtensionRegistry extReg;
            XMLAttr xmlAttr;
            Attr domAttr = (Attr)nodeMap.item(i);
            String localName = domAttr.getLocalName();
            String namespaceURI = domAttr.getNamespaceURI();
            String prefix = domAttr.getPrefix();
            QName attrType = new QName(namespaceURI, localName, prefix != null ? prefix : emptyString);
            String attrValue = domAttr.getValue();
            if (namespaceURI == null || namespaceURI.equals("http://www.w3.org/ns/wsdl") || namespaceURI.equals("http://www.w3.org/2000/xmlns/") || namespaceURI.equals("http://www.w3.org/2001/XMLSchema-instance") || (xmlAttr = (extReg = this.fWsdlContext.extensionRegistry).createExtAttribute(wsdlClass, attrType, extEl, attrValue)) == null) continue;
            wsdlObj.setExtensionAttribute(attrType, xmlAttr);
        }
    }

    protected XMLElement createXMLElement(Object elem) {
        DOMXMLElement domXMLElement = new DOMXMLElement(this.getErrorReporter());
        domXMLElement.setSource(elem);
        return domXMLElement;
    }

    protected void parseNamespaceDeclarations(XMLElement xmlElem, WSDLElement wsdlElem) throws WSDLException {
        Element elem = (Element)xmlElem.getSource();
        NamedNodeMap attrs = elem.getAttributes();
        int size = attrs.getLength();
        for (int i = 0; i < size; ++i) {
            Attr attr = (Attr)attrs.item(i);
            String namespaceURI = attr.getNamespaceURI();
            String localPart = attr.getLocalName();
            String value = attr.getValue();
            if (!"http://www.w3.org/2000/xmlns/".equals(namespaceURI)) continue;
            if (!"xmlns".equals(localPart)) {
                wsdlElem.addNamespace(localPart, this.getURI(value));
                continue;
            }
            wsdlElem.addNamespace(null, this.getURI(value));
        }
    }

    protected void parseSchemaForXMLSchema(DescriptionElement desc) throws WSDLException {
        TypesElement types = desc.getTypesElement();
        if (types == null) {
            types = desc.addTypesElement();
        }
        if (types.getTypeSystem() == null) {
            types.setTypeSystem(W3C_XML_SCHEMA);
        }
        try {
            Document schemaDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element schemaElem = schemaDoc.createElementNS(W3C_XML_SCHEMA, "import");
            schemaElem.setAttribute("namespace", W3C_XML_SCHEMA);
            schemaElem.setAttribute("schemaLocation", this.resolveURI(W3C_XML_SCHEMA_SCHEMA_SOURCE));
            XMLElement xmlEl = this.createXMLElement(schemaElem);
            desc.getTypesElement().addSchema(this.parseSchemaImport(xmlEl, desc));
        }
        catch (Exception e) {
            logger.error((Object)("A problem was encountered while creating the build in XML schema types: " + e));
        }
    }

    private XmlSchema retrieveSchema(XMLElement contextElement, URI contextURI, String schemaSpec) throws WSDLException {
        Document importedSchemaDoc = null;
        Element schemaEl = null;
        Object schemaLoc = null;
        URL url = null;
        try {
            URL contextURL = contextURI != null ? contextURI.toURL() : null;
            url = StringUtils.getURL((URL)contextURL, (String)schemaSpec);
        }
        catch (MalformedURLException e) {
            String baseLoc = contextURI != null ? contextURI.toString() : null;
            this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL502", new Object[]{baseLoc, schemaLoc}, (short)2);
            return null;
        }
        String schemaURL = url.toString();
        XmlSchema schemaDef = (XmlSchema)this.fImportedSchemas.get(schemaURL);
        if (schemaDef == null) {
            String resolvedLoc = null;
            try {
                URI resolvedURI = this.resolveURI(this.getURI(schemaURL));
                resolvedLoc = resolvedURI.toString();
                importedSchemaDoc = this.getDocument(new InputSource(resolvedLoc), resolvedLoc);
            }
            catch (IOException e4) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL504", new Object[]{schemaURL}, (short)1, (Exception)e4);
                return null;
            }
            schemaEl = importedSchemaDoc.getDocumentElement();
            try {
                String baseLoc = resolvedLoc;
                XmlSchemaCollection xsc = new XmlSchemaCollection();
                xsc.setBaseUri(resolvedLoc);
                xsc.setSchemaResolver((URIResolver)new DOMSchemaResolverAdapter(this.getURIResolver(), contextElement));
                schemaDef = xsc.read(schemaEl, baseLoc);
                this.fImportedSchemas.put(schemaURL, schemaDef);
            }
            catch (XmlSchemaException e) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL522", new Object[]{schemaURL}, (short)1, (Exception)((Object)e));
            }
        }
        return schemaDef;
    }

    private Document getDocument(InputSource inputSource, String desc) throws WSDLException, IOException {
        Document doc = null;
        try {
            DocumentBuilderFactory factory = this.createDocumentBuilderFactory(true);
            EntityResolverAdapter entityResolver = new EntityResolverAdapter(this.getURIResolver());
            ErrorHandlerWrapper errorHandler = new ErrorHandlerWrapper(this.getErrorReporter());
            DocumentBuilder builder = this.createDocumentBuilder(factory, (EntityResolver)entityResolver, errorHandler);
            doc = builder.parse(inputSource);
        }
        catch (ParserConfigurationException e) {
            String msg = this.getErrorReporter().getFormattedMessage("WSDL002", new Object[]{"XML"});
            throw new WSDLException("CONFIGURATION_ERROR", msg, (Throwable)e);
        }
        catch (SAXException e) {
            this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL500", new Object[]{"SAX", desc}, (short)3, (Exception)e);
        }
        return doc;
    }

    protected DescriptionElement getWSDLFromLocation(String locationURI, DescriptionElement desc, Map wsdlModules) throws WSDLException {
        DescriptionElement referencedDesc = null;
        URL locationURL = null;
        URI contextURI = null;
        try {
            contextURI = this.resolveURI(desc.getDocumentBaseURI());
            URL contextURL = contextURI != null ? contextURI.toURL() : null;
            locationURL = StringUtils.getURL((URL)contextURL, (String)locationURI);
        }
        catch (MalformedURLException e) {
            String baseURI = contextURI != null ? contextURI.toString() : null;
            this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL502", new Object[]{baseURI, locationURI}, (short)2);
            return null;
        }
        String locationStr = locationURL.toString();
        referencedDesc = (DescriptionElement)wsdlModules.get(locationStr);
        if (referencedDesc == null) {
            Element docEl;
            try {
                Document doc = this.getDocument(new InputSource(locationStr), locationStr);
                docEl = doc.getDocumentElement();
            }
            catch (IOException e) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL503", new Object[]{locationStr}, (short)1, (Exception)e);
                return null;
            }
            QName docElQN = new QName(docEl.getNamespaceURI(), docEl.getLocalName());
            if (!Constants.Q_ELEM_DESCRIPTION.equals(docElQN)) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL501", new Object[]{Constants.Q_ELEM_DESCRIPTION, docElQN}, (short)2);
                return null;
            }
            XMLElement descEl = this.createXMLElement(docEl);
            referencedDesc = this.parseDescription(locationStr, descEl, wsdlModules);
            if (!wsdlModules.containsKey(locationStr)) {
                wsdlModules.put(locationStr, referencedDesc);
            }
        }
        return referencedDesc;
    }

    protected DocumentBuilderFactory createDocumentBuilderFactory(boolean namespaceAware) throws ParserConfigurationException, WSDLException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(namespaceAware);
        if (this.features.getValue("http://ws.apache.org/woden/features/validation")) {
            factory.setValidating(true);
            factory.setNamespaceAware(true);
            try {
                factory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
                factory.setAttribute(JAXP_SCHEMA_SOURCE, schemas);
            }
            catch (IllegalArgumentException e) {
                this.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL515", new Object[]{factory.getClass().getName()}, (short)3, (Exception)e);
            }
        } else {
            factory.setValidating(false);
        }
        return factory;
    }

    protected DocumentBuilder createDocumentBuilder(DocumentBuilderFactory factory, EntityResolver entityResolver, ErrorHandler errorHandler) throws ParserConfigurationException {
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        if (entityResolver != null) {
            docBuilder.setEntityResolver(entityResolver);
        }
        if (errorHandler != null) {
            docBuilder.setErrorHandler(errorHandler);
        }
        return docBuilder;
    }

    class WSDLEntityResolver
    implements EntityResolver {
        WSDLEntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return null;
        }
    }

    class ErrorHandlerWrapper
    implements ErrorHandler {
        private ErrorReporter errorReporter;

        public ErrorHandlerWrapper(ErrorReporter errorReporter) {
            this.errorReporter = errorReporter;
        }

        public void error(SAXParseException error) throws SAXException {
            ErrorLocatorImpl locator = new ErrorLocatorImpl();
            locator.setLineNumber(error.getLineNumber());
            locator.setColumnNumber(error.getColumnNumber());
            try {
                this.errorReporter.reportError((ErrorLocator)locator, null, error.getMessage(), (short)2, error.getException());
            }
            catch (WSDLException e) {
                throw new SAXException("A problem occurred setting the error in the Woden error reporter wrapper.", (Exception)((Object)e));
            }
        }

        public void fatalError(SAXParseException error) throws SAXException {
            ErrorLocatorImpl locator = new ErrorLocatorImpl();
            locator.setLineNumber(error.getLineNumber());
            locator.setColumnNumber(error.getColumnNumber());
            try {
                this.errorReporter.reportError((ErrorLocator)locator, null, error.getMessage(), (short)3, error.getException());
            }
            catch (WSDLException e) {
                throw new SAXException("A problem occurred setting the error in the Woden error reporter wrapper.", (Exception)((Object)e));
            }
        }

        public void warning(SAXParseException warning) throws SAXException {
            ErrorLocatorImpl locator = new ErrorLocatorImpl();
            locator.setLineNumber(warning.getLineNumber());
            locator.setColumnNumber(warning.getColumnNumber());
            try {
                this.errorReporter.reportError((ErrorLocator)locator, null, warning.getMessage(), (short)1, warning.getException());
            }
            catch (WSDLException e) {
                throw new SAXException("A problem occurred setting the error in the Woden error reporter wrapper.", (Exception)((Object)e));
            }
        }
    }
}

