/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.util;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.mina.common.Session;
import org.apache.mina.util.BlockingQueue;
import org.apache.mina.util.Event;
import org.apache.mina.util.EventType;
import org.apache.mina.util.IdentityHashSet;
import org.apache.mina.util.Queue;
import org.apache.mina.util.Stack;
import org.apache.mina.util.ThreadPool;

public abstract class BaseThreadPool
implements ThreadPool {
    public static final int DEFAULT_MAXIMUM_POOL_SIZE = Integer.MAX_VALUE;
    public static final int DEFAULT_KEEP_ALIVE_TIME = 60000;
    private static final Queue threadIdReuseQueue = new Queue();
    private static int threadId = 0;
    private final String threadNamePrefix;
    private final Map buffers = new IdentityHashMap();
    private final BlockingQueue unfetchedSessionBuffers = new BlockingQueue();
    private final Set allSessionBuffers = new IdentityHashSet();
    private Worker leader;
    private final Stack followers = new Stack();
    private final Set allWorkers = new IdentityHashSet();
    private int maximumPoolSize = Integer.MAX_VALUE;
    private int keepAliveTime = 60000;
    private boolean started;
    private boolean shuttingDown;
    private int poolSize;
    private final Object poolSizeLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int acquireThreadId() {
        Queue queue = threadIdReuseQueue;
        synchronized (queue) {
            Integer id = (Integer)threadIdReuseQueue.pop();
            if (id == null) {
                return ++threadId;
            }
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseThreadId(int id) {
        Queue queue = threadIdReuseQueue;
        synchronized (queue) {
            threadIdReuseQueue.push(new Integer(id));
        }
    }

    public BaseThreadPool(String threadNamePrefix) {
        if (threadNamePrefix == null) {
            throw new NullPointerException("threadNamePrefix");
        }
        if ((threadNamePrefix = threadNamePrefix.trim()).length() == 0) {
            throw new IllegalArgumentException("threadNamePrefix is empty.");
        }
        this.threadNamePrefix = threadNamePrefix;
    }

    public String getThreadNamePrefix() {
        return this.threadNamePrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPoolSize() {
        Object object = this.poolSizeLock;
        synchronized (object) {
            return this.poolSize;
        }
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public int getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        if (maximumPoolSize <= 0) {
            throw new IllegalArgumentException();
        }
        this.maximumPoolSize = maximumPoolSize;
    }

    public void setKeepAliveTime(int keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public synchronized void start() {
        if (this.started) {
            return;
        }
        this.shuttingDown = false;
        this.leader = new Worker();
        this.leader.start();
        this.leader.lead();
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.shuttingDown = true;
        while (this.getPoolSize() != 0) {
            ArrayList allWorkers;
            Object object = this.poolSizeLock;
            synchronized (object) {
                allWorkers = new ArrayList(this.allWorkers);
            }
            Iterator i = allWorkers.iterator();
            while (i.hasNext()) {
                Worker worker = (Worker)i.next();
                while (worker.isAlive()) {
                    worker.interrupt();
                    try {
                        worker.join(100L);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }
        this.allSessionBuffers.clear();
        this.unfetchedSessionBuffers.clear();
        this.buffers.clear();
        this.followers.clear();
        this.leader = null;
        this.started = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void increasePoolSize(Worker worker) {
        Object object = this.poolSizeLock;
        synchronized (object) {
            ++this.poolSize;
            this.allWorkers.add(worker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decreasePoolSize(Worker worker) {
        Object object = this.poolSizeLock;
        synchronized (object) {
            --this.poolSize;
            this.allWorkers.remove(worker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEvent(Object nextFilter, Session session, EventType type, Object data) {
        BlockingQueue unfetchedSessionBuffers = this.unfetchedSessionBuffers;
        Set allSessionBuffers = this.allSessionBuffers;
        Event event = new Event(type, nextFilter, data);
        BlockingQueue blockingQueue = unfetchedSessionBuffers;
        synchronized (blockingQueue) {
            SessionBuffer buf = this.getSessionBuffer(session);
            Queue eventQueue = buf.eventQueue;
            SessionBuffer sessionBuffer = buf;
            synchronized (sessionBuffer) {
                eventQueue.push(event);
            }
            if (!allSessionBuffers.contains(buf)) {
                allSessionBuffers.add(buf);
                unfetchedSessionBuffers.push(buf);
            }
        }
    }

    protected abstract void processEvent(Object var1, Session var2, EventType var3, Object var4);

    protected SessionBuffer fetchSessionBuffer(Queue unfetchedSessionBuffers) {
        return (SessionBuffer)unfetchedSessionBuffers.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionBuffer getSessionBuffer(Session session) {
        Map buffers = this.buffers;
        SessionBuffer buf = (SessionBuffer)buffers.get(session);
        if (buf == null) {
            Map map = buffers;
            synchronized (map) {
                buf = (SessionBuffer)buffers.get(session);
                if (buf == null) {
                    buf = new SessionBuffer(session);
                    buffers.put(session, buf);
                }
            }
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSessionBuffer(SessionBuffer buf) {
        Map buffers = this.buffers;
        Session session = buf.session;
        Map map = buffers;
        synchronized (map) {
            buffers.remove(session);
        }
    }

    private class Worker
    extends Thread {
        private final int id;
        private final Object promotionLock = new Object();
        private boolean dead;

        private Worker() {
            int id;
            this.id = id = BaseThreadPool.acquireThreadId();
            this.setName(BaseThreadPool.this.threadNamePrefix + '-' + id);
            BaseThreadPool.this.increasePoolSize(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean lead() {
            Object promotionLock;
            Object object = promotionLock = this.promotionLock;
            synchronized (object) {
                if (this.dead) {
                    return false;
                }
                BaseThreadPool.this.leader = this;
                promotionLock.notify();
            }
            return true;
        }

        public void run() {
            while (this.waitForPromotion()) {
                SessionBuffer buf = this.fetchBuffer();
                this.giveUpLead();
                if (buf == null) break;
                this.processEvents(buf);
                this.follow();
                this.releaseBuffer(buf);
            }
            BaseThreadPool.this.decreasePoolSize(this);
            BaseThreadPool.releaseThreadId(this.id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SessionBuffer fetchBuffer() {
            BlockingQueue unfetchedSessionBuffers;
            BlockingQueue blockingQueue = unfetchedSessionBuffers = BaseThreadPool.this.unfetchedSessionBuffers;
            synchronized (blockingQueue) {
                while (!BaseThreadPool.this.shuttingDown) {
                    try {
                        unfetchedSessionBuffers.waitForNewItem();
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    return BaseThreadPool.this.fetchSessionBuffer(unfetchedSessionBuffers);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processEvents(SessionBuffer buf) {
            Session session = buf.session;
            Queue eventQueue = buf.eventQueue;
            while (true) {
                Event event;
                SessionBuffer sessionBuffer = buf;
                synchronized (sessionBuffer) {
                    event = (Event)eventQueue.pop();
                    if (event == null) {
                        break;
                    }
                }
                BaseThreadPool.this.processEvent(event.getNextFilter(), session, event.getType(), event.getData());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void follow() {
            Object promotionLock = this.promotionLock;
            Stack followers = BaseThreadPool.this.followers;
            Object object = promotionLock;
            synchronized (object) {
                if (this != BaseThreadPool.this.leader) {
                    Stack stack = followers;
                    synchronized (stack) {
                        followers.push(this);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void releaseBuffer(SessionBuffer buf) {
            BlockingQueue unfetchedSessionBuffers = BaseThreadPool.this.unfetchedSessionBuffers;
            Set allSessionBuffers = BaseThreadPool.this.allSessionBuffers;
            Queue eventQueue = buf.eventQueue;
            BlockingQueue blockingQueue = unfetchedSessionBuffers;
            synchronized (blockingQueue) {
                if (eventQueue.isEmpty()) {
                    allSessionBuffers.remove(buf);
                    BaseThreadPool.this.removeSessionBuffer(buf);
                } else {
                    unfetchedSessionBuffers.push(buf);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean waitForPromotion() {
            long startTime;
            Object promotionLock = this.promotionLock;
            long currentTime = startTime = System.currentTimeMillis();
            Object object = promotionLock;
            synchronized (object) {
                boolean timeToLead;
                int keepAliveTime;
                while (this != BaseThreadPool.this.leader && !BaseThreadPool.this.shuttingDown && (keepAliveTime = (keepAliveTime = BaseThreadPool.this.getKeepAliveTime()) > 0 ? (int)((long)keepAliveTime - (currentTime - startTime)) : Integer.MAX_VALUE) > 0) {
                    try {
                        promotionLock.wait(keepAliveTime);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    currentTime = System.currentTimeMillis();
                }
                boolean bl = timeToLead = this == BaseThreadPool.this.leader && !BaseThreadPool.this.shuttingDown;
                if (!timeToLead) {
                    Stack stack = BaseThreadPool.this.followers;
                    synchronized (stack) {
                        BaseThreadPool.this.followers.remove(this);
                    }
                    this.dead = true;
                }
                return timeToLead;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void giveUpLead() {
            Worker worker;
            Stack followers = BaseThreadPool.this.followers;
            do {
                Stack stack = followers;
                synchronized (stack) {
                    worker = (Worker)followers.pop();
                }
                if (worker != null) continue;
                if (BaseThreadPool.this.shuttingDown || BaseThreadPool.this.getPoolSize() >= BaseThreadPool.this.getMaximumPoolSize()) break;
                worker = new Worker();
                worker.lead();
                worker.start();
                break;
            } while (!worker.lead());
        }
    }

    protected static class SessionBuffer {
        private final Session session;
        private final Queue eventQueue = new Queue();

        private SessionBuffer(Session session) {
            this.session = session;
        }

        public Session getSession() {
            return this.session;
        }

        public Queue getEventQueue() {
            return this.eventQueue;
        }
    }
}

