/*
 * Decompiled with CFR 0.152.
 */
package jun.dock.impl;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.net.URL;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Hashtable;
import jun.dock.core.DockFramework;

class UTIL {
    static final String IDC_WE = "WE.gif";
    static final String IDC_NS = "NS.gif";
    static final String IDC_ARROW = "DEFAULT";
    static final String IDC_SYS_WE = "SYS_WE";
    static final String IDC_SYS_NS = "SYS_NS";
    static final String IDC_MOVE = "MOVE.gif";
    static final String IDC_EXCHANGE = "EXCHANGE.gif";
    static Hashtable m_FontMap = new Hashtable();

    UTIL() {
    }

    static void DrawString(Graphics2D g, Rectangle rc, String s, int bkMode, Color bkcolor, Color textcolor, String FontName, int FontSize, boolean FontBold, boolean FontItalic, boolean FontUnderline, int hAlign, int vAlign) {
        g.setColor(bkcolor);
        if (bkMode != 0) {
            g.fillRect(rc.x, rc.y, rc.width, rc.height);
        }
        g.setColor(textcolor);
        Rectangle oc = g.getClipBounds();
        g.setClip(rc.x, rc.y, rc.width, rc.height);
        Font font = UTIL.GetFont(FontName, FontSize, FontBold, FontItalic, FontUnderline);
        FontRenderContext frc = g.getFontRenderContext();
        TextLayout layout = new TextLayout(s, font, frc);
        float drawPosY = rc.y;
        switch (vAlign) {
            case 1: {
                drawPosY += (float)rc.height - layout.getDescent() - layout.getLeading();
                break;
            }
            case 2: {
                drawPosY += layout.getAscent() + ((float)rc.height - layout.getAscent() - layout.getDescent() - layout.getLeading()) / 2.0f;
                break;
            }
            default: {
                drawPosY += layout.getAscent();
            }
        }
        float drawPosX = rc.x;
        switch (hAlign) {
            case 1: {
                drawPosX = (float)(rc.x + rc.width) - layout.getAdvance();
                break;
            }
            case 2: {
                drawPosX = (float)rc.x + ((float)rc.width - layout.getAdvance()) / 2.0f;
                break;
            }
            default: {
                drawPosX = rc.x;
            }
        }
        layout.draw(g, drawPosX, drawPosY);
        if (oc != null) {
            g.setClip(oc.x, oc.y, oc.width, oc.height);
        }
    }

    static void DrawString(Graphics2D g, Rectangle rc, String s, int bkMode, Color bkcolor, Color textcolor, String FontName, int FontSize, boolean FontBold, boolean FontItalic, boolean FontUnderline, int hAlign, int vAlign, boolean MultiLine) {
        if (s.trim().equals("")) {
            return;
        }
        if (rc.width <= 0 || rc.height <= 0) {
            return;
        }
        if (!MultiLine) {
            UTIL.DrawString(g, rc, s, bkMode, bkcolor, textcolor, FontName, FontSize, FontBold, FontItalic, FontUnderline, hAlign, vAlign);
            return;
        }
        g.setColor(bkcolor);
        if (bkMode != 0) {
            g.fillRect(rc.x, rc.y, rc.width, rc.height);
        }
        g.setColor(textcolor);
        Dimension size = rc.getSize();
        Rectangle oc = g.getClipBounds();
        g.setClip(rc.x, rc.y, rc.width, rc.height);
        Hashtable<TextAttribute, Object> map = new Hashtable<TextAttribute, Object>();
        map.put(TextAttribute.FAMILY, FontName);
        map.put(TextAttribute.SIZE, new Float(FontSize));
        if (FontUnderline) {
            map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (FontBold) {
            map.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (FontItalic) {
            map.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        AttributedString ss = new AttributedString(s, map);
        AttributedCharacterIterator text = ss.getIterator();
        FontRenderContext frc = g.getFontRenderContext();
        int paragraphStart = text.getBeginIndex();
        int paragraphEnd = text.getEndIndex();
        LineBreakMeasurer lineMeasurer = new LineBreakMeasurer(text, frc);
        float formatWidth = size.width;
        float drawPosY = rc.y;
        if (MultiLine && vAlign != 0) {
            double gg = 0.0;
            lineMeasurer.setPosition(paragraphStart);
            while (lineMeasurer.getPosition() < paragraphEnd) {
                TextLayout layout = lineMeasurer.nextLayout(formatWidth);
                gg += (double)(layout.getDescent() + layout.getLeading() + layout.getAscent());
            }
            if (gg < (double)rc.height) {
                if (vAlign == 2) {
                    drawPosY = (float)((double)drawPosY + ((double)rc.height - gg) / 2.0);
                }
                if (vAlign == 1) {
                    drawPosY = (float)((double)drawPosY + ((double)rc.height - gg));
                }
            }
        }
        lineMeasurer.setPosition(paragraphStart);
        while (lineMeasurer.getPosition() < paragraphEnd) {
            TextLayout layout = lineMeasurer.nextLayout(formatWidth);
            switch (vAlign) {
                case 1: {
                    if (!MultiLine) {
                        drawPosY += (float)rc.height - layout.getDescent() - layout.getLeading();
                        break;
                    }
                }
                case 2: {
                    if (!MultiLine) {
                        drawPosY += layout.getAscent() + ((float)rc.height - layout.getAscent() - layout.getDescent() - layout.getLeading()) / 2.0f;
                        break;
                    }
                }
                default: {
                    drawPosY += layout.getAscent();
                }
            }
            float drawPosX = rc.x;
            switch (hAlign) {
                case 1: {
                    drawPosX = (float)rc.x + formatWidth - layout.getAdvance();
                    break;
                }
                case 2: {
                    drawPosX = (float)rc.x + (formatWidth - layout.getAdvance()) / 2.0f;
                    break;
                }
                default: {
                    drawPosX = rc.x;
                }
            }
            layout.draw(g, drawPosX, drawPosY);
            if ((drawPosY += layout.getDescent() + layout.getLeading()) >= (float)(rc.y + rc.height) || !MultiLine) break;
        }
        g.setClip(oc.x, oc.y, oc.width, oc.height);
    }

    static Font GetFont(String FontName, int FontSize, boolean FontBold, boolean FontItalic, boolean FontUnderline) {
        String key = String.valueOf(FontName) + String.valueOf(FontSize) + String.valueOf(FontBold) + String.valueOf(FontItalic) + String.valueOf(FontUnderline);
        if (m_FontMap.containsKey(key)) {
            return (Font)m_FontMap.get(key);
        }
        Hashtable<TextAttribute, Object> map = new Hashtable<TextAttribute, Object>();
        map.put(TextAttribute.FAMILY, FontName);
        map.put(TextAttribute.SIZE, new Float(FontSize));
        if (FontUnderline) {
            map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (FontBold) {
            map.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (FontItalic) {
            map.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        Font font = new Font(map);
        m_FontMap.put(key, font);
        return font;
    }

    public static void MapToDockFrameworkPoint(Container op, Point p) {
        Container ct = op;
        Rectangle rc = ct.getBounds();
        p.x += rc.x;
        p.y += rc.y;
        while (ct != null && !(ct instanceof DockFramework)) {
            ct = ct.getParent();
            rc = ct.getBounds();
            p.x += rc.x;
            p.y += rc.y;
        }
    }

    public static Rectangle LeftPartOfRectangle(Rectangle rc) {
        return new Rectangle(rc.x, rc.y, rc.width / 4, rc.height);
    }

    public static Rectangle TopPartOfRectangle(Rectangle rc) {
        return new Rectangle(rc.x + rc.width / 4, rc.y, rc.width / 2, rc.height / 4);
    }

    public static Rectangle RightPartOfRectangle(Rectangle rc) {
        return new Rectangle(rc.x + rc.width * 3 / 4, rc.y, rc.width / 4, rc.height);
    }

    public static Rectangle BottomPartOfRectangle(Rectangle rc) {
        return new Rectangle(rc.x + rc.width / 4, rc.y + rc.height * 3 / 4, rc.width / 2, rc.height / 4);
    }

    public static Rectangle MiddlePartOfRectangle(Rectangle rc) {
        return new Rectangle(rc.x + rc.width / 4, rc.y + rc.height / 4, rc.width / 2, rc.height / 2);
    }

    public static Container GetRootContainer(Container op) {
        Container ct = op;
        while (ct != null) {
            if (ct.getParent() == null) {
                return ct;
            }
            ct = ct.getParent();
        }
        return ct;
    }

    public static Applet ContainedByApplet(Component op) {
        Component ct = op;
        while (ct != null) {
            if (ct instanceof Applet) {
                return (Applet)ct;
            }
            ct = ct.getParent();
        }
        return null;
    }

    public static int RecursionAdd(int n) {
        return (1 + n) * n / 2;
    }

    public static Cursor GetCursor(Component obj, String curName, Point hotPoint) {
        if (curName == IDC_ARROW) {
            return new Cursor(0);
        }
        if (curName == IDC_SYS_WE) {
            return new Cursor(10);
        }
        if (curName == IDC_SYS_NS) {
            return new Cursor(8);
        }
        Applet ContainedByApplet = UTIL.ContainedByApplet(obj);
        Cursor cur = null;
        Image img = null;
        Toolkit tk = Toolkit.getDefaultToolkit();
        URL url = obj.getClass().getClassLoader().getResource("jun/dock/res/" + curName);
        if (ContainedByApplet != null) {
            img = ContainedByApplet.getImage(url);
            if (img == null) {
                return new Cursor(0);
            }
            cur = tk.createCustomCursor(img, hotPoint, curName);
        } else {
            img = tk.getImage(url);
            if (img == null) {
                return new Cursor(0);
            }
            cur = tk.createCustomCursor(img, hotPoint, curName);
        }
        if (cur == null) {
            return new Cursor(0);
        }
        return cur;
    }
}

