/*
 * Decompiled with CFR 0.152.
 */
package jun.dock.impl;

import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;
import jun.dock.core.DockBar;
import jun.dock.core.DockBarFrame;
import jun.dock.core.DockBarTabButton;
import jun.dock.impl.DockBarFrame_;
import org.kxml.kdom.Element;

public class DockBar_
extends DockBar
implements ComponentListener {
    private String m_Name = "";
    private String m_Title = "";
    private JComponent m_Body = null;
    private DockBarFrame m_DockBarFrame = null;
    private int offset = 0;
    private int indexBeforeHide;
    private DockBarTabButton m_TabButton = null;

    public DockBar_(String name) {
        this.m_Name = name;
        this.m_Title = "";
        this.m_Body = null;
        this.addComponentListener(this);
        this.setLayout(null);
    }

    public void hideMe() {
        this.m_DockBarFrame.hideDockBar(this);
    }

    public void showMe() {
        this.m_DockBarFrame.showDockBar(this);
    }

    public void activeMe() {
        this.m_DockBarFrame.activeDockBar(this);
    }

    public void setDockBarIndex(int index) {
        this.m_DockBarFrame.setDockBarIndex(this, index);
    }

    public void setBody(JComponent p) {
        if (this.m_Body == p) {
            return;
        }
        if (this.m_Body != null) {
            this.remove(this.m_Body);
        }
        this.m_Body = p;
        this.add(p);
        this.componentResized(null);
    }

    public JComponent getBody() {
        return this.m_Body;
    }

    public int getDockBarIndex() {
        return this.m_DockBarFrame.getDockBarIndex(this);
    }

    public boolean isCurrentActiveBar() {
        return this.m_DockBarFrame.isCurrentActiveBar(this);
    }

    public void saveToXML(Element e) {
        e.setValue("Name", this.m_Name);
        e.setValue("Title", this.m_Title);
        e.setValue("IndexBeforeHide", String.valueOf(this.indexBeforeHide));
        e.setValue("Active", this.isCurrentActiveBar() ? "1" : "0");
    }

    public static DockBar_ CreateFromXML(Element e) {
        DockBar_ db = new DockBar_(e.getValueDefault("Name", "noname"));
        db.m_Title = e.getValueDefault("Title", "");
        db.indexBeforeHide = Integer.valueOf(e.getValueDefault("IndexBeforeHide", "0"));
        return db;
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        System.out.println(String.valueOf(this.m_Name) + "    dock  bar    resize");
        Rectangle rc = this.getBounds();
        rc.x = this.offset + 1;
        rc.y = this.offset + 1;
        rc.width -= 2 * (this.offset + 1);
        rc.height -= 2 * (this.offset + 1);
        if (this.m_Body != null) {
            this.m_Body.setBounds(rc);
            this.m_Body.doLayout();
        }
        ((DockBarFrame_)this.m_DockBarFrame).repaint();
    }

    public void componentShown(ComponentEvent e) {
    }

    public String getBarName() {
        return this.m_Name;
    }

    public void setBarName(String name) {
        this.m_Name = name;
    }

    public String getBarTitle() {
        String ret = null;
        ret = this.m_Title.equals("") ? this.m_Name : this.m_Title;
        return ret;
    }

    public void setBarTitle(String title) {
        this.m_Title = title;
    }

    public int getIndexBeforeHide() {
        return this.indexBeforeHide;
    }

    public void setIndexBeforeHide(int indexBeforeHide) {
        this.indexBeforeHide = indexBeforeHide;
    }

    public DockBarFrame getDockBarFrame() {
        return this.m_DockBarFrame;
    }

    public void setDockBarFrame(DockBarFrame dockBarFrame) {
        this.m_DockBarFrame = dockBarFrame;
    }

    public JComponent toJComponent() {
        return this;
    }

    public DockBarTabButton getTabButton() {
        return this.m_TabButton;
    }

    public void setTabButton(DockBarTabButton tabButton) {
        this.m_TabButton = tabButton;
    }
}

