/*
 * Decompiled with CFR 0.152.
 */
package jun.dock.impl;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JComponent;
import jun.dock.core.DockBar;
import jun.dock.core.DockBarFrame;
import jun.dock.core.DockBarTab;
import jun.dock.core.DockFramework;
import jun.dock.impl.DockBarFrame_;
import jun.dock.impl.DockBarTabButton_;
import jun.dock.impl.UTIL;

public class DockBarTab_
extends JComponent
implements ComponentListener,
MouseListener,
MouseMotionListener,
Serializable,
DockBarTab {
    private DockBarFrame m_Frame = null;
    private int TabBarHeight = 25;
    private ArrayList m_ItemWidthList = null;

    DockBarTab_(DockBarFrame_ f) {
        this.setLayout(null);
        this.m_Frame = f;
        f.add(this);
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.m_ItemWidthList = new ArrayList();
        this.CalculateItemWidth();
    }

    void CalculateItemWidth() {
        int w;
        if (this.m_Frame.getDockBarList().size() <= 1) {
            return;
        }
        Rectangle rc = this.getBounds();
        this.m_ItemWidthList.clear();
        ArrayList<Integer> rawWidthList = new ArrayList<Integer>();
        int totalWidth = 0;
        int ci = this.m_Frame.getActiveDockBarIndex();
        int i = 0;
        while (i < this.m_Frame.getDockBarList().size()) {
            String s = ((DockBar)this.m_Frame.getDockBarList().get(i)).getBarTitle();
            Font font = UTIL.GetFont("\u5b8b\u4f53", 12, false, false, false);
            Graphics2D g = (Graphics2D)this.getGraphics();
            if (g == null) {
                return;
            }
            FontRenderContext frc = g.getFontRenderContext();
            TextLayout layout = new TextLayout(s, font, frc);
            w = (int)layout.getAdvance();
            if (w < 5) {
                w = 5;
            }
            w = w + 10 + 7;
            totalWidth += w;
            rawWidthList.add(new Integer(w));
            ++i;
        }
        int clientWidth = rc.width - 10;
        int tabCount = rawWidthList.size();
        int w1 = tabCount * 10;
        int w2 = (tabCount - 1) * 10 + (Integer)rawWidthList.get(ci);
        int w3 = totalWidth;
        if (clientWidth <= w1) {
            w = clientWidth / tabCount;
            i = 0;
            while (i < tabCount) {
                this.m_ItemWidthList.add(new Integer(w));
                ++i;
            }
        }
        if (clientWidth > w1 && clientWidth <= w2) {
            w = clientWidth - (tabCount - 1) * 10;
            i = 0;
            while (i < tabCount) {
                if (i != ci) {
                    this.m_ItemWidthList.add(new Integer(10));
                } else {
                    this.m_ItemWidthList.add(new Integer(w));
                }
                ++i;
            }
        }
        if (clientWidth > w2 && clientWidth <= w3) {
            int leftW = clientWidth - (Integer)rawWidthList.get(ci);
            int leftW2 = totalWidth - (Integer)rawWidthList.get(ci);
            i = 0;
            while (i < tabCount) {
                w = (Integer)rawWidthList.get(i);
                w = (int)((float)leftW * (float)w / (float)leftW2);
                if (i != ci) {
                    this.m_ItemWidthList.add(new Integer(w));
                } else {
                    this.m_ItemWidthList.add(rawWidthList.get(ci));
                }
                ++i;
            }
        }
        if (clientWidth > w3) {
            this.m_ItemWidthList.addAll(rawWidthList);
        }
        w = 0;
        int x = 3;
        i = 0;
        while (i < this.m_ItemWidthList.size()) {
            w = (Integer)this.m_ItemWidthList.get(i);
            Rectangle irc = new Rectangle(x += w, 3, w, 22);
            DockBar db = (DockBar)this.m_Frame.getDockBarList().get(i);
            ((DockBarTabButton_)db.getTabButton()).setBounds(irc);
            ++i;
        }
    }

    public void componentResized(ComponentEvent e) {
        this.CalculateItemWidth();
        this.doLayout();
    }

    public void paint(Graphics g) {
        if (this.m_ItemWidthList.size() == 0) {
            return;
        }
        Rectangle rc = this.getBounds();
        g.setColor(DockFramework.BackGroundColor);
        g.fillRect(0, 0, rc.width, 2);
        g.setColor(DockFramework.BorderLineColor);
        g.drawLine(0, 0, 0, 3);
        g.drawLine(0, 3, rc.width - 1, 3);
        g.drawLine(rc.width - 1, 3, rc.width - 1, 0);
        g.setColor(DockFramework.BackGroundColor);
        g.fillRect(0, 4, rc.width, rc.height - 4);
        super.paint(g);
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public DockBarFrame getDockBarFrame() {
        return this.m_Frame;
    }

    public ArrayList getItemWidthList() {
        return this.m_ItemWidthList;
    }

    public int getTabBarHeight() {
        return this.TabBarHeight;
    }

    public void setTabBarHeight(int tabBarHeight) {
        this.TabBarHeight = tabBarHeight;
    }
}

