/*
 * Decompiled with CFR 0.152.
 */
package jun.dock.impl;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JComponent;
import jun.dock.core.DockBarFrameTitle;
import jun.dock.core.DockContainer;
import jun.dock.core.DockFramework;
import jun.dock.impl.DockBarFrame_;
import jun.dock.impl.DockBar_;
import jun.dock.impl.DockContainer_;
import jun.dock.impl.TransparentFrame_;
import jun.dock.impl.UTIL;

public class DockBarFrameTitle_
extends JComponent
implements ComponentListener,
MouseListener,
MouseMotionListener,
Serializable,
DockBarFrameTitle {
    private DockBarFrame_ m_Frame = null;
    private int TitleBarHeight = 20;
    private int BackStyle = 2;
    private DockFramework m_DockFramework = null;
    private TransparentFrame_ m_TransFrame = null;
    private Point m_MouseDownPoint = new Point(0, 0);
    private Point m_RootPoint = new Point(0, 0);
    private boolean m_IsDraging = false;

    DockBarFrameTitle_(DockBarFrame_ f) {
        this.m_Frame = f;
        f.add(this);
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void paint(Graphics g) {
        Rectangle rc = this.getBounds();
        g.setColor(DockFramework.BorderLineColor);
        g.drawLine(2, 0, rc.width - 3, 0);
        g.drawLine(rc.width - 3, 0, rc.width - 1, 2);
        g.drawLine(rc.width - 1, 2, rc.width - 1, rc.height - 1);
        g.drawLine(rc.width - 1, rc.height - 1, 0, rc.height - 1);
        g.drawLine(0, rc.height - 1, 0, 2);
        g.drawLine(0, 2, 2, 0);
        Graphics2D g2 = (Graphics2D)g;
        int[] x = new int[]{2, rc.width - 2, rc.width - 1, rc.width - 1, 1, 1, 2};
        int[] y = new int[]{1, 1, 2, rc.height - 1, rc.height - 1, 2, 1};
        g.setColor(new Color(212, 208, 200));
        g.fillPolygon(x, y, 7);
        g.setColor(new Color(148, 148, 148));
        g.drawLine(2, 0, 2, 0);
        g.drawLine(0, 2, 0, 2);
        g.drawLine(rc.width - 3, 0, rc.width - 3, 0);
        g.drawLine(rc.width - 1, 2, rc.width - 1, 2);
        switch (this.BackStyle) {
            case 1: {
                Color[] c = new Color[]{new Color(255, 255, 255), new Color(252, 252, 252), new Color(247, 247, 247), new Color(242, 241, 241), new Color(237, 235, 235), new Color(231, 228, 229), new Color(220, 217, 217), new Color(223, 220, 220), new Color(226, 224, 223), new Color(230, 228, 229), new Color(232, 230, 230), new Color(236, 235, 235), new Color(241, 240, 240), new Color(246, 246, 246), new Color(251, 251, 252), new Color(255, 255, 255)};
                int i = 1;
                while (i <= Math.min(c.length, this.TitleBarHeight - 1)) {
                    g.setColor(c[i - 1]);
                    if (i == 1) {
                        g.drawLine(2, i, rc.width - 3, i);
                    }
                    if (i > 1) {
                        g.drawLine(1, i, rc.width - 2, i);
                    }
                    ++i;
                }
                i = Math.min(c.length, this.TitleBarHeight - 1);
                while (i < this.TitleBarHeight) {
                    g.setColor(Color.WHITE);
                    g.drawLine(1, i, rc.width - 2, i);
                    ++i;
                }
                break;
            }
            case 2: {
                int i = this.TitleBarHeight - 1;
                while (i > 0) {
                    int red = Math.min(255, DockFramework.BackGroundColor.getRed() + (this.TitleBarHeight - 1 - i) * 2);
                    int green = Math.min(255, DockFramework.BackGroundColor.getGreen() + (this.TitleBarHeight - 1 - i) * 2);
                    int blue = Math.min(255, DockFramework.BackGroundColor.getBlue() + (this.TitleBarHeight - 1 - i) * 2);
                    g.setColor(new Color(red, green, blue));
                    if (i == 1) {
                        g.drawLine(2, i, rc.width - 3, i);
                    }
                    if (i > 1) {
                        g.drawLine(1, i, rc.width - 2, i);
                    }
                    --i;
                }
                break;
            }
        }
        g.setColor(DockFramework.BorderLineColor);
        g.drawLine(1, this.TitleBarHeight, rc.width - 2, this.TitleBarHeight);
        g.setColor(Color.BLACK);
        Rectangle oc = g.getClipBounds();
        g.setClip(rc.x + 10, rc.y, rc.width - 20, rc.height);
        g.setFont(new Font("\u5b8b\u4f53", 0, 12));
        g.drawString(this.getTitle(), 10, 14);
        g.setClip(oc.x, oc.y, oc.width, oc.height);
        super.paint(g);
    }

    public DockFramework getDockFramework() {
        Container ct = this.getParent();
        while (ct != null && !(ct instanceof DockFramework)) {
            ct = ct.getParent();
        }
        if (ct == null) {
            return null;
        }
        return (DockFramework)ct;
    }

    public String getTitle() {
        return this.m_Frame.getActiveDockBar().getBarTitle();
    }

    public void componentResized(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    Rectangle CalculateTransFrameRectangle(MouseEvent e) {
        Rectangle rc = this.m_Frame.getBounds();
        this.m_RootPoint = e.getPoint();
        UTIL.MapToDockFrameworkPoint(this, this.m_RootPoint);
        rc.x = this.m_RootPoint.x - this.m_MouseDownPoint.x;
        rc.y = this.m_RootPoint.y - this.m_MouseDownPoint.y;
        return rc;
    }

    public void mousePressed(MouseEvent e) {
        this.m_MouseDownPoint = e.getPoint();
        this.m_DockFramework = this.getDockFramework();
        this.m_TransFrame = (TransparentFrame_)this.m_DockFramework.getTransFrame();
    }

    public void mouseReleased(MouseEvent e) {
        DockContainer_ toWhich = null;
        boolean dockAhead = true;
        if (this.m_IsDraging && this.m_DockFramework != null && this.m_DockFramework.getTransFrame() != null) {
            ((TransparentFrame_)this.m_DockFramework.getTransFrame()).setVisible(false);
            toWhich = (DockContainer_)this.m_TransFrame.getDockToWhich();
            if (toWhich != null) {
                DockContainer_ delDC = (DockContainer_)this.m_Frame.getParent();
                DockContainer_ pDelDC = (DockContainer_)delDC.getParentContainer();
                int sd = 0;
                switch (this.m_TransFrame.getDockToWhere()) {
                    case 1: {
                        dockAhead = true;
                        sd = 2;
                        break;
                    }
                    case 2: {
                        dockAhead = false;
                        sd = 2;
                        break;
                    }
                    case 4: {
                        dockAhead = true;
                        sd = 1;
                        break;
                    }
                    case 8: {
                        dockAhead = false;
                        sd = 1;
                        break;
                    }
                }
                if (this.m_TransFrame.getDockToWhere() == 1 || this.m_TransFrame.getDockToWhere() == 2 || this.m_TransFrame.getDockToWhere() == 4 || this.m_TransFrame.getDockToWhere() == 8) {
                    if (toWhich.isRoot()) {
                        pDelDC.removeDockContainer(delDC);
                        toWhich.Split(sd, null, delDC, dockAhead);
                    } else if (toWhich.getParentContainer().equals(pDelDC)) {
                        if (pDelDC.getSplitDirection() == sd) {
                            pDelDC.moveDockContainerAheadOrBehind(delDC, toWhich, dockAhead);
                        } else {
                            pDelDC.removeDockContainer(delDC);
                            if (toWhich.getContainerList().size() == 0) {
                                pDelDC.Split(sd, null, delDC, dockAhead);
                            } else {
                                toWhich.Split(sd, null, delDC, dockAhead);
                            }
                        }
                    } else {
                        pDelDC.removeDockContainer(delDC);
                        toWhich.Split(sd, null, delDC, dockAhead);
                    }
                }
                if (this.m_TransFrame.getDockToWhere() == 16) {
                    pDelDC.removeDockContainer(delDC);
                    ArrayList BarList = delDC.getDockBarFrame().getDockBarList();
                    int i = 0;
                    while (i < BarList.size()) {
                        toWhich.getDockBarFrame().addBar((DockBar_)BarList.get(i));
                        ++i;
                    }
                }
                this.m_TransFrame.getDockToWhere();
            }
        }
        this.m_IsDraging = false;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        this.m_IsDraging = true;
        Rectangle rc = this.CalculateTransFrameRectangle(e);
        Rectangle thisRC = ((DockContainer_)this.m_Frame.getParent()).getAbsoluteBounds();
        DockContainer dc = this.m_DockFramework.getDockContainerAtPoint(this.m_RootPoint);
        Rectangle dcRC = null;
        int level = 0;
        dcRC = dc == null ? new Rectangle(0, 0, 0, 0) : ((DockContainer_)dc).getAbsoluteBounds();
        Rectangle rcLeft = UTIL.LeftPartOfRectangle(dcRC);
        Rectangle rcTop = UTIL.TopPartOfRectangle(dcRC);
        Rectangle rcRight = UTIL.RightPartOfRectangle(dcRC);
        Rectangle rcBottom = UTIL.BottomPartOfRectangle(dcRC);
        Rectangle rcMiddle = UTIL.MiddlePartOfRectangle(dcRC);
        int pos = 0;
        if (rcLeft.contains(this.m_RootPoint)) {
            pos = 1;
        }
        if (rcRight.contains(this.m_RootPoint)) {
            pos = 2;
        }
        if (rcTop.contains(this.m_RootPoint)) {
            pos = 4;
        }
        if (rcBottom.contains(this.m_RootPoint)) {
            pos = 8;
        }
        if (rcMiddle.contains(this.m_RootPoint)) {
            pos = 16;
        }
        if (thisRC.contains(this.m_RootPoint)) {
            pos = 0;
        }
        this.m_TransFrame.setDockToWhich(dc);
        this.m_TransFrame.setDockToWhere(pos);
        if (dc != null) {
            switch (pos) {
                case 1: {
                    level = dc.sameLeftAscendCount() + 1;
                    level -= this.MapLevel(this.m_RootPoint.x - rcLeft.x, rcLeft.width, level);
                    dc = dc.ascend(level);
                    dcRC = ((DockContainer_)dc).getAbsoluteBounds();
                    rcLeft = UTIL.LeftPartOfRectangle(dcRC);
                    this.m_TransFrame.setDockToWhich(dc);
                    rc = rcLeft;
                    this.m_TransFrame.setStyle(2);
                    break;
                }
                case 2: {
                    level = dc.sameRightAscendCount() + 1;
                    level -= this.MapLevel(rcRight.x + rcRight.width - this.m_RootPoint.x, rcRight.width, level);
                    dc = dc.ascend(level);
                    dcRC = ((DockContainer_)dc).getAbsoluteBounds();
                    rcRight = UTIL.RightPartOfRectangle(dcRC);
                    this.m_TransFrame.setDockToWhich(dc);
                    rc = rcRight;
                    this.m_TransFrame.setStyle(2);
                    break;
                }
                case 4: {
                    level = dc.sameTopAscendCount() + 1;
                    level -= this.MapLevel(this.m_RootPoint.y - rcTop.y, rcTop.height, level);
                    dc = dc.ascend(level);
                    dcRC = ((DockContainer_)dc).getAbsoluteBounds();
                    rcTop = UTIL.TopPartOfRectangle(dcRC);
                    this.m_TransFrame.setDockToWhich(dc);
                    rc = rcTop;
                    rc.x = dcRC.x;
                    rc.width = dcRC.width;
                    this.m_TransFrame.setStyle(2);
                    break;
                }
                case 8: {
                    level = dc.sameBottomAscendCount() + 1;
                    level -= this.MapLevel(rcBottom.y + rcBottom.height - this.m_RootPoint.y, rcBottom.height, level);
                    dc = dc.ascend(level);
                    dcRC = ((DockContainer_)dc).getAbsoluteBounds();
                    rcBottom = UTIL.BottomPartOfRectangle(dcRC);
                    this.m_TransFrame.setDockToWhich(dc);
                    rc = rcBottom;
                    rc.x = dcRC.x;
                    rc.width = dcRC.width;
                    this.m_TransFrame.setStyle(2);
                    break;
                }
                case 16: {
                    rc = dcRC;
                    this.m_TransFrame.setStyle(3);
                    break;
                }
                case 0: {
                    this.m_TransFrame.setStyle(2);
                }
            }
        }
        this.m_TransFrame.setBounds(rc);
        this.m_TransFrame.setVisible(true);
    }

    private int MapLevel(int distance, int width, int level) {
        float f = (float)distance / (float)(width == 0 ? 1 : width);
        int n = 0;
        n = UTIL.RecursionAdd(level);
        int i = 1;
        while (i <= level) {
            float f1 = (float)UTIL.RecursionAdd(i - 1) / (float)n;
            float f2 = (float)UTIL.RecursionAdd(i) / (float)n;
            if (f > f1 && f <= f2) {
                return i;
            }
            ++i;
        }
        return 1;
    }

    public void mouseMoved(MouseEvent e) {
    }

    public int getTitleBarHeight() {
        return this.TitleBarHeight;
    }

    public void setTitleBarHeight(int titleBarHeight) {
        this.TitleBarHeight = titleBarHeight;
    }
}

