/*
 * Decompiled with CFR 0.152.
 */
package jun.db.util;

import java.io.Serializable;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import jun.db.util.Escape;

public class ZDataParser
implements Serializable {
    StringBuffer sb;

    public ZDataParser() {
        this.sb = new StringBuffer(1024);
    }

    public ZDataParser(String s) {
        this.sb = new StringBuffer(s);
    }

    public void put(String key, int i) {
        this.put(key, String.valueOf(i));
    }

    public void put(String key, long d) {
        this.put(key, String.valueOf(d));
    }

    public void put(String key, double d) {
        this.put(key, String.valueOf(d));
    }

    public void put(String key, Date d) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss.SSS");
        if (d == null) {
            this.put(key, "null");
        } else {
            this.put(key, sdf.format(d));
        }
    }

    public void put(String key, String value) {
        key = key.toLowerCase();
        value = Escape.escape(value);
        int p1 = this.sb.indexOf("<" + key + ">");
        int p2 = this.sb.indexOf("</" + key + ">");
        if (p1 >= 0 && p2 >= 0) {
            this.sb.replace(p1, p2 + key.length() + 3, value);
        } else {
            this.sb.append("<" + key + ">" + value + "</" + key + ">");
        }
    }

    public int get(String key, int defaultValue) {
        String ret = this.get(key, String.valueOf(defaultValue));
        try {
            return new Integer(ret);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public long get(String key, long defaultValue) {
        String ret = this.get(key, String.valueOf(defaultValue));
        try {
            return Long.valueOf(ret);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public double get(String key, double defaultValue) {
        String ret = this.get(key, String.valueOf(defaultValue));
        try {
            return Double.valueOf(ret);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public Date get(String key, Date defaultValue) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss.SSS");
        String s = "";
        if (defaultValue != null) {
            s = sdf.format(defaultValue);
        }
        String ret = this.get(key, s);
        ParsePosition p = new ParsePosition(0);
        try {
            Date d = sdf.parse(s, p);
            if (d == null) {
                return defaultValue;
            }
            return d;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String get(String key, String defaultValue) {
        String lkey = key.toLowerCase();
        int p1 = this.sb.indexOf("<" + lkey + ">");
        int p2 = this.sb.indexOf("</" + lkey + ">");
        if (p1 < 0) {
            p1 = this.sb.indexOf("<" + key + ">");
        }
        if (p2 < 0) {
            p2 = this.sb.indexOf("</" + key + ">");
        }
        if (p1 >= 0 && p2 >= 0) {
            String value = this.sb.substring(p1 + key.length() + 2, p2);
            value = Escape.unescape(value);
            return value;
        }
        return defaultValue;
    }

    public String toString() {
        return this.sb.toString();
    }
}

