/*
 * Decompiled with CFR 0.152.
 */
package jun.db.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import jun.db.core.Logger;

public final class ParserDate {
    private static SimpleDateFormat[] dateFormats = null;

    static {
        String[] possibleDateFormats = new String[]{"EEE, dd MMM yyyy HH:mm:ss z", "EEE, dd MMM yyyy HH:mm zzzz", "EEE MMM dd HH:mm:ss zzz yyyy", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:sszzzz", "yyyy-MM-dd'T'HH:mm:ss z", "yyyy-MM-dd'T'HH:mm:ssz", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HHmmss.SSSz", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd", "yyyy.MM.dd HH:mm:ss.SSS", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HHmmss.SSSz", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd", "yyyy/MM/dd HHmmss.SSSz", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/M/d+HH:mm:ss", "yyyy/M/d HH:mm:ss", "yyyy/M/d", "yyyy-M-d", "yyyy/MM/dd", "MM/dd/yyyy", "MM-dd-yyyy"};
        dateFormats = new SimpleDateFormat[possibleDateFormats.length];
        TimeZone gmtTZ = TimeZone.getDefault();
        int i = 0;
        while (i < possibleDateFormats.length) {
            ParserDate.dateFormats[i] = new SimpleDateFormat(possibleDateFormats[i], Locale.getDefault());
            dateFormats[i].setTimeZone(gmtTZ);
            ++i;
        }
    }

    private ParserDate() {
    }

    public static Date getDate(String strdate) {
        Date result = null;
        if ((strdate = strdate.trim()).length() > 10) {
            String dateEnd;
            if ((strdate.substring(strdate.length() - 5).indexOf("+") == 0 || strdate.substring(strdate.length() - 5).indexOf("-") == 0) && strdate.substring(strdate.length() - 5).indexOf(":") == 2) {
                String sign = strdate.substring(strdate.length() - 5, strdate.length() - 4);
                strdate = String.valueOf(strdate.substring(0, strdate.length() - 5)) + sign + "0" + strdate.substring(strdate.length() - 4);
            }
            if (((dateEnd = strdate.substring(strdate.length() - 6)).indexOf("-") == 0 || dateEnd.indexOf("+") == 0) && dateEnd.indexOf(":") == 3) {
                if ("GMT".equals(strdate.substring(strdate.length() - 9, strdate.length() - 6))) {
                    Logger.error("General time zone with offset, no change ");
                } else {
                    String oldDate = strdate;
                    String newEnd = String.valueOf(dateEnd.substring(0, 3)) + dateEnd.substring(4);
                    strdate = String.valueOf(oldDate.substring(0, oldDate.length() - 6)) + newEnd;
                }
            }
        }
        int i = 0;
        while (i < dateFormats.length) {
            try {
                result = dateFormats[i].parse(strdate);
                break;
            }
            catch (ParseException eA) {
                ++i;
            }
        }
        return result;
    }

    public static void main(String[] args) {
        String s = "1/12/2007";
        Date d = ParserDate.getDate(s);
        System.out.println(d);
    }
}

