/*
 * Decompiled with CFR 0.152.
 */
package jun.db.impl;

import jun.db.impl.SqlParse;

public class SingleSqlParse
implements SqlParse {
    String m_UnionAll = "";
    String m_SQL = "";
    String m_Verb = "";
    String m_Tables = "";
    String m_Columns = "";
    String m_Values = "";
    String m_Where = "";
    String m_Order = "";
    String m_Group = "";
    String m_Having = "";
    boolean m_Risk = false;

    public String getColumns() {
        return this.m_Columns;
    }

    public String getGroup() {
        return this.m_Group;
    }

    public String getHaving() {
        return this.m_Having;
    }

    public boolean isRisk() {
        return this.m_Risk;
    }

    public String getOrder() {
        return this.m_Order;
    }

    public String getSQL() {
        return this.m_SQL;
    }

    public String getTables() {
        return this.m_Tables;
    }

    public String getValues() {
        return this.m_Values;
    }

    public String getVerb() {
        return this.m_Verb;
    }

    public String getWhere() {
        return this.m_Where;
    }

    public void setColumns(String string) {
        this.m_Columns = string;
    }

    public void setGroup(String string) {
        this.m_Group = string;
    }

    public void setHaving(String string) {
        this.m_Having = string;
    }

    public void setM_Risk(boolean b) {
        this.m_Risk = b;
    }

    public void setOrder(String string) {
        this.m_Order = string;
    }

    public void setSQL(String sql) throws Exception {
        sql = SingleSqlParse.normalize_from(sql);
        sql = SingleSqlParse.normalize_groupby(sql);
        sql = SingleSqlParse.normalize_orderby(sql);
        sql = SingleSqlParse.normalize_insert_into(sql);
        this.m_SQL = sql = SingleSqlParse.normalize_delete_from(sql);
    }

    public static String normalize_from(String sql) {
        sql = sql.replaceAll("\\s[*][Ff][Rr][Oo][Mm]\\s", " * FROM ");
        return sql;
    }

    public static String normalize_groupby(String sql) {
        sql = sql.replaceAll("\\s[Gg][Rr][Oo][Uu][Pp](\\s)+[Bb][Yy](\\s)+", " GROUP BY ");
        return sql;
    }

    public static String normalize_orderby(String sql) {
        sql = sql.replaceAll("\\s[Oo][Rr][Dd][Ee][Rr](\\s)+[Bb][Yy](\\s)+", " ORDER BY ");
        return sql;
    }

    public static String normalize_insert_into(String sql) {
        sql = " " + sql;
        sql = sql.replaceAll("(\\s)+[Ii][Nn][Ss][Ee][Rr][Tt](\\s)+[Ii][Nn][Tt][Oo](\\s)+", "INSERT INTO ");
        return sql.trim();
    }

    public static String normalize_delete_from(String sql) {
        sql = " " + sql;
        sql = sql.replaceAll("(\\s)+[Dd][Ee][Ll][Ee][Tt][Ee](\\s)+[Ff][Rr][Oo][Mm](\\s)+", "DELETE FROM ");
        return sql.trim();
    }

    public void Parse() throws Exception {
        int Pos;
        String[] Keyword = new String[7];
        String[] Clause = new String[7];
        int i = 0;
        while (i < 7) {
            Keyword[i] = "";
            Clause[i] = "";
            ++i;
        }
        String SQL = this.m_SQL;
        SQL = SQL.replaceAll("\r", " ").replaceAll("\n", " ").replaceAll("\t", " ");
        String SQLUpper = (SQL = SQL.trim()).toUpperCase();
        if (SQLUpper.subSequence(0, 4).equals("ALL ")) {
            this.m_UnionAll = " ALL ";
            SQLUpper = SQLUpper.substring(4).trim();
            SQL = SQL.substring(4).trim();
        }
        if (SQLUpper.substring(0, 7).equals("SELECT ")) {
            Keyword[0] = "SELECT ";
            Keyword[1] = " FROM ";
            Keyword[2] = " WHERE ";
            Keyword[3] = " GROUP BY ";
            Keyword[4] = " HAVING ";
            Keyword[5] = " ORDER BY ";
        } else if (SQLUpper.substring(0, 7).equals("UPDATE ")) {
            Keyword[0] = "UPDATE ";
            Keyword[1] = " SET ";
            Keyword[2] = " WHERE ";
            Keyword[5] = " ORDER BY ";
        } else if (SQLUpper.substring(0, 12).equals("INSERT INTO ")) {
            Keyword[0] = "INSERT INTO ";
            Keyword[6] = " VALUES ";
        } else if (SQLUpper.substring(0, 7).equals("INSERT ")) {
            Keyword[0] = "INSERT ";
            Keyword[6] = " VALUES ";
        } else if (SQLUpper.substring(0, 12).equals("DELETE FROM ")) {
            Keyword[0] = "DELETE FROM ";
            Keyword[2] = " WHERE ";
        } else if (SQLUpper.substring(0, 7).equals("DELETE ")) {
            Keyword[0] = "DELETE ";
            Keyword[2] = " WHERE ";
        }
        i = 6;
        while (i >= 0) {
            if (!Keyword[i].equals("")) {
                Pos = SQLUpper.indexOf(Keyword[i]);
                if (Keyword[i].equals(" WHERE ") || Keyword[i].equals(" GROUP BY ") || Keyword[i].equals(" HAVING ") || Keyword[i].equals(" ORDER BY ")) {
                    int keyLen = Keyword[i].length();
                    Pos = SQLUpper.indexOf(Keyword[i]);
                    while (Pos > 0) {
                        int n2;
                        String t = SQL.substring(Pos + keyLen);
                        t = t.replaceAll("''", "");
                        String reg = "'([^'])*'";
                        t = t.replaceAll(reg, "");
                        int p1 = t.length();
                        t = t.replaceAll("\\(", "");
                        int p2 = t.length();
                        int n1 = p1 - p2;
                        if (n1 == (n2 = p2 - (p1 = (t = t.replaceAll("\\)", "")).length()))) break;
                        Pos = SQLUpper.indexOf(Keyword[i], Pos + keyLen);
                    }
                }
                if (Pos >= 0) {
                    Clause[i] = SQL.substring(Pos + Keyword[i].length());
                    SQL = SQL.substring(0, Pos);
                } else {
                    Clause[i] = "";
                }
            }
            --i;
        }
        this.m_Verb = Keyword[0].trim();
        if (this.m_Verb.indexOf("SELECT") >= 0) {
            this.m_Columns = Clause[0].trim();
            this.m_Tables = Clause[1].trim();
        } else {
            this.m_Tables = Clause[0].trim();
            if (this.m_Verb.indexOf("INSERT") >= 0) {
                Pos = this.m_Tables.indexOf(" ");
                if (Pos >= 0) {
                    this.m_Columns = this.m_Tables.substring(Pos).trim();
                    this.m_Tables = this.m_Tables.substring(0, Pos - 1);
                } else {
                    this.m_Columns = Clause[1].trim();
                }
            }
        }
        this.m_Where = Clause[2].trim();
        this.m_Group = Clause[3].trim();
        this.m_Having = Clause[4].trim();
        this.m_Order = Clause[5].trim();
        this.m_Values = Clause[6].trim();
    }

    public void Assemble() throws Exception {
        this.m_SQL = "";
        this.m_SQL = String.valueOf(this.m_SQL) + this.m_UnionAll;
        if (this.m_Verb.trim().equals("")) {
            return;
        }
        this.m_SQL = String.valueOf(this.m_SQL) + this.m_Verb;
        if (this.m_Verb.equals("SELECT")) {
            if (this.m_Columns.trim().equals("")) {
                return;
            }
            this.m_SQL = String.valueOf(this.m_SQL) + " " + this.m_Columns;
            if (this.m_Tables.trim().length() > 0) {
                this.m_SQL = String.valueOf(this.m_SQL) + " FROM " + this.m_Tables;
            }
        } else {
            this.m_SQL = String.valueOf(this.m_SQL) + " " + this.m_Tables;
            if (this.m_Verb.equals("UPDATE")) {
                this.m_SQL = String.valueOf(this.m_SQL) + " SET " + this.m_Columns;
            } else if (!this.m_Columns.trim().equals("")) {
                this.m_SQL = String.valueOf(this.m_SQL) + " " + this.m_Columns;
            }
        }
        if (!this.m_Values.trim().equals("")) {
            this.m_SQL = String.valueOf(this.m_SQL) + " VALUES " + this.m_Values;
        }
        if (!this.m_Where.trim().equals("")) {
            this.m_SQL = String.valueOf(this.m_SQL) + " WHERE " + this.m_Where;
        }
        if (!this.m_Group.trim().equals("")) {
            this.m_SQL = String.valueOf(this.m_SQL) + " GROUP BY " + this.m_Group;
        }
        if (!this.m_Having.trim().equals("")) {
            this.m_SQL = String.valueOf(this.m_SQL) + " HAVING " + this.m_Having;
        }
        if (!this.m_Order.trim().equals("")) {
            this.m_SQL = String.valueOf(this.m_SQL) + " ORDER BY " + this.m_Order;
        }
    }

    public void setTables(String string) {
        this.m_Tables = string;
    }

    public void setValues(String string) {
        this.m_Values = string;
    }

    public void setVerb(String string) {
        this.m_Verb = string;
    }

    public void setWhere(String string) {
        this.m_Where = string;
    }

    private void log(String s) {
        System.out.println(s);
    }

    public void TestSQL1() {
        String sql = "select *FrOm a1";
        sql = sql.replaceAll("\\s[*][Ff][Rr][Oo][Mm]\\s", " * FROM ");
        this.log(sql);
    }

    public void TestSQL_normalize_groupby() {
        String sql = "select *FrOm a1  Group       By   a  ";
        sql = SingleSqlParse.normalize_groupby(sql);
        this.log(sql);
    }

    public void TestSQL_normalize_orderby() {
        String sql = "select *FrOm a1  OrDer       By   a  ";
        sql = SingleSqlParse.normalize_orderby(sql);
        this.log(sql);
    }

    public void TestSQL_normalize_InsertInto() {
        String sql = " insert   Into  t1    ";
        sql = SingleSqlParse.normalize_insert_into(sql);
        this.log(sql);
    }

    public void TestSQL_normalize_deleteFrom() {
        String sql = "  Delete    from    t1    ";
        sql = SingleSqlParse.normalize_delete_from(sql);
        this.log(sql);
    }
}

