/*
 * Decompiled with CFR 0.152.
 */
package jun.db.impl;

import java.util.ArrayList;
import jun.db.core.DataStoreEventManager;
import jun.db.core.DataStoreListener;
import jun.db.core.Logger;

class DataStoreEventManager_
implements DataStoreEventManager {
    private ArrayList m_ListenerList = new ArrayList();

    DataStoreEventManager_() {
    }

    public void addDataStoreEventListener(DataStoreListener listener) {
        this.addDataStoreEventListener(listener, 1, "");
    }

    public void addDataStoreEventListener(DataStoreListener listener, int order, String name) {
        listener.setOrder(order);
        listener.setName(name);
        int n = this.m_ListenerList.size();
        int i = 0;
        while (i < n) {
            DataStoreListener pDSL = (DataStoreListener)this.m_ListenerList.get(i);
            if (listener.getOrder() < pDSL.getOrder()) {
                this.m_ListenerList.add(i, listener);
                return;
            }
            ++i;
        }
        this.m_ListenerList.add(listener);
    }

    public boolean removeDataStoreEventListener(String name) {
        int n = this.m_ListenerList.size();
        int rc = 0;
        int i = n - 1;
        while (i >= 0) {
            DataStoreListener pDSL = (DataStoreListener)this.m_ListenerList.get(i);
            if (pDSL.getName().equals(name)) {
                this.m_ListenerList.remove(i);
                ++rc;
            }
            --i;
        }
        return rc > 0;
    }

    public DataStoreListener findListener(String name) {
        int n = this.m_ListenerList.size();
        boolean rc = false;
        int i = n - 1;
        while (i >= 0) {
            DataStoreListener pDSL = (DataStoreListener)this.m_ListenerList.get(i);
            if (pDSL.getName().equals(name)) {
                return pDSL;
            }
            --i;
        }
        return null;
    }

    public void fireItemChanged(int row, String col, Object oldValue, Object newValue) {
        int n = this.m_ListenerList.size();
        int i = 0;
        while (i < n) {
            DataStoreListener pDSL = (DataStoreListener)this.m_ListenerList.get(i);
            pDSL.itemChanged(row, col, oldValue, newValue);
            ++i;
        }
    }

    public boolean fireItemChangeAccept(int row, String col, Object value) {
        int n = this.m_ListenerList.size();
        boolean accept = true;
        int i = 0;
        while (i < n) {
            DataStoreListener pDSL = (DataStoreListener)this.m_ListenerList.get(i);
            accept = pDSL.itemChangeAccept(row, col, value);
            if (!accept) {
                return false;
            }
            ++i;
        }
        return accept;
    }

    public void fireBeforeRetrieve() {
        int n = this.m_ListenerList.size();
        int i = 0;
        while (i < n) {
            DataStoreListener pDSL = (DataStoreListener)this.m_ListenerList.get(i);
            pDSL.beforeRetrieve();
            ++i;
        }
    }

    public void fireRetrieveEnd(int rowCount, boolean withLastSelect) {
        int n = this.m_ListenerList.size();
        int i = 0;
        while (i < n) {
            DataStoreListener pDSL = (DataStoreListener)this.m_ListenerList.get(i);
            pDSL.retrieveEnd(rowCount, withLastSelect);
            ++i;
        }
    }

    public void fireRetrieveOnceMoreEnd(int retrieveTimes, int rowCount) {
        int n = this.m_ListenerList.size();
        int i = 0;
        while (i < n) {
            DataStoreListener pDSL = (DataStoreListener)this.m_ListenerList.get(i);
            pDSL.retrieveOnceMoreEnd(retrieveTimes, rowCount);
            ++i;
        }
    }

    public void fireComputerChanged(int row, String computer) {
        int n = this.m_ListenerList.size();
        int i = 0;
        while (i < n) {
            DataStoreListener pDSL = (DataStoreListener)this.m_ListenerList.get(i);
            pDSL.computerChanged(row, computer);
            ++i;
        }
    }

    public void fireAfterDeleteRow(int row) {
        int n = this.m_ListenerList.size();
        int i = 0;
        while (i < n) {
            DataStoreListener pDSL = (DataStoreListener)this.m_ListenerList.get(i);
            pDSL.afterDeleteRow(row);
            ++i;
        }
    }

    public void fireBeforeDeleteRow(int row) {
        int n = this.m_ListenerList.size();
        int i = 0;
        while (i < n) {
            DataStoreListener pDSL = (DataStoreListener)this.m_ListenerList.get(i);
            pDSL.beforeDeleteRow(row);
            ++i;
        }
    }

    public void fireAfterInsertRow(int row) {
        int n = this.m_ListenerList.size();
        int i = 0;
        while (i < n) {
            DataStoreListener pDSL = (DataStoreListener)this.m_ListenerList.get(i);
            pDSL.afterInsertRow(row);
            ++i;
        }
    }

    public boolean fireDeleteRowPermit(int row) {
        int n = this.m_ListenerList.size();
        boolean permit = true;
        int i = 0;
        while (i < n) {
            DataStoreListener pDSL = (DataStoreListener)this.m_ListenerList.get(i);
            permit = pDSL.deleteRowPermit(row);
            if (!permit) {
                return false;
            }
            ++i;
        }
        return permit;
    }

    public boolean fireInsertRowPermit(int row) {
        int n = this.m_ListenerList.size();
        boolean permit = true;
        int i = 0;
        while (i < n) {
            DataStoreListener pDSL = (DataStoreListener)this.m_ListenerList.get(i);
            permit = pDSL.insertRowPermit(row);
            if (!permit) {
                return false;
            }
            ++i;
        }
        return permit;
    }

    public void fireAfterSort() {
        int n = this.m_ListenerList.size();
        int i = 0;
        while (i < n) {
            DataStoreListener pDSL = (DataStoreListener)this.m_ListenerList.get(i);
            pDSL.afterSort();
            ++i;
        }
    }

    public void fireAfterReset() {
        int n = this.m_ListenerList.size();
        int i = 0;
        while (i < n) {
            DataStoreListener pDSL = (DataStoreListener)this.m_ListenerList.get(i);
            pDSL.afterReset();
            ++i;
        }
    }

    public void fireAfterFilter(int primaryBufferRowCount, int filterBufferRowCount) {
        int n = this.m_ListenerList.size();
        int i = 0;
        while (i < n) {
            DataStoreListener pDSL = (DataStoreListener)this.m_ListenerList.get(i);
            pDSL.afterFilter(primaryBufferRowCount, filterBufferRowCount);
            ++i;
        }
    }

    public boolean fireValidate(int row) {
        int n = this.m_ListenerList.size();
        boolean ok = true;
        int i = 0;
        while (i < n) {
            DataStoreListener pDSL = (DataStoreListener)this.m_ListenerList.get(i);
            ok = pDSL.validate(row);
            if (!ok) {
                return false;
            }
            ++i;
        }
        return ok;
    }

    public void fireSqlPreview(String sql) {
        int n = this.m_ListenerList.size();
        int i = 0;
        while (i < n) {
            DataStoreListener pDSL = (DataStoreListener)this.m_ListenerList.get(i);
            pDSL.sqlPreview(sql);
            ++i;
        }
    }

    public String fireParseInnerParameter(String parameterName) {
        String ret = null;
        int n = this.m_ListenerList.size();
        int i = 0;
        while (i < n) {
            DataStoreListener pDSL = (DataStoreListener)this.m_ListenerList.get(i);
            Logger.info(" before parseInnerParameter ");
            String t = pDSL.parseInnerParameter(parameterName);
            Logger.info(" after parseInnerParameter ");
            if (t != null) {
                return t;
            }
            ++i;
        }
        return ret;
    }

    public void fireAutoCheckError(String table, int row, String col, int checkType, String errorInfo) {
        int n = this.m_ListenerList.size();
        int i = 0;
        while (i < n) {
            DataStoreListener pDSL = (DataStoreListener)this.m_ListenerList.get(i);
            pDSL.autoCheckError(table, row, col, checkType, errorInfo);
            ++i;
        }
    }

    public void fireBeforeGetValue(int row, String col) {
        int n = this.m_ListenerList.size();
        int i = 0;
        while (i < n) {
            DataStoreListener pDSL = (DataStoreListener)this.m_ListenerList.get(i);
            pDSL.beforeGetValue(row, col);
            ++i;
        }
    }

    public void fireOnError(int code, String description) {
        int n = this.m_ListenerList.size();
        int i = 0;
        while (i < n) {
            DataStoreListener pDSL = (DataStoreListener)this.m_ListenerList.get(i);
            pDSL.onError(code, description);
            ++i;
        }
    }

    public void fireItemBalloonTipChanged(int row, String col, String type, String info) {
        int n = this.m_ListenerList.size();
        int i = 0;
        while (i < n) {
            DataStoreListener pDSL = (DataStoreListener)this.m_ListenerList.get(i);
            pDSL.itemBalloonTipChanged(row, col, type, info);
            ++i;
        }
    }
}

