/*
 * Decompiled with CFR 0.152.
 */
package jun.db.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import jun.db.core.DataStore;
import jun.db.core.Logger;
import jun.db.impl.DataAdapterDefault;
import jun.db.impl.DataAdapterJTDS;
import oracle.sql.CLOB;
import org.apache.regexp.RE;

class DataAdapterOracle
extends DataAdapterDefault {
    public DataAdapterOracle(DataStore ds) {
        super(ds);
        this.m_DateSeparator = ".";
        this.m_DBProvider = "Oracle";
        HashMap map = this.getDataTypeMap();
        map.put("nvarchar", "varchar2");
        map.put("varchar", "varchar2");
        map.put("numeric", "number");
        map.put("decimal", "number");
        map.put("datetime", "date");
        map.put("text", "clob");
        map.put("tinyint", "int");
        map.put("longchar", "clob");
    }

    public Object getDataFromResultSet(ResultSet rs, int col, int dt) throws Exception {
        if (dt == 2005) {
            String s = DataAdapterJTDS.getClobString(rs, col);
            return s;
        }
        if (dt == -4) {
            String s = DataAdapterOracle.getLongRowString(rs, col);
            return s;
        }
        return super.getDataFromResultSet(rs, col, dt);
    }

    public static String getLongRowString(ResultSet rs, int col) {
        InputStream reader;
        block4: {
            reader = rs.getBinaryStream(col);
            if (reader != null) break block4;
            return null;
        }
        try {
            int actual;
            byte[] bs = new byte[4096];
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
            while ((actual = reader.read(bs)) >= 0) {
                bos.write(bs, 0, actual);
            }
            String ret = new String(bos.toByteArray());
            reader.close();
            bos.close();
            return ret;
        }
        catch (Exception e) {
            return "Error:" + e.getMessage();
        }
    }

    public void clobModify(Connection conn, String table, String col, String where, String value, boolean printSQL) throws Exception {
        boolean defaultCommit = conn.getAutoCommit();
        conn.setAutoCommit(false);
        Statement stmt = null;
        try {
            try {
                stmt = conn.createStatement();
                String sql = " SELECT " + col + " FROM " + table + "  WHERE " + where + "  FOR UPDATE";
                if (printSQL) {
                    Logger.info(sql);
                }
                ResultSet rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    int c;
                    CLOB clob = (CLOB)rs.getClob(col);
                    BufferedWriter out = new BufferedWriter(clob.getCharacterOutputStream());
                    BufferedReader in = new BufferedReader(new StringReader(value));
                    while ((c = in.read()) != -1) {
                        out.write(c);
                    }
                    in.close();
                    out.close();
                }
                conn.commit();
            }
            catch (Exception ex) {
                conn.rollback();
                throw ex;
            }
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
        conn.setAutoCommit(defaultCommit);
    }

    public String getFormatedTextValue(Object v, int dataType, int decimalCount, boolean withAffix) {
        String bstr = "";
        SimpleDateFormat sdf = null;
        if (v == null) {
            return "NULL";
        }
        switch (dataType) {
            case 91: 
            case 93: {
                sdf = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
                bstr = "to_date('" + sdf.format(v) + "','YYYY.MM.DD HH24:MI:SS')";
                break;
            }
            case 92: {
                Logger.error(String.valueOf(this.getClass().getName()) + "\u5c1a\u672a\u652f\u6301 TIME");
                break;
            }
            default: {
                bstr = super.getFormatedTextValue(v, dataType, decimalCount, withAffix);
            }
        }
        return bstr;
    }

    public void InitNegativeSequence(Connection con, String name, String value) {
        Statement st = null;
        try {
            st = con.createStatement();
            DataAdapterOracle.SafeExecuteSQL(st, "create table datastore_sequence_negative (name varchar(255) not null,value\tint\tnot null,\tprimary key (name))");
            DataAdapterOracle.SafeExecuteSQL(st, "insert into datastore_sequence_negative   values ( '" + name + "' , 0)");
            DataAdapterOracle.SafeExecuteSQL(st, "update datastore_sequence_negative   set value= nvl ((" + value + ") ,0)   where name= '" + name + "'    and   value> nvl ((" + value + ") ,0) ");
            String sql = "Create   Procedure  DataStoreGetNextNSequence( p_name  in  varchar2  , p_ret  out number )\n AS  PRAGMA AUTONOMOUS_TRANSACTION;\n BEGIN  \n       update datastore_sequence_negative  set value = value - 1 where name= p_name   ;\n      if   sql%rowcount   >  0   then  \n           dbms_output.put_line('update ok');\n      else\n           dbms_output.put_line('not exists');\n           insert into datastore_sequence_negative values( p_name , -1);\n      end if;\n       commit;\n       select  value into p_ret  from datastore_sequence_negative   where name=p_name ;\n END ; \n";
            DataAdapterOracle.SafeExecuteSQL(st, sql);
            st.close();
            st = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (st != null) {
                st.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void InitSequence(Connection con, String name, String value) {
        Statement st = null;
        try {
            st = con.createStatement();
            DataAdapterOracle.SafeExecuteSQL(st, "create table datastore_sequence (name varchar2(255) not null,value\tint\tnot null,\tprimary key (name))");
            DataAdapterOracle.SafeExecuteSQL(st, "insert into datastore_sequence   values ( '" + name + "' , 0)");
            DataAdapterOracle.SafeExecuteSQL(st, "update datastore_sequence   set value= nvl ((" + value + ") ,0)   where name= '" + name + "'    and   value< nvl ((" + value + ") ,0) ");
            String sql = "Create   Procedure  DataStoreGetNextSequence( p_name  in  varchar2  , p_ret  out number )\nAS  PRAGMA AUTONOMOUS_TRANSACTION;\nBEGIN  \n       update datastore_sequence  set value = value + 1 where name= p_name   ;\n      if   sql%rowcount   >  0   then  \n           dbms_output.put_line('at   least   one   record   updated.');\n      else\n           dbms_output.put_line('not exists');  \n           insert into datastore_sequence values( p_name , 0);\n      end if;\n      commit;\n      select  value into p_ret  from datastore_sequence   where name=p_name ;\n    \nEND ;";
            DataAdapterOracle.SafeExecuteSQL(st, sql);
            st.close();
            st = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (st != null) {
                st.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int NextNegativeSequence(Connection con, String name) {
        CallableStatement proc = null;
        try {
            String sql = "{call DataStoreGetNextNSequence(?,?)} ";
            proc = con.prepareCall(sql);
            proc.setString(1, name);
            proc.registerOutParameter(2, 4);
            proc.execute();
            int ret = proc.getInt(2);
            proc.close();
            proc = null;
            if (ret == 0) {
                this.InitNegativeSequence(con, name, "");
                int n = this.NextNegativeSequence(con, name);
                return n;
            }
            int n = ret;
            return n;
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            return -1;
        }
        finally {
            try {
                if (proc != null) {
                    proc.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public int NextSequence(Connection con, String name) {
        CallableStatement proc = null;
        try {
            String sql = "{call DataStoreGetNextSequence(?,?)} ";
            proc = con.prepareCall(sql);
            proc.setString(1, name);
            proc.registerOutParameter(2, 4);
            proc.execute();
            int ret = proc.getInt(2);
            proc.close();
            proc = null;
            if (ret == 0) {
                this.InitSequence(con, name, "");
                int n = this.NextSequence(con, name);
                return n;
            }
            int n = ret;
            return n;
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            return -1;
        }
        finally {
            try {
                if (proc != null) {
                    proc.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public String toLocalSyntax(String sql) {
        return DataAdapterOracle.$toLocalSyntax(sql);
    }

    public static String $toLocalSyntax(String sql) {
        String rq;
        RE re = new RE("\\s*([a-zA-Z0-9_\\)]+)\\s*([><=!]{1,2})\\s*\\(*\\s*('[0-9]{4}\\.[0-9]{2}\\.[0-9]{2}')\\s*\\)*\\s*");
        while (re.match(sql)) {
            rq = sql.substring(re.getParenStart(3), re.getParenEnd(3));
            rq = " to_date(" + rq + ", 'yyyy.mm.dd')";
            sql = String.valueOf(sql.substring(0, re.getParenStart(3))) + rq + sql.substring(re.getParenEnd(3));
        }
        re = new RE("\\s*([a-zA-Z0-9_\\)]+)\\s*([><=!]{1,2})\\s*\\(*\\s*('[0-9]{4}\\.[0-9]{2}\\.[0-9]{2}\\s[0-9]{2}:[0-9]{2}:[0-9]{2}')\\s*\\)*\\s*");
        while (re.match(sql)) {
            rq = sql.substring(re.getParenStart(3), re.getParenEnd(3));
            rq = " to_date(" + rq + ", 'YYYY.MM.DD HH24:MI:SS')";
            sql = String.valueOf(sql.substring(0, re.getParenStart(3))) + rq + sql.substring(re.getParenEnd(3));
        }
        re = new RE("\\s*[Dd][Rr][Oo][Pp]\\s*[Ii][Nn][Dd][Ee][Xx]\\s*([^\\.\\s]+\\.)[^\\.\\s]+");
        while (re.match(sql)) {
            sql = String.valueOf(sql.substring(0, re.getParenStart(1))) + sql.substring(re.getParenEnd(1));
        }
        return sql;
    }

    public static void main(String[] args) {
        String sql = "drop index   news_user.di_name";
        sql = DataAdapterOracle.$toLocalSyntax(sql);
        sql = " select * from aa where rq> '2012.01.01' ";
        sql = DataAdapterOracle.$toLocalSyntax(sql);
        System.out.println(sql);
    }
}

