/*
 * Decompiled with CFR 0.152.
 */
package jun.db.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import jun.db.core.DataStore;
import jun.db.core.Logger;
import jun.db.impl.DataAdapterDefault;
import org.apache.regexp.RE;

class DataAdapterMySQL
extends DataAdapterDefault {
    public DataAdapterMySQL(DataStore ds) {
        super(ds);
        this.m_DateSeparator = ".";
        this.m_DBProvider = "JTDS";
        HashMap map = this.getDataTypeMap();
        map.put("timestamp", "datetime");
        map.put("smalldatetime", "datetime");
        map.put("number", "decimal");
        map.put("money", "float");
        map.put("smallmoney", "float");
        map.put("text", "longtext");
        map.put("date", "datetime");
        map.put("number", "numeric");
        map.put("varchar2", "varchar");
        map.put("clob", "text");
    }

    public Object getDataFromResultSet(ResultSet rs, int col, int dt) throws Exception {
        if (dt == 2005) {
            String s = DataAdapterMySQL.getClobString(rs, col);
            return s;
        }
        return super.getDataFromResultSet(rs, col, dt);
    }

    public String getFormatedTextValue(Object v, int dataType, int decimalCount, boolean withAffix) {
        String ret = super.getFormatedTextValue(v, dataType, decimalCount, withAffix);
        if (v == null) {
            return ret;
        }
        String bstr = "";
        switch (dataType) {
            case -4: 
            case -3: 
            case -1: 
            case 1: 
            case 12: 
            case 2004: 
            case 2005: {
                String sss = "\\\\";
                String ddd = "\\\\\\\\";
                ret = ret.replaceAll(sss, ddd);
                break;
            }
            case 91: 
            case 93: {
                if (ret.equals("NULL")) {
                    return ret;
                }
                if (ret.compareTo("'1753") >= 0) break;
                return "NULL";
            }
        }
        return ret;
    }

    public void InitNegativeSequence(Connection con, String name, String value) {
        Statement st = null;
        try {
            try {
                st = con.createStatement();
                DataAdapterMySQL.SafeExecuteSQL(st, "create table datastore_sequence_negative (name varchar(255) not null,value\tint\tnot null,\tprimary key (name))");
                DataAdapterMySQL.SafeExecuteSQL(st, "insert into datastore_sequence_negative   values ( '" + name + "' , 0)");
                DataAdapterMySQL.SafeExecuteSQL(st, "update datastore_sequence_negative   set value= ifnull ((" + value + ") ,0)   where name= '" + name + "'    and   value> ifnull ((" + value + ") ,0) ");
                DataAdapterMySQL.SafeExecuteSQL(st, " CREATE  PROCEDURE DataStoreGetNextNSequence( in p_name  varchar(200),  out ret  int ) \n\tBEGIN \t  \n\t        DECLARE t_error INT DEFAULT 0; \n\t\t\tDECLARE CONTINUE HANDLER FOR 1062 SELECT 'Duplicate key'; \n\t\t\tSTART TRANSACTION;  \n\t        insert into datastore_sequence_negative (NAME,VALUE) values( p_name ,0) ; \n\t\t\tupdate datastore_sequence_negative  set value = value - 1 where name= p_name ; \n\t\t    set ret = ( select value from datastore_sequence_negative  where name = p_name );  \n\t\t   COMMIT;  \n\tEND \n");
            }
            catch (Exception exception) {
                try {
                    if (st != null) {
                        st.close();
                    }
                }
                catch (Exception exception2) {}
            }
        }
        finally {
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void InitSequence(Connection con, String name, String value) {
        Statement st = null;
        try {
            try {
                st = con.createStatement();
                DataAdapterMySQL.SafeExecuteSQL(st, "create table datastore_sequence (name varchar(255) not null,value\tint\tnot null,\tprimary key (name))");
                DataAdapterMySQL.SafeExecuteSQL(st, "insert into datastore_sequence   values ( '" + name + "' , 0)");
                DataAdapterMySQL.SafeExecuteSQL(st, "update datastore_sequence   set value= ifnull ((" + value + ") ,0)   where name= '" + name + "'    and   value< ifnull ((" + value + ") ,0) ");
                DataAdapterMySQL.SafeExecuteSQL(st, " CREATE  PROCEDURE DataStoreGetNextSequence( in p_name  varchar(200),  out ret  int ) \n\tBEGIN \t  \n\t        DECLARE t_error INT DEFAULT 0; \n\t\t\tDECLARE CONTINUE HANDLER FOR 1062 SELECT 'Duplicate key'; \n\t\t\tSTART TRANSACTION;  \n\t        insert into datastore_sequence (NAME,VALUE) values( p_name ,0) ; \n\t\t\tupdate datastore_sequence  set value = value + 1 where name= p_name ; \n\t\t    set ret = ( select value from datastore_sequence  where name = p_name );  \n\t\t   COMMIT;  \n\tEND \n");
            }
            catch (Exception exception) {
                try {
                    if (st != null) {
                        st.close();
                    }
                }
                catch (Exception exception2) {}
            }
        }
        finally {
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void setFetchSize(Statement cmd) {
        try {
            cmd.setFetchSize(Integer.MIN_VALUE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void moveToAbsolutePosition(ResultSet rs, int absoluteRow) {
    }

    public String toLocalSyntax(String sql) {
        if (sql.toLowerCase().trim().startsWith("drop")) {
            String REGEX_LETTER = "[A-Z_a-z0-9\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u00ff\u0100-\u1fff\u3040-\u318f\u3300-\u337f\u3400-\u3d2d\u4e00-\u9fff\uf900-\ufaff]+";
            String REGEX_DROP = "[Dd][Rr][Oo][Pp]\\s*[Ii][Nn][Dd][Ee][Xx]";
            RE re = new RE("\\s*" + REGEX_DROP + "\\s*(" + REGEX_LETTER + ")[.](" + REGEX_LETTER + ")");
            if (re.match(sql)) {
                String table = sql.substring(re.getParenStart(1), re.getParenEnd(1));
                String index = sql.substring(re.getParenStart(2), re.getParenEnd(2));
                sql = " drop index " + index + " on " + table;
            }
        }
        sql = sql.replaceAll("\\\\", "\\\\\\\\");
        return super.toLocalSyntax(sql);
    }

    public static void main(String[] arg) {
        String sql = "drop index  oa_group_user.di_oa_group_user_1";
        String REGEX_LETTER = "[A-Z_a-z0-9\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u00ff\u0100-\u1fff\u3040-\u318f\u3300-\u337f\u3400-\u3d2d\u4e00-\u9fff\uf900-\ufaff]+";
        String REGEX_DROP = "[Dd][Rr][Oo][Pp]\\s*[Ii][Nn][Dd][Ee][Xx]";
        RE re = new RE("\\s*" + REGEX_DROP + "\\s*(" + REGEX_LETTER + ")[.](" + REGEX_LETTER + ")");
        if (re.match(sql)) {
            int i = 0;
            while (i < re.getParenCount()) {
                Logger.error(String.valueOf(re.getParenStart(i)) + "   " + re.getParenEnd(i) + "  " + sql.substring(re.getParenStart(i), re.getParenEnd(i)));
                ++i;
            }
            String table = sql.substring(re.getParenStart(1), re.getParenEnd(1));
            String index = sql.substring(re.getParenStart(2), re.getParenEnd(2));
            sql = " drop index " + index + " on " + table;
        }
        System.out.println(sql);
    }
}

