/*
 * Decompiled with CFR 0.152.
 */
package jun.db.core;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import jun.db.util.ParserDate;

public abstract class ObjectTool {
    public static final String java_lang_Boolean = "java.lang.Boolean";
    public static final String java_lang_Byte = "java.lang.Byte";
    public static final String java_lang_Character = "java.lang.Character";
    public static final String java_lang_Double = "java.lang.Double";
    public static final String java_lang_Float = "java.lang.Float";
    public static final String java_lang_Integer = "java.lang.Integer";
    public static final String java_lang_Long = "java.lang.Long";
    public static final String java_lang_Short = "java.lang.Short";
    public static final String java_lang_String = "java.lang.String";
    public static final String java_util_Date = "java.util.Date";
    public static final String java_sql_Date = "java.sql.Date";
    public static final String java_sql_Time = "java.sql.Time";
    public static final String java_sql_Timestamp = "java.sql.Timestamp";
    public static final String java_math_BigDecimal = "java.math.BigDecimal";
    public static final String java_math_BigInteger = "java.math.BigInteger";
    public static final String java_awt_Color = "java.awt.Color";

    public static Object ObjectClone(Object obj) throws Exception {
        if (obj == null) {
            return null;
        }
        Object ret = null;
        String type = obj.getClass().getName();
        if (type.equals(java_lang_Boolean)) {
            return new Boolean((Boolean)obj);
        }
        if (type.equals(java_lang_Byte)) {
            return new Byte((Byte)obj);
        }
        if (type.equals(java_lang_Character)) {
            return new Character(((Character)obj).charValue());
        }
        if (type.equals(java_lang_Double)) {
            return new Double((Double)obj);
        }
        if (type.equals(java_lang_Float)) {
            return new Float(((Float)obj).floatValue());
        }
        if (type.equals(java_lang_Integer)) {
            return new Integer((Integer)obj);
        }
        if (type.equals(java_lang_Long)) {
            return new Long((Long)obj);
        }
        if (type.equals(java_lang_Short)) {
            return new Short((Short)obj);
        }
        if (type.equals(java_lang_String)) {
            return new String((String)obj);
        }
        if (type.equals(java_util_Date)) {
            return new java.util.Date(((java.util.Date)obj).getTime());
        }
        if (type.equals(java_sql_Date)) {
            return new Date(((java.util.Date)obj).getTime());
        }
        if (type.equals(java_sql_Time)) {
            return new Time(((Time)obj).getTime());
        }
        if (type.equals(java_sql_Timestamp)) {
            return new Timestamp(((Timestamp)obj).getTime());
        }
        if (type.equals(java_math_BigDecimal)) {
            return (BigDecimal)obj;
        }
        if (type.equals(java_math_BigInteger)) {
            return (BigInteger)obj;
        }
        if (type.equals(java_awt_Color)) {
            return new Color(((Color)obj).getRGB());
        }
        try {
            ByteArrayOutputStream bao = new ByteArrayOutputStream(1024);
            ObjectOutputStream oo = new ObjectOutputStream(bao);
            oo.writeObject(obj);
            oo.flush();
            oo.close();
            ByteArrayInputStream bai = new ByteArrayInputStream(bao.toByteArray());
            ObjectInputStream oi = new ObjectInputStream(bai);
            return oi.readObject();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Object Add(Object v1, Object v2) throws Exception {
        if (v1 == null) {
            return v2;
        }
        if (v2 == null) {
            return v1;
        }
        String type = v1.getClass().getName();
        if (type.equals(java_lang_Boolean)) {
            return new Boolean((Boolean)v1 != false || (Boolean)v2 != false);
        }
        if (type.equals(java_lang_Byte)) {
            return new Byte((byte)((Byte)v1 + (Byte)v2));
        }
        if (type.equals(java_lang_Character)) {
            return new Character((char)(((Character)v1).charValue() + ((Character)v2).charValue()));
        }
        if (type.equals(java_lang_Double)) {
            return new Double((Double)v1 + (Double)v2);
        }
        if (type.equals(java_lang_Float)) {
            return new Float(((Float)v1).floatValue() + ((Float)v2).floatValue());
        }
        if (type.equals(java_lang_Integer)) {
            return new Integer((Integer)v1 + (Integer)v2);
        }
        if (type.equals(java_lang_Long)) {
            return new Long((Long)v1 + (Long)v2);
        }
        if (type.equals(java_lang_Short)) {
            return new Short((short)((Short)v1 + (Short)v2));
        }
        if (type.equals(java_lang_String)) {
            return new String(String.valueOf((String)v1) + (String)v2);
        }
        if (type.equals(java_sql_Date)) {
            return v1;
        }
        if (type.equals(java_sql_Time)) {
            return v1;
        }
        if (type.equals(java_sql_Timestamp)) {
            return v1;
        }
        if (type.equals(java_math_BigDecimal)) {
            return ((BigDecimal)v1).add((BigDecimal)v2);
        }
        if (type.equals(java_math_BigInteger)) {
            return ((BigInteger)v1).add((BigInteger)v2);
        }
        throw new Exception("DataBuffer.Add\u6ca1\u6709\u5904\u7406\u7c7b\u578b" + type);
    }

    public static Double Div(Object v1, int v2) throws Exception {
        if (v1 == null) {
            return null;
        }
        if (v2 == 0) {
            return null;
        }
        String type = v1.getClass().getName();
        if (type.equals(java_lang_Boolean)) {
            return null;
        }
        if (type.equals(java_lang_Byte)) {
            return new Double((Byte)v1 / v2);
        }
        if (type.equals(java_lang_Character)) {
            return null;
        }
        if (type.equals(java_lang_Double)) {
            return new Double((Double)v1 / (double)v2);
        }
        if (type.equals(java_lang_Float)) {
            return new Double(((Float)v1).floatValue() / (float)v2);
        }
        if (type.equals(java_lang_Integer)) {
            return new Double((Integer)v1 / v2);
        }
        if (type.equals(java_lang_Long)) {
            return new Double((Long)v1 / (long)v2);
        }
        if (type.equals(java_lang_Short)) {
            return new Double((Short)v1 / v2);
        }
        if (type.equals(java_lang_String)) {
            return null;
        }
        if (type.equals(java_sql_Date)) {
            return null;
        }
        if (type.equals(java_sql_Time)) {
            return null;
        }
        if (type.equals(java_sql_Timestamp)) {
            return null;
        }
        if (type.equals(java_math_BigDecimal)) {
            return new Double(((BigDecimal)v1).doubleValue() / (double)v2);
        }
        if (type.equals(java_math_BigInteger)) {
            return new Double(((BigInteger)v1).doubleValue() / (double)v2);
        }
        throw new Exception("DataBuffer.Add\u6ca1\u6709\u5904\u7406\u7c7b\u578b" + type);
    }

    public static java.util.Date String2Date(String value) {
        if (value == null) {
            return null;
        }
        String t = value.trim();
        String s = t.replaceAll("-", ".").replaceAll(":", ".").replaceAll("  ", ".").replaceAll(" ", ".").replaceAll("\u5e74", ".").replaceAll("\u6708", ".").replaceAll("\u65e5", "");
        if (s.length() == 10 && s.substring(2, 3).equals("/") && s.substring(5, 6).equals("/")) {
            s = String.valueOf(s.substring(6, 10)) + "." + s.substring(0, 2) + "." + s.substring(3, 5);
        }
        if (s.length() == 10) {
            s = String.valueOf(s) + ".00.00.00.000";
        }
        if (s.length() == 13) {
            s = String.valueOf(s) + ".00.00.000";
        }
        if (s.length() == 16) {
            s = String.valueOf(s) + ".00.000";
        }
        if (s.length() == 19) {
            s = String.valueOf(s) + ".000";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss.SSS");
        ParsePosition p = new ParsePosition(0);
        Timestamp ret = null;
        try {
            java.util.Date d = sdf.parse(s, p);
            if (d != null) {
                ret = new Timestamp(d.getTime());
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (ret != null) {
            return ret;
        }
        return ParserDate.getDate(t);
    }

    public static void main(String[] args) {
        String s = "2012-1-13";
        try {
            java.util.Date d = (java.util.Date)ObjectTool.ChangeType(s, java_util_Date, "");
            System.out.println(d);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Object ChangeType(Object value, String toType) throws Exception {
        return ObjectTool.ChangeType(value, toType, "");
    }

    public static Object ChangeType(Object value, String toType, String format) throws Exception {
        if (value == null) {
            return value;
        }
        if (value.getClass().getName().equals(toType)) {
            return ObjectTool.ObjectClone(value);
        }
        if (toType.equals(java_lang_Boolean)) {
            if (value instanceof Number) {
                if (((Number)value).longValue() == 0L) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            return new Boolean(value.toString());
        }
        if (toType.equals(java_lang_Integer)) {
            try {
                if (value instanceof Number) {
                    return new Integer(((Number)value).intValue());
                }
                if (value instanceof java.util.Date) {
                    java.util.Date td = (java.util.Date)value;
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(td);
                    return new Integer(cal.get(1) * 10000 + (cal.get(2) + 1) * 100 + cal.get(5));
                }
                String s = value.toString().trim();
                int p = s.indexOf(46);
                if (p >= 0) {
                    s = s.substring(0, p);
                }
                return new Integer(s);
            }
            catch (NumberFormatException e) {
                return new Integer(0);
            }
        }
        if (toType.equals(java_math_BigDecimal)) {
            if (value instanceof Number) {
                return new BigDecimal(((Number)value).doubleValue());
            }
            String s = value.toString().trim().replaceAll(",", "");
            return new BigDecimal(s);
        }
        if (toType.equals(java_lang_Float)) {
            if (value instanceof Number) {
                return new Float(((Number)value).floatValue());
            }
            String s = value.toString().trim().replaceAll(",", "");
            return new Float(s);
        }
        if (toType.equals(java_lang_Double)) {
            if (value instanceof Number) {
                return new Double(((Number)value).doubleValue());
            }
            String type = value.getClass().getName();
            if (type.equals(java_sql_Timestamp)) {
                return new Double(((Timestamp)value).getTime());
            }
            String s = value.toString().trim().replaceAll(",", "");
            return new Double(s);
        }
        if (toType.equals(java_lang_Long)) {
            String s = value.toString().trim().replaceAll(",", "");
            return new Long(s);
        }
        if (toType.equals(java_lang_String)) {
            String type = value.getClass().getName();
            if (type.equals(java_util_Date) || type.equals(java_sql_Date)) {
                SimpleDateFormat sdf = new SimpleDateFormat(format.equals("") ? "yyyy.MM.dd HH:mm:ss.SSS" : format);
                return sdf.format(value);
            }
            if (type.equals(java_sql_Time)) {
                SimpleDateFormat sdf = new SimpleDateFormat(format.equals("") ? "HH:mm:ss.SSS" : format);
                return sdf.format(value);
            }
            if (type.equals(java_sql_Timestamp)) {
                SimpleDateFormat sdf = new SimpleDateFormat(format.equals("") ? "yyyy.MM.dd HH:mm:ss.SSS" : format);
                return sdf.format(value);
            }
            if (value instanceof Color) {
                return ObjectTool.Color2Hex((Color)value);
            }
            return value.toString();
        }
        if (toType.equals(java_sql_Timestamp) || toType.equals(java_sql_Time) || toType.equals(java_sql_Date) || toType.equals(java_util_Date)) {
            String type = value.getClass().getName();
            if (value instanceof java.util.Date) {
                java.util.Date d = (java.util.Date)value;
                return new Timestamp(d.getTime());
            }
            if (value instanceof String) {
                java.util.Date retd = ObjectTool.String2Date(value.toString());
                return retd;
            }
            try {
                long long_ = Long.parseLong(value.toString());
                return new Timestamp(long_);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (toType.equals("[B")) {
            return (Byte[])value;
        }
        if (toType.equals(java_awt_Color)) {
            if (value instanceof Color) {
                return value;
            }
            if (value instanceof String) {
                return ObjectTool.Hex2Color((String)value);
            }
            if (value instanceof Number) {
                return new Color(((Number)value).intValue());
            }
        }
        return value;
    }

    public static int toInt(Object v) {
        try {
            Integer nv = (Integer)ObjectTool.ChangeType(v, java_lang_Integer, "");
            return nv;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static boolean toBool(Object v) {
        try {
            Boolean nv = (Boolean)ObjectTool.ChangeType(v, java_lang_Boolean, "");
            return nv;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int DataType2Uniform(int dt) {
        switch (dt) {
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return 1;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return 2;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return 3;
            }
            case 91: 
            case 92: 
            case 93: {
                return 4;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: {
                return 5;
            }
            case 0: 
            case 16: 
            case 70: 
            case 1111: 
            case 2006: {
                return 6;
            }
        }
        return 6;
    }

    public static double Round(double num, int i) {
        if (num >= 0.0) {
            return Math.floor(num * Math.pow(10.0, i) + 0.5) / Math.pow(10.0, i);
        }
        return Math.ceil(num * Math.pow(10.0, i) - 0.5) / Math.pow(10.0, i);
    }

    public static String Color2Hex(Color c) {
        String r = "00" + Integer.toString(c.getRed(), 16);
        r = r.substring(r.length() - 2, r.length());
        String g = "00" + Integer.toString(c.getGreen(), 16);
        g = g.substring(g.length() - 2, g.length());
        String b = "00" + Integer.toString(c.getBlue(), 16);
        b = b.substring(b.length() - 2, b.length());
        return "#" + r + g + b;
    }

    public static Color Hex2Color(String c) {
        try {
            Color color = Color.decode(c);
            return color;
        }
        catch (Exception e) {
            return Color.BLACK;
        }
    }
}

