/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tlv;

import java.util.Set;
import java.util.Stack;
import javax.servlet.jsp.tagext.PageData;
import javax.servlet.jsp.tagext.ValidationMessage;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tlv.JstlBaseTLV;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class JstlXmlTLV
extends JstlBaseTLV {
    private final String CHOOSE = "choose";
    private final String WHEN = "when";
    private final String OTHERWISE = "otherwise";
    private final String PARSE = "parse";
    private final String PARAM = "param";
    private final String TRANSFORM = "transform";
    private final String JSP_TEXT = "jsp:text";
    private final String EVAL = "evaluator";
    private final String VALUE = "value";
    private final String SOURCE = "xml";

    protected DefaultHandler getHandler() {
        return new Handler();
    }

    public ValidationMessage[] validate(String string, String string2, PageData pageData) {
        return super.validate(4, string, string2, pageData);
    }

    private class Handler
    extends DefaultHandler {
        private int depth = 0;
        private Stack chooseDepths = new Stack();
        private Stack chooseHasOtherwise = new Stack();
        private Stack chooseHasWhen = new Stack();
        private String lastElementName = null;
        private boolean bodyNecessary = false;
        private boolean bodyIllegal = false;
        private Stack transformWithSource = new Stack();

        private boolean chooseChild() {
            return !this.chooseDepths.empty() && this.depth - 1 == (Integer)this.chooseDepths.peek();
        }

        public void characters(char[] cArray, int n, int n2) {
            this.bodyNecessary = false;
            String string = new String(cArray, n, n2).trim();
            if (string.equals("")) {
                return;
            }
            if (this.bodyIllegal) {
                JstlXmlTLV.this.fail(Resources.getMessage("TLV_ILLEGAL_BODY", this.lastElementName));
            }
            if (this.chooseChild()) {
                String string2 = Resources.getMessage("TLV_ILLEGAL_TEXT_BODY", JstlXmlTLV.this.prefix, "choose", string.length() < 7 ? string : string.substring(0, 7));
                JstlXmlTLV.this.fail(string2);
            }
            if (!this.transformWithSource.empty() && this.topDepth(this.transformWithSource) == this.depth - 1) {
                JstlXmlTLV.this.fail(Resources.getMessage("TLV_ILLEGAL_BODY", JstlXmlTLV.this.prefix + ":" + "transform"));
            }
        }

        private int topDepth(Stack stack) {
            return (Integer)stack.peek();
        }

        private Handler() {
        }

        public void endElement(String string, String string2, String string3) {
            if (string3.equals("jsp:text")) {
                return;
            }
            if (this.bodyNecessary) {
                JstlXmlTLV.this.fail(Resources.getMessage("TLV_MISSING_BODY", this.lastElementName));
            }
            this.bodyIllegal = false;
            if (JstlXmlTLV.this.isXmlTag(string, string2, "choose")) {
                Boolean bl = (Boolean)this.chooseHasWhen.pop();
                if (!bl.booleanValue()) {
                    JstlXmlTLV.this.fail(Resources.getMessage("TLV_PARENT_WITHOUT_SUBTAG", "choose", "when"));
                }
                this.chooseDepths.pop();
                this.chooseHasOtherwise.pop();
            }
            if (!this.transformWithSource.empty() && this.topDepth(this.transformWithSource) == this.depth - 1) {
                this.transformWithSource.pop();
            }
            --this.depth;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            Set set;
            if (string2 == null) {
                string2 = JstlXmlTLV.this.getLocalPart(string3);
            }
            if (string3.equals("jsp:text")) {
                return;
            }
            if (this.bodyIllegal) {
                JstlXmlTLV.this.fail(Resources.getMessage("TLV_ILLEGAL_BODY", this.lastElementName));
            }
            if (string3.startsWith(JstlXmlTLV.this.prefix + ":") && (set = (Set)JstlXmlTLV.this.config.get(string2)) != null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String string4;
                    String string5 = attributes.getLocalName(i);
                    if (!set.contains(string5) || (string4 = JstlXmlTLV.this.validateExpression(string2, string5, attributes.getValue(i))) == null) continue;
                    JstlXmlTLV.this.fail(string4);
                }
            }
            if (string3.startsWith(JstlXmlTLV.this.prefix + ":") && !JstlXmlTLV.this.hasNoInvalidScope(attributes)) {
                JstlXmlTLV.this.fail(Resources.getMessage("TLV_INVALID_ATTRIBUTE", "scope", string3, attributes.getValue("scope")));
            }
            if (string3.startsWith(JstlXmlTLV.this.prefix + ":") && JstlXmlTLV.this.hasEmptyVar(attributes)) {
                JstlXmlTLV.this.fail(Resources.getMessage("TLV_EMPTY_VAR", string3));
            }
            if (string3.startsWith(JstlXmlTLV.this.prefix + ":") && JstlXmlTLV.this.hasDanglingScope(attributes)) {
                JstlXmlTLV.this.fail(Resources.getMessage("TLV_DANGLING_SCOPE", string3));
            }
            if (this.chooseChild()) {
                if (JstlXmlTLV.this.isXmlTag(string, string2, "when")) {
                    this.chooseHasWhen.pop();
                    this.chooseHasWhen.push(new Boolean(true));
                }
                if (!JstlXmlTLV.this.isXmlTag(string, string2, "when") && !JstlXmlTLV.this.isXmlTag(string, string2, "otherwise")) {
                    JstlXmlTLV.this.fail(Resources.getMessage("TLV_ILLEGAL_CHILD_TAG", JstlXmlTLV.this.prefix, "choose", string3));
                }
                if (((Boolean)this.chooseHasOtherwise.peek()).booleanValue()) {
                    JstlXmlTLV.this.fail(Resources.getMessage("TLV_ILLEGAL_ORDER", string3, JstlXmlTLV.this.prefix, "otherwise", "choose"));
                }
                if (JstlXmlTLV.this.isXmlTag(string, string2, "otherwise")) {
                    this.chooseHasOtherwise.pop();
                    this.chooseHasOtherwise.push(new Boolean(true));
                }
            }
            if (!this.transformWithSource.empty() && this.topDepth(this.transformWithSource) == this.depth - 1 && !JstlXmlTLV.this.isXmlTag(string, string2, "param")) {
                JstlXmlTLV.this.fail(Resources.getMessage("TLV_ILLEGAL_BODY", JstlXmlTLV.this.prefix + ":" + "transform"));
            }
            if (JstlXmlTLV.this.isXmlTag(string, string2, "choose")) {
                this.chooseDepths.push(new Integer(this.depth));
                this.chooseHasWhen.push(new Boolean(false));
                this.chooseHasOtherwise.push(new Boolean(false));
            }
            this.bodyIllegal = false;
            this.bodyNecessary = false;
            if (JstlXmlTLV.this.isXmlTag(string, string2, "parse")) {
                if (JstlXmlTLV.this.hasAttribute(attributes, "xml")) {
                    this.bodyIllegal = true;
                }
            } else if (JstlXmlTLV.this.isXmlTag(string, string2, "param")) {
                if (JstlXmlTLV.this.hasAttribute(attributes, "value")) {
                    this.bodyIllegal = true;
                } else {
                    this.bodyNecessary = true;
                }
            } else if (JstlXmlTLV.this.isXmlTag(string, string2, "transform") && JstlXmlTLV.this.hasAttribute(attributes, "xml")) {
                this.transformWithSource.push(new Integer(this.depth));
            }
            this.lastElementName = string3;
            JstlXmlTLV.this.lastElementId = attributes.getValue("http://java.sun.com/JSP/Page", "id");
            ++this.depth;
        }
    }
}

