/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.sql;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.jstl.core.Config;
import javax.servlet.jsp.tagext.TagSupport;
import javax.sql.DataSource;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tag.common.core.Util;
import org.apache.taglibs.standard.tag.common.sql.DataSourceUtil;
import org.apache.taglibs.standard.tag.common.sql.DataSourceWrapper;

public class SetDataSourceTagSupport
extends TagSupport {
    protected Object dataSource;
    protected boolean dataSourceSpecified;
    protected String jdbcURL;
    protected String driverClassName;
    protected String userName;
    protected String password;
    private int scope;
    private String var;

    public int doStartTag() throws JspException {
        DataSource dataSource;
        if (this.dataSource != null) {
            dataSource = DataSourceUtil.getDataSource(this.dataSource, this.pageContext);
        } else {
            if (this.dataSourceSpecified) {
                throw new JspException(Resources.getMessage("SQL_DATASOURCE_NULL"));
            }
            DataSourceWrapper dataSourceWrapper = new DataSourceWrapper();
            try {
                if (this.driverClassName != null) {
                    dataSourceWrapper.setDriverClassName(this.driverClassName);
                }
            }
            catch (Exception exception) {
                throw new JspTagException(Resources.getMessage("DRIVER_INVALID_CLASS", exception.toString()), (Throwable)exception);
            }
            dataSourceWrapper.setJdbcURL(this.jdbcURL);
            dataSourceWrapper.setUserName(this.userName);
            dataSourceWrapper.setPassword(this.password);
            dataSource = dataSourceWrapper;
        }
        if (this.var != null) {
            this.pageContext.setAttribute(this.var, (Object)dataSource, this.scope);
        } else {
            Config.set(this.pageContext, "javax.servlet.jsp.jstl.sql.dataSource", dataSource, this.scope);
        }
        return 0;
    }

    public SetDataSourceTagSupport() {
        this.init();
    }

    private void init() {
        this.dataSource = null;
        this.dataSourceSpecified = false;
        this.password = null;
        this.userName = null;
        this.driverClassName = null;
        this.jdbcURL = null;
        this.var = null;
        this.scope = 1;
    }

    public void release() {
        this.init();
    }

    public void setScope(String string) {
        this.scope = Util.getScope(string);
    }

    public void setVar(String string) {
        this.var = string;
    }
}

