/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.fmt;

import java.io.IOException;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tag.common.core.Util;
import org.apache.taglibs.standard.tag.common.fmt.SetLocaleSupport;

public abstract class ParseNumberSupport
extends BodyTagSupport {
    private static final String NUMBER = "number";
    private static final String CURRENCY = "currency";
    private static final String PERCENT = "percent";
    protected String value;
    protected boolean valueSpecified;
    protected String type;
    protected String pattern;
    protected Locale parseLocale;
    protected boolean isIntegerOnly;
    protected boolean integerOnlySpecified;
    private String var;
    private int scope;

    public int doEndTag() throws JspException {
        Serializable serializable;
        String string = null;
        if (this.valueSpecified) {
            string = this.value;
        } else if (this.bodyContent != null && this.bodyContent.getString() != null) {
            string = this.bodyContent.getString().trim();
        }
        if (string == null || string.equals("")) {
            if (this.var != null) {
                this.pageContext.removeAttribute(this.var, this.scope);
            }
            return 6;
        }
        Locale locale = this.parseLocale;
        if (locale == null) {
            locale = SetLocaleSupport.getFormattingLocale(this.pageContext, (Tag)this, false, NumberFormat.getAvailableLocales());
        }
        if (locale == null) {
            throw new JspException(Resources.getMessage("PARSE_NUMBER_NO_PARSE_LOCALE"));
        }
        NumberFormat numberFormat = null;
        if (this.pattern != null && !this.pattern.equals("")) {
            serializable = new DecimalFormatSymbols(locale);
            numberFormat = new DecimalFormat(this.pattern, (DecimalFormatSymbols)serializable);
        } else {
            numberFormat = this.createParser(locale);
        }
        if (this.integerOnlySpecified) {
            numberFormat.setParseIntegerOnly(this.isIntegerOnly);
        }
        serializable = null;
        try {
            serializable = numberFormat.parse(string);
        }
        catch (ParseException parseException) {
            throw new JspException(Resources.getMessage("PARSE_NUMBER_PARSE_ERROR", string), (Throwable)parseException);
        }
        if (this.var != null) {
            this.pageContext.setAttribute(this.var, (Object)serializable, this.scope);
        } else {
            try {
                this.pageContext.getOut().print((Object)serializable);
            }
            catch (IOException iOException) {
                throw new JspTagException(iOException.toString(), (Throwable)iOException);
            }
        }
        return 6;
    }

    public ParseNumberSupport() {
        this.init();
    }

    private void init() {
        this.var = null;
        this.pattern = null;
        this.type = null;
        this.value = null;
        this.valueSpecified = false;
        this.parseLocale = null;
        this.integerOnlySpecified = false;
        this.scope = 1;
    }

    public void release() {
        this.init();
    }

    public void setScope(String string) {
        this.scope = Util.getScope(string);
    }

    public void setVar(String string) {
        this.var = string;
    }

    private NumberFormat createParser(Locale locale) throws JspException {
        NumberFormat numberFormat = null;
        if (this.type == null || NUMBER.equalsIgnoreCase(this.type)) {
            numberFormat = NumberFormat.getNumberInstance(locale);
        } else if (CURRENCY.equalsIgnoreCase(this.type)) {
            numberFormat = NumberFormat.getCurrencyInstance(locale);
        } else if (PERCENT.equalsIgnoreCase(this.type)) {
            numberFormat = NumberFormat.getPercentInstance(locale);
        } else {
            throw new JspException(Resources.getMessage("PARSE_NUMBER_INVALID_TYPE", this.type));
        }
        return numberFormat;
    }
}

