/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.fmt;

import java.io.IOException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tag.common.core.Util;
import org.apache.taglibs.standard.tag.common.fmt.SetLocaleSupport;

public abstract class FormatNumberSupport
extends BodyTagSupport {
    private static final Class[] GET_INSTANCE_PARAM_TYPES = new Class[]{class$java$lang$String == null ? (class$java$lang$String = FormatNumberSupport.class$("java.lang.String")) : class$java$lang$String};
    private static final String NUMBER = "number";
    private static final String CURRENCY = "currency";
    private static final String PERCENT = "percent";
    protected Object value;
    protected boolean valueSpecified;
    protected String type;
    protected String pattern;
    protected String currencyCode;
    protected String currencySymbol;
    protected boolean isGroupingUsed;
    protected boolean groupingUsedSpecified;
    protected int maxIntegerDigits;
    protected boolean maxIntegerDigitsSpecified;
    protected int minIntegerDigits;
    protected boolean minIntegerDigitsSpecified;
    protected int maxFractionDigits;
    protected boolean maxFractionDigitsSpecified;
    protected int minFractionDigits;
    protected boolean minFractionDigitsSpecified;
    private String var;
    private int scope;
    private static Class currencyClass;
    static /* synthetic */ Class class$java$lang$String;

    public int doEndTag() throws JspException {
        Locale locale;
        String string = null;
        Object object = null;
        if (this.valueSpecified) {
            object = this.value;
        } else if (this.bodyContent != null && this.bodyContent.getString() != null) {
            object = this.bodyContent.getString().trim();
        }
        if (object == null || object.equals("")) {
            if (this.var != null) {
                this.pageContext.removeAttribute(this.var, this.scope);
            }
            return 6;
        }
        if (object instanceof String) {
            try {
                object = ((String)object).indexOf(46) != -1 ? (Number)Double.valueOf((String)object) : (Number)Long.valueOf((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JspException(Resources.getMessage("FORMAT_NUMBER_PARSE_ERROR", object), (Throwable)numberFormatException);
            }
        }
        if ((locale = SetLocaleSupport.getFormattingLocale(this.pageContext, (Tag)this, true, NumberFormat.getAvailableLocales())) != null) {
            NumberFormat numberFormat = null;
            if (this.pattern != null && !this.pattern.equals("")) {
                DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
                numberFormat = new DecimalFormat(this.pattern, decimalFormatSymbols);
            } else {
                numberFormat = this.createFormatter(locale);
            }
            if (this.pattern != null && !this.pattern.equals("") || CURRENCY.equalsIgnoreCase(this.type)) {
                try {
                    this.setCurrency(numberFormat);
                }
                catch (Exception exception) {
                    throw new JspException(Resources.getMessage("FORMAT_NUMBER_CURRENCY_ERROR"), (Throwable)exception);
                }
            }
            this.configureFormatter(numberFormat);
            string = numberFormat.format(object);
        } else {
            string = object.toString();
        }
        if (this.var != null) {
            this.pageContext.setAttribute(this.var, (Object)string, this.scope);
        } else {
            try {
                this.pageContext.getOut().print(string);
            }
            catch (IOException iOException) {
                throw new JspTagException(iOException.toString(), (Throwable)iOException);
            }
        }
        return 6;
    }

    static {
        try {
            currencyClass = Class.forName("java.util.Currency");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public FormatNumberSupport() {
        this.init();
    }

    private void init() {
        this.type = null;
        this.value = null;
        this.valueSpecified = false;
        this.currencySymbol = null;
        this.currencyCode = null;
        this.var = null;
        this.pattern = null;
        this.groupingUsedSpecified = false;
        this.minIntegerDigitsSpecified = false;
        this.maxIntegerDigitsSpecified = false;
        this.minFractionDigitsSpecified = false;
        this.maxFractionDigitsSpecified = false;
        this.scope = 1;
    }

    public void release() {
        this.init();
    }

    public void setScope(String string) {
        this.scope = Util.getScope(string);
    }

    public void setVar(String string) {
        this.var = string;
    }

    private void configureFormatter(NumberFormat numberFormat) {
        if (this.groupingUsedSpecified) {
            numberFormat.setGroupingUsed(this.isGroupingUsed);
        }
        if (this.maxIntegerDigitsSpecified) {
            numberFormat.setMaximumIntegerDigits(this.maxIntegerDigits);
        }
        if (this.minIntegerDigitsSpecified) {
            numberFormat.setMinimumIntegerDigits(this.minIntegerDigits);
        }
        if (this.maxFractionDigitsSpecified) {
            numberFormat.setMaximumFractionDigits(this.maxFractionDigits);
        }
        if (this.minFractionDigitsSpecified) {
            numberFormat.setMinimumFractionDigits(this.minFractionDigits);
        }
    }

    private void setCurrency(NumberFormat numberFormat) throws Exception {
        String string = null;
        String string2 = null;
        if (this.currencyCode == null && this.currencySymbol == null) {
            return;
        }
        if (this.currencyCode != null && this.currencySymbol != null) {
            if (currencyClass != null) {
                string = this.currencyCode;
            } else {
                string2 = this.currencySymbol;
            }
        } else if (this.currencyCode == null) {
            string2 = this.currencySymbol;
        } else if (currencyClass != null) {
            string = this.currencyCode;
        } else {
            string2 = this.currencyCode;
        }
        if (string != null) {
            Object[] objectArray = new Object[1];
            Method method = currencyClass.getMethod("getInstance", GET_INSTANCE_PARAM_TYPES);
            objectArray[0] = string;
            Object object = method.invoke(null, objectArray);
            Class[] classArray = new Class[]{currencyClass};
            Class<?> clazz = Class.forName("java.text.NumberFormat");
            method = clazz.getMethod("setCurrency", classArray);
            objectArray[0] = object;
            method.invoke((Object)numberFormat, objectArray);
        } else {
            DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
            DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
            decimalFormatSymbols.setCurrencySymbol(string2);
            decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private NumberFormat createFormatter(Locale locale) throws JspException {
        NumberFormat numberFormat = null;
        if (this.type == null || NUMBER.equalsIgnoreCase(this.type)) {
            numberFormat = NumberFormat.getNumberInstance(locale);
        } else if (CURRENCY.equalsIgnoreCase(this.type)) {
            numberFormat = NumberFormat.getCurrencyInstance(locale);
        } else if (PERCENT.equalsIgnoreCase(this.type)) {
            numberFormat = NumberFormat.getPercentInstance(locale);
        } else {
            throw new JspException(Resources.getMessage("FORMAT_NUMBER_INVALID_TYPE", this.type));
        }
        return numberFormat;
    }
}

