/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.fmt;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.core.Config;
import javax.servlet.jsp.jstl.fmt.LocalizationContext;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.taglibs.standard.tag.common.core.Util;
import org.apache.taglibs.standard.tag.common.fmt.SetLocaleSupport;

public abstract class BundleSupport
extends BodyTagSupport {
    private static final Locale EMPTY_LOCALE = new Locale("", "");
    protected String basename;
    protected String prefix;
    private Locale fallbackLocale;
    private LocalizationContext locCtxt;

    public int doEndTag() throws JspException {
        if (this.bodyContent != null) {
            try {
                this.pageContext.getOut().print(this.bodyContent.getString());
            }
            catch (IOException iOException) {
                throw new JspTagException(iOException.toString(), (Throwable)iOException);
            }
        }
        return 6;
    }

    public int doStartTag() throws JspException {
        this.locCtxt = BundleSupport.getLocalizationContext(this.pageContext, this.basename);
        return 2;
    }

    public BundleSupport() {
        this.init();
    }

    private void init() {
        this.prefix = null;
        this.basename = null;
        this.locCtxt = null;
    }

    public void release() {
        this.init();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public LocalizationContext getLocalizationContext() {
        return this.locCtxt;
    }

    public static LocalizationContext getLocalizationContext(PageContext pageContext) {
        LocalizationContext localizationContext = null;
        Object object = Config.find(pageContext, "javax.servlet.jsp.jstl.fmt.localizationContext");
        if (object == null) {
            return null;
        }
        localizationContext = object instanceof LocalizationContext ? (LocalizationContext)object : BundleSupport.getLocalizationContext(pageContext, (String)object);
        return localizationContext;
    }

    private static ResourceBundle findMatch(String string, Locale locale) {
        ResourceBundle resourceBundle = null;
        try {
            ResourceBundle resourceBundle2 = ResourceBundle.getBundle(string, locale, Thread.currentThread().getContextClassLoader());
            Locale locale2 = resourceBundle2.getLocale();
            if (locale.equals(locale2)) {
                resourceBundle = resourceBundle2;
            } else if (locale.getLanguage().equals(locale2.getLanguage()) && ("".equals(locale2.getCountry()) || locale.getCountry().equals(locale2.getCountry()))) {
                resourceBundle = resourceBundle2;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return resourceBundle;
    }

    private static LocalizationContext findMatch(PageContext pageContext, String string) {
        LocalizationContext localizationContext = null;
        Enumeration enumeration = Util.getRequestLocales((HttpServletRequest)pageContext.getRequest());
        while (enumeration.hasMoreElements()) {
            Locale locale = (Locale)enumeration.nextElement();
            ResourceBundle resourceBundle = BundleSupport.findMatch(string, locale);
            if (resourceBundle == null) continue;
            localizationContext = new LocalizationContext(resourceBundle, locale);
            break;
        }
        return localizationContext;
    }

    public static LocalizationContext getLocalizationContext(PageContext pageContext, String string) {
        LocalizationContext localizationContext = null;
        ResourceBundle resourceBundle = null;
        if (string == null || string.equals("")) {
            return new LocalizationContext();
        }
        Locale locale = SetLocaleSupport.getLocale(pageContext, "javax.servlet.jsp.jstl.fmt.locale");
        if (locale != null) {
            resourceBundle = BundleSupport.findMatch(string, locale);
            if (resourceBundle != null) {
                localizationContext = new LocalizationContext(resourceBundle, locale);
            }
        } else {
            localizationContext = BundleSupport.findMatch(pageContext, string);
        }
        if (localizationContext == null && (locale = SetLocaleSupport.getLocale(pageContext, "javax.servlet.jsp.jstl.fmt.fallbackLocale")) != null && (resourceBundle = BundleSupport.findMatch(string, locale)) != null) {
            localizationContext = new LocalizationContext(resourceBundle, locale);
        }
        if (localizationContext == null) {
            try {
                resourceBundle = ResourceBundle.getBundle(string, EMPTY_LOCALE, Thread.currentThread().getContextClassLoader());
                if (resourceBundle != null) {
                    localizationContext = new LocalizationContext(resourceBundle, null);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (localizationContext != null) {
            if (localizationContext.getLocale() != null) {
                SetLocaleSupport.setResponseLocale(pageContext, localizationContext.getLocale());
            }
        } else {
            localizationContext = new LocalizationContext();
        }
        return localizationContext;
    }
}

