/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.lang.jstl;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import org.apache.taglibs.standard.lang.jstl.EnumeratedMap;

public class ImplicitObjects {
    static final String sAttributeName = "org.apache.taglibs.standard.ImplicitObjects";
    PageContext mContext;
    Map mPage;
    Map mRequest;
    Map mSession;
    Map mApplication;
    Map mParam;
    Map mParams;
    Map mHeader;
    Map mHeaders;
    Map mInitParam;
    Map mCookie;

    public Map getApplicationScopeMap() {
        if (this.mApplication == null) {
            this.mApplication = ImplicitObjects.createApplicationScopeMap(this.mContext);
        }
        return this.mApplication;
    }

    public Map getCookieMap() {
        if (this.mCookie == null) {
            this.mCookie = ImplicitObjects.createCookieMap(this.mContext);
        }
        return this.mCookie;
    }

    public Map getHeaderMap() {
        if (this.mHeader == null) {
            this.mHeader = ImplicitObjects.createHeaderMap(this.mContext);
        }
        return this.mHeader;
    }

    public Map getHeadersMap() {
        if (this.mHeaders == null) {
            this.mHeaders = ImplicitObjects.createHeadersMap(this.mContext);
        }
        return this.mHeaders;
    }

    public Map getInitParamMap() {
        if (this.mInitParam == null) {
            this.mInitParam = ImplicitObjects.createInitParamMap(this.mContext);
        }
        return this.mInitParam;
    }

    public Map getPageScopeMap() {
        if (this.mPage == null) {
            this.mPage = ImplicitObjects.createPageScopeMap(this.mContext);
        }
        return this.mPage;
    }

    public Map getParamMap() {
        if (this.mParam == null) {
            this.mParam = ImplicitObjects.createParamMap(this.mContext);
        }
        return this.mParam;
    }

    public Map getParamsMap() {
        if (this.mParams == null) {
            this.mParams = ImplicitObjects.createParamsMap(this.mContext);
        }
        return this.mParams;
    }

    public Map getRequestScopeMap() {
        if (this.mRequest == null) {
            this.mRequest = ImplicitObjects.createRequestScopeMap(this.mContext);
        }
        return this.mRequest;
    }

    public Map getSessionScopeMap() {
        if (this.mSession == null) {
            this.mSession = ImplicitObjects.createSessionScopeMap(this.mContext);
        }
        return this.mSession;
    }

    public ImplicitObjects(PageContext pageContext) {
        this.mContext = pageContext;
    }

    public static Map createApplicationScopeMap(PageContext pageContext) {
        final PageContext pageContext2 = pageContext;
        return new EnumeratedMap(){

            public boolean isMutable() {
                return true;
            }

            public Enumeration enumerateKeys() {
                return pageContext2.getAttributeNamesInScope(4);
            }

            public Object getValue(Object object) {
                if (object instanceof String) {
                    return pageContext2.getAttribute((String)object, 4);
                }
                return null;
            }
        };
    }

    public static Map createCookieMap(PageContext pageContext) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)pageContext.getRequest();
        Cookie[] cookieArray = httpServletRequest.getCookies();
        HashMap<String, Cookie> hashMap = new HashMap<String, Cookie>();
        for (int i = 0; cookieArray != null && i < cookieArray.length; ++i) {
            String string;
            Cookie cookie = cookieArray[i];
            if (cookie == null || hashMap.containsKey(string = cookie.getName())) continue;
            hashMap.put(string, cookie);
        }
        return hashMap;
    }

    public static Map createHeaderMap(PageContext pageContext) {
        final HttpServletRequest httpServletRequest = (HttpServletRequest)pageContext.getRequest();
        return new EnumeratedMap(){

            public boolean isMutable() {
                return false;
            }

            public Enumeration enumerateKeys() {
                return httpServletRequest.getHeaderNames();
            }

            public Object getValue(Object object) {
                if (object instanceof String) {
                    return httpServletRequest.getHeader((String)object);
                }
                return null;
            }
        };
    }

    public static Map createHeadersMap(PageContext pageContext) {
        final HttpServletRequest httpServletRequest = (HttpServletRequest)pageContext.getRequest();
        return new EnumeratedMap(){

            public boolean isMutable() {
                return false;
            }

            public Enumeration enumerateKeys() {
                return httpServletRequest.getHeaderNames();
            }

            public Object getValue(Object object) {
                if (object instanceof String) {
                    ArrayList arrayList = new ArrayList();
                    Enumeration enumeration = httpServletRequest.getHeaders((String)object);
                    if (enumeration != null) {
                        while (enumeration.hasMoreElements()) {
                            arrayList.add(enumeration.nextElement());
                        }
                    }
                    String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
                    return stringArray;
                }
                return null;
            }
        };
    }

    public static Map createInitParamMap(PageContext pageContext) {
        final ServletContext servletContext = pageContext.getServletContext();
        return new EnumeratedMap(){

            public boolean isMutable() {
                return false;
            }

            public Enumeration enumerateKeys() {
                return servletContext.getInitParameterNames();
            }

            public Object getValue(Object object) {
                if (object instanceof String) {
                    return servletContext.getInitParameter((String)object);
                }
                return null;
            }
        };
    }

    public static Map createPageScopeMap(PageContext pageContext) {
        final PageContext pageContext2 = pageContext;
        return new EnumeratedMap(){

            public boolean isMutable() {
                return true;
            }

            public Enumeration enumerateKeys() {
                return pageContext2.getAttributeNamesInScope(1);
            }

            public Object getValue(Object object) {
                if (object instanceof String) {
                    return pageContext2.getAttribute((String)object, 1);
                }
                return null;
            }
        };
    }

    public static Map createParamMap(PageContext pageContext) {
        final HttpServletRequest httpServletRequest = (HttpServletRequest)pageContext.getRequest();
        return new EnumeratedMap(){

            public boolean isMutable() {
                return false;
            }

            public Enumeration enumerateKeys() {
                return httpServletRequest.getParameterNames();
            }

            public Object getValue(Object object) {
                if (object instanceof String) {
                    return httpServletRequest.getParameter((String)object);
                }
                return null;
            }
        };
    }

    public static Map createParamsMap(PageContext pageContext) {
        final HttpServletRequest httpServletRequest = (HttpServletRequest)pageContext.getRequest();
        return new EnumeratedMap(){

            public boolean isMutable() {
                return false;
            }

            public Enumeration enumerateKeys() {
                return httpServletRequest.getParameterNames();
            }

            public Object getValue(Object object) {
                if (object instanceof String) {
                    return httpServletRequest.getParameterValues((String)object);
                }
                return null;
            }
        };
    }

    public static Map createRequestScopeMap(PageContext pageContext) {
        final PageContext pageContext2 = pageContext;
        return new EnumeratedMap(){

            public boolean isMutable() {
                return true;
            }

            public Enumeration enumerateKeys() {
                return pageContext2.getAttributeNamesInScope(2);
            }

            public Object getValue(Object object) {
                if (object instanceof String) {
                    return pageContext2.getAttribute((String)object, 2);
                }
                return null;
            }
        };
    }

    public static Map createSessionScopeMap(PageContext pageContext) {
        final PageContext pageContext2 = pageContext;
        return new EnumeratedMap(){

            public boolean isMutable() {
                return true;
            }

            public Enumeration enumerateKeys() {
                return pageContext2.getAttributeNamesInScope(3);
            }

            public Object getValue(Object object) {
                if (object instanceof String) {
                    return pageContext2.getAttribute((String)object, 3);
                }
                return null;
            }
        };
    }

    public static ImplicitObjects getImplicitObjects(PageContext pageContext) {
        ImplicitObjects implicitObjects = (ImplicitObjects)pageContext.getAttribute(sAttributeName, 1);
        if (implicitObjects == null) {
            implicitObjects = new ImplicitObjects(pageContext);
            pageContext.setAttribute(sAttributeName, (Object)implicitObjects, 1);
        }
        return implicitObjects;
    }
}

