/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.lang.jstl;

import java.util.List;
import java.util.Map;
import org.apache.taglibs.standard.lang.jstl.BinaryOperator;
import org.apache.taglibs.standard.lang.jstl.Coercions;
import org.apache.taglibs.standard.lang.jstl.ELException;
import org.apache.taglibs.standard.lang.jstl.Expression;
import org.apache.taglibs.standard.lang.jstl.Logger;
import org.apache.taglibs.standard.lang.jstl.VariableResolver;

public class BinaryOperatorExpression
extends Expression {
    Expression mExpression;
    List mOperators;
    List mExpressions;

    public String getExpressionString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append(this.mExpression.getExpressionString());
        for (int i = 0; i < this.mOperators.size(); ++i) {
            BinaryOperator binaryOperator = (BinaryOperator)this.mOperators.get(i);
            Expression expression = (Expression)this.mExpressions.get(i);
            stringBuffer.append(" ");
            stringBuffer.append(binaryOperator.getOperatorSymbol());
            stringBuffer.append(" ");
            stringBuffer.append(expression.getExpressionString());
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public List getExpressions() {
        return this.mExpressions;
    }

    public List getOperators() {
        return this.mOperators;
    }

    public void setExpressions(List list) {
        this.mExpressions = list;
    }

    public void setOperators(List list) {
        this.mOperators = list;
    }

    public Expression getExpression() {
        return this.mExpression;
    }

    public void setExpression(Expression expression) {
        this.mExpression = expression;
    }

    public BinaryOperatorExpression(Expression expression, List list, List list2) {
        this.mExpression = expression;
        this.mOperators = list;
        this.mExpressions = list2;
    }

    public Object evaluate(Object object, VariableResolver variableResolver, Map map, String string, Logger logger) throws ELException {
        Object object2 = this.mExpression.evaluate(object, variableResolver, map, string, logger);
        for (int i = 0; i < this.mOperators.size(); ++i) {
            BinaryOperator binaryOperator = (BinaryOperator)this.mOperators.get(i);
            if (binaryOperator.shouldCoerceToBoolean()) {
                object2 = Coercions.coerceToBoolean(object2, logger);
            }
            if (!binaryOperator.shouldEvaluate(object2)) continue;
            Expression expression = (Expression)this.mExpressions.get(i);
            Object object3 = expression.evaluate(object, variableResolver, map, string, logger);
            object2 = binaryOperator.apply(object2, object3, object, logger);
        }
        return object2;
    }
}

