/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.jsp.jstl.tlv;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.jsp.tagext.PageData;
import javax.servlet.jsp.tagext.TagLibraryValidator;
import javax.servlet.jsp.tagext.ValidationMessage;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ScriptFreeTLV
extends TagLibraryValidator {
    private boolean allowDeclarations = false;
    private boolean allowScriptlets = false;
    private boolean allowExpressions = false;
    private boolean allowRTExpressions = false;
    private SAXParserFactory factory = SAXParserFactory.newInstance();

    public ScriptFreeTLV() {
        this.factory.setValidating(false);
        this.factory.setNamespaceAware(true);
    }

    public void setInitParameters(Map map) {
        super.setInitParameters(map);
        String string = (String)map.get("allowDeclarations");
        String string2 = (String)map.get("allowScriptlets");
        String string3 = (String)map.get("allowExpressions");
        String string4 = (String)map.get("allowRTExpressions");
        this.allowDeclarations = "true".equalsIgnoreCase(string);
        this.allowScriptlets = "true".equalsIgnoreCase(string2);
        this.allowExpressions = "true".equalsIgnoreCase(string3);
        this.allowRTExpressions = "true".equalsIgnoreCase(string4);
    }

    private static ValidationMessage[] vmFromString(String string) {
        return new ValidationMessage[]{new ValidationMessage(null, string)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ValidationMessage[] validate(String string, String string2, PageData pageData) {
        SAXParser sAXParser;
        InputStream inputStream = null;
        MyContentHandler myContentHandler = new MyContentHandler();
        SAXParserFactory sAXParserFactory = this.factory;
        synchronized (sAXParserFactory) {
            sAXParser = this.factory.newSAXParser();
        }
        inputStream = pageData.getInputStream();
        sAXParser.parse(inputStream, (DefaultHandler)myContentHandler);
        Object var10_15 = null;
        if (inputStream == null) return myContentHandler.reportResults();
        try {
            inputStream.close();
            return myContentHandler.reportResults();
        }
        catch (IOException iOException) {}
        return myContentHandler.reportResults();
        {
            catch (ParserConfigurationException parserConfigurationException) {
                ValidationMessage[] validationMessageArray = ScriptFreeTLV.vmFromString(parserConfigurationException.toString());
                Object var10_16 = null;
                if (inputStream == null) return validationMessageArray;
                try {
                    inputStream.close();
                    return validationMessageArray;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return validationMessageArray;
            }
            catch (SAXException sAXException) {
                ValidationMessage[] validationMessageArray = ScriptFreeTLV.vmFromString(sAXException.toString());
                Object var10_17 = null;
                if (inputStream == null) return validationMessageArray;
                try {
                    inputStream.close();
                    return validationMessageArray;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return validationMessageArray;
            }
            catch (IOException iOException) {
                ValidationMessage[] validationMessageArray = ScriptFreeTLV.vmFromString(iOException.toString());
                Object var10_18 = null;
                if (inputStream == null) return validationMessageArray;
                {
                    catch (Throwable throwable) {
                        Object var10_19 = null;
                        if (inputStream == null) throw throwable;
                        try {
                            inputStream.close();
                            throw throwable;
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                try {
                    inputStream.close();
                    return validationMessageArray;
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
                return validationMessageArray;
            }
        }
    }

    private class MyContentHandler
    extends DefaultHandler {
        private int declarationCount = 0;
        private int scriptletCount = 0;
        private int expressionCount = 0;
        private int rtExpressionCount = 0;

        private MyContentHandler() {
        }

        public ValidationMessage[] reportResults() {
            if (this.declarationCount + this.scriptletCount + this.expressionCount + this.rtExpressionCount > 0) {
                StringBuffer stringBuffer = new StringBuffer("JSP page contains ");
                boolean bl = true;
                if (this.declarationCount > 0) {
                    stringBuffer.append(Integer.toString(this.declarationCount));
                    stringBuffer.append(" declaration");
                    if (this.declarationCount > 1) {
                        stringBuffer.append('s');
                    }
                    bl = false;
                }
                if (this.scriptletCount > 0) {
                    if (!bl) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(Integer.toString(this.scriptletCount));
                    stringBuffer.append(" scriptlet");
                    if (this.scriptletCount > 1) {
                        stringBuffer.append('s');
                    }
                    bl = false;
                }
                if (this.expressionCount > 0) {
                    if (!bl) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(Integer.toString(this.expressionCount));
                    stringBuffer.append(" expression");
                    if (this.expressionCount > 1) {
                        stringBuffer.append('s');
                    }
                    bl = false;
                }
                if (this.rtExpressionCount > 0) {
                    if (!bl) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(Integer.toString(this.rtExpressionCount));
                    stringBuffer.append(" request-time attribute value");
                    if (this.rtExpressionCount > 1) {
                        stringBuffer.append('s');
                    }
                    bl = false;
                }
                stringBuffer.append(".");
                return ScriptFreeTLV.vmFromString(stringBuffer.toString());
            }
            return null;
        }

        private void countRTExpressions(Attributes attributes) {
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                String string = attributes.getValue(i);
                if (!string.startsWith("%=") || !string.endsWith("%")) continue;
                ++this.rtExpressionCount;
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if (!ScriptFreeTLV.this.allowDeclarations && string3.equals("jsp:declaration")) {
                ++this.declarationCount;
            } else if (!ScriptFreeTLV.this.allowScriptlets && string3.equals("jsp:scriptlet")) {
                ++this.scriptletCount;
            } else if (!ScriptFreeTLV.this.allowExpressions && string3.equals("jsp:expression")) {
                ++this.expressionCount;
            }
            if (!ScriptFreeTLV.this.allowRTExpressions) {
                this.countRTExpressions(attributes);
            }
        }
    }
}

