/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.jsp.jstl.core;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;

public abstract class ConditionalTagSupport
extends TagSupport {
    private boolean result;
    private String var;
    private int scope;

    public int doStartTag() throws JspException {
        this.result = this.condition();
        this.exposeVariables();
        if (this.result) {
            return 1;
        }
        return 0;
    }

    public ConditionalTagSupport() {
        this.init();
    }

    private void exposeVariables() {
        if (this.var != null) {
            this.pageContext.setAttribute(this.var, (Object)new Boolean(this.result), this.scope);
        }
    }

    private void init() {
        this.result = false;
        this.var = null;
        this.scope = 1;
    }

    public void release() {
        super.release();
        this.init();
    }

    protected abstract boolean condition() throws JspTagException;

    public void setScope(String string) {
        if (string.equalsIgnoreCase("page")) {
            this.scope = 1;
        } else if (string.equalsIgnoreCase("request")) {
            this.scope = 2;
        } else if (string.equalsIgnoreCase("session")) {
            this.scope = 3;
        } else if (string.equalsIgnoreCase("application")) {
            this.scope = 4;
        }
    }

    public void setVar(String string) {
        this.var = string;
    }
}

