+function (ENV) {

    let standardCols = null;
    let candidateCols = "";

    let candidateColsHTML = "";


    /**
     * 得到模型的标准字段清单
     * @param modleId 模型的ID
     * @returns {Promise<unknown>}
     */
    function getStandardColsForModle(modleId) {
        return new Promise((resolve, reject) => {
            $rpc("config", "tree.data.Tree_app_sqlbuild", "getDataSourceConfigString",
                {
                    pid: modleId
                }, function (ret) {
                    ret = JSON.parse(ret);
                    console.dir(ret);

                    let cols = ret.column;
                    standardCols = cols;
                    resolve(cols);
                });

        });
    }

    /**
     * 得到主表及它下面子表所有筛选出的字段清单（不是所有字段都参与匹配，可以先做筛选，减少参与匹配的字段数)
     * @param tableId
     * @returns {Promise<unknown>}
     */
    function getAllColumnsOfOneSubTreeUnderInstance(tableId) {
        return new Promise((resolve, reject) => {
            $rpc("config", "tree.data.Tree_app_sqlbuild", "getAllColumnsOfOneSubTreeUnderInstance",
                {
                    tableid: tableId
                }, function (ret) {
                    ret = JSON.parse(ret);
                    console.dir(ret);
                    candidateCols = ret.column;
                    let cols = ret.column;
                    let html = [];
                    html.push(`<select class="map2col" style="width:100%;  " ><option value="">无</option>`);
                    for (let i = 0; i < cols.length; i++) {
                        let col = cols[i];
                        html.push(`<option value="${col.tableid}.${col.name}">${col.tablealias}.${col.name}${col.name != col.label ? '[' + col.label + ']' : ''}</option>`)
                    }
                    html.push(`</select>`);
                    candidateColsHTML = html.join('');
                    resolve(1);
                });

        });
    }


    function initColMap(modleId, tableId, colMap) {
        Promise.all([getStandardColsForModle(modleId), getAllColumnsOfOneSubTreeUnderInstance(tableId)])
            .then(function () {
                let html = TrimPath.processDOMTemplate("template/ui/app_sqlbuild/template_sqlbuild_colmap",
                    {standardCols: standardCols, candidateColsHTML: candidateColsHTML});
                $('#colMapContainer').html(html);

                // select编辑优化 ,要放在自动匹配及加载设置之后，因为此后，再改 select 的值，就不能 同步到增加select中了
                $('#colMapTable').find('select.map2col').chosen(
                    {width: '100%',
                        no_results_text:'无匹配项',
                    search_contains:true  /*like方式匹配，而不是startsWith方式*/ });


                //事件初始化
                $('#colMapTable').delegate('.iscomputer', 'click', function (evt) {
                    let checked = evt.target.checked;
                    let tr = $(evt.target).closest('tr') ;
                    setIsComputerInTR( tr ,checked);

                });

                //加载设置
                loadColMap(colMap);
                //自动匹配

                autoMap();



                //自适应高度
                autoHeight();


            });

    }


    function  setIsComputerInTR(tr , iscomputer)
    {
        let C = tr.find('.map2colContainer');
        if (iscomputer) {
            C.find('textarea.expression').removeClass('hidden');
            C.find('.chosen-container').addClass('hidden');


        } else {
            C.find('textarea.expression').addClass('hidden');
            C.find('.chosen-container').removeClass('hidden');

        }
    }

    function findMapedCol( name , colMap)
    {
         for(let i=0;i< colMap.length; i++ )
         {
             if( colMap[i].name== name) return colMap[i];
         }
         return null;
    }


    /**
     * 加载映射关系
     * @param colMap
     */
    function loadColMap(colMap) {
        if (colMap == '') return;
        try {
            colMap = JSON.parse(colMap);

        } catch (err) {
            return;
        }

        var trs = $('#colMapTable').find('tbody').find('tr');

        for (let i = 0; i < trs.length; i++) {
            let tr = $(trs[i]);
            let name = tr.find('.stdcolname').text();

            let map = findMapedCol(name, colMap);
            if (map == null) continue;
            tr.find('.iscomputer')[0].checked = map.iscomputer;
            setIsComputerInTR( tr ,map.iscomputer);
            if (map.iscomputer) {
                tr.find('.expression').val(map.map2col);
            } else {
                let select=tr.find('.map2col');

                //可能在筛选中去掉此字段，导致列表中不存在，那么加上它
                if( select.find('option[value="'+map.map2col+'"]').length==0)
                {
                    select.append(`<option value="${map.map2col}">${map.map2col}</option>`);
                }
                select.val(map.map2col);
                select.trigger('chosen:updated');//让增强select同步选中数据

            }

            tr.find('.summary').val(map.summary);
        }
    }

    //自动映射
    function autoMap(forceRedo) {
        if( forceRedo==null) forceRedo=false;
        var trs = $('#colMapTable').find('tbody').find('tr');

        for (let i = 0; i < trs.length; i++) {
            let tr = $(trs[i]);
            let name = tr.find('.stdcolname').text();
            let label = tr.find('.stdcollabel').text();

            let iscomputer = tr.find('.iscomputer')[0].checked;
            if (iscomputer) continue;
            let colSelect = tr.find('.map2col');
            let map2col = colSelect.val();
            if (map2col != '' && !forceRedo) continue;

            let matched = false;
            //优先匹配可选字段的别名
            for (let j = 0; j < candidateCols.length; j++) {
                let one = candidateCols[j];
                if (one.alias.equalsIgnoreCase(name)) {
                    colSelect.val(one.tableid + "." + one.name);
                    colSelect.trigger('chosen:updated');//让增强select同步选中数据
                    matched = true;
                    break;
                }
            }
            if ((matched)) continue;
            //再匹配中文名称
            for (let j = 0; j < candidateCols.length; j++) {
                let one = candidateCols[j];
                if (one.label.equalsIgnoreCase(label)) {
                    colSelect.val(one.tableid + "." + one.name);
                    colSelect.trigger('chosen:updated');//让增强select同步选中数据
                    matched = true;
                    break;
                }
            }
            if ((matched)) continue;

            //再匹配字段名称
            for (let j = 0; j < candidateCols.length; j++) {
                let one = candidateCols[j];
                if (one.name.equalsIgnoreCase(name)) {
                    colSelect.val(one.tableid + "." + one.name);
                    colSelect.trigger('chosen:updated');//让增强select同步选中数据
                    matched = true;
                    break;
                }
            }
            if ((matched)) continue;

        }
    }

    /**
     * textarea根据内容自动调整高度
     */
    function autoHeight() {

        let textareas = $('#colMapContainer').find('textarea');
        for (let i = 0; i < textareas.length; i++) {
            autoTextarea(textareas[i]);
        }
    }

    /**
     * 构建映射设置
     * @returns {*[]}
     */
    function buildColMap() {
        let map = [];
        var trs = $('#colMapTable').find('tbody').find('tr');
        for (let i = 0; i < trs.length; i++) {
            let tr = $(trs[i]);
            let name = tr.find('.stdcolname').text();
            let iscomputer = tr.find('.iscomputer')[0].checked;
            let map2col = iscomputer ? tr.find('.expression').val() : tr.find('.map2col').val();
            let summary = tr.find('.summary').val();
            let one = {name: name, iscomputer: iscomputer, map2col: map2col, summary: summary};
            map.push(one);
        }
        return map;
    }

    ENV.initColMap = initColMap;
    ENV.buildColMap = buildColMap;
    ENV.autoMap= autoMap;


}(window);
