g_renameAfterAdd = false;

gb_reloadAfterSave =false; //保存后不 要刷新页面

function canAdd_app_sqlbuild(pid, pNodeType, thisNodeType) {
    if (thisNodeType == 'query') {

        if (pNodeType != 'node') {
            toastr.error("只允许在目录下增加业务模型");
            return false;

        }

    }

    if (thisNodeType == 'instance') {

        if (pNodeType != 'query') {
            toastr.error("只允许在业务模型下增加实例");
            return false;

        }

    }


    if (thisNodeType == 'table') {

        if (!(pNodeType == 'table' || pNodeType == 'instance')) {
            toastr.error("只允许在实例下增加表，或在表下增加关联表");
            return false;
        }
    }


    if (thisNodeType == 'node' && pid != g_treeRootId) {
        if (pNodeType != 'node') {

            toastr.error("只能在目录下增加子目录");
            return false;
        }
    }
    return true;
}

//"inner"：成为子节点，"prev"：成为同级前一个节点，"next"：成为同级后一个节点
function beforeDrop_app_sqlbuild(treeId, treeNodes, targetNode, moveType) {

    var treeNode = treeNodes[0];

    let thisNodeType = treeNode.nodetype;
    let pNodeType = targetNode.nodetype;


    if (thisNodeType == 'query') {

        if (pNodeType != 'node') {
            toastr.error("业务模型只允许拖到目录下");
            return false;

        }

    }

    if (thisNodeType == 'instance') {

        if (pNodeType != 'query') {
            toastr.error("业务实例只允许拖到业务模型下");
            return false;

        }

    }


    if (thisNodeType == 'table') {

        if (!(pNodeType == 'table' || pNodeType == 'instance')) {
            toastr.error("表只允许拖到实例下或表下");
            return false;
        }
    }


    if (thisNodeType == 'node' && pid != g_treeRootId) {
        if (pNodeType != 'node') {

            toastr.error("目录只能拖到目录下成为子目录");
            return false;
        }
    }
    return true;

}

$(document).ready(function () {
    $(document).delegate('#cb_save2', 'click', save2);
});

//模块设置保存前的校验
function save2() {


    if ($('#frameForColumns').length > 0) {


        $('#frameForColumns')[0].contentWindow.save(false, function () {
            save(true, function () {//
                // 禁止重新刷新
                hideInfoPane();
            });
        });


    } else {
        save(true, function () {//
            // 禁止重新刷新
        });
    }


}


//模块设置保存前的校验
function beforeSave_app_sqlbuild_check() {

    //把SQL语句回填到sql中
    if ($('#sql').length > 0 && sqlEditor != undefined) {
        var str = sqlEditor.getValue();
        $('#sql').val(str);
        checkInvalidCharInSQL(false);
    }

    if( $('#dynamicwhere2').length>0 ) {
        checkInvalidCharInSQL(false, $('#dynamicwhere2').val(), "动态检索条件中");
    }

    let parentNodeType="";
    let pnode= g_currentTreeNode.getParentNode();
    if( pnode!=null) parentNodeType= pnode.nodetype;

    if ( parentNodeType == 'table') //如果有上级表，那么 join属性需要定义
    {
        if ($('#jointype').val() == '') {
            toastr.error("必须定义join方式");
            return false;
        }

        let joinon = $('#joinon').val();
        joinon = joinon.replace(/\s/g, ''); //去掉空格回车等
        if (joinon == '') {
            toastr.error("必须定义关联关系");
            return false;
        }

    }

    if (parentNodeType == 'instance') //如果是实例下的主表
    {
        $("#colmap").val( JSON.stringify(  buildColMap()));
    }

    //计算列
    if( $('#computers').length>0)
    {
        let t= JSON.stringify(  getComputerList());
        $('#computers').val( t);
    }


    return true;


}


function setDataSourceType(ms) {


    $('#type_table').attr('checked', ms == 'table');
    $('#type_sql').attr('checked', ms == 'sql');
    if (ms == 'table') {
        $('.forTable').removeClass("hidden");
        $('.forSQL').addClass("hidden");
    }
    if (ms == 'sql') {
        $('.forTable').addClass("hidden");
        $('.forSQL').removeClass("hidden");

        if (window.sqlEditor == null) initSQLEditor();
    }
}


// 只在在实例上才定义了连接池，所以当前表的连接池必须向上查找
function getTableDBPool() {
    let node = g_currentTreeNode;
    while (true) {
        if (node.nodetype == 'instance') return   getNodeData(node.id).value; //注意不要直接用  node.value 可能刚设置，树上的节点数据在不全
        node = node.getParentNode();
        if (node == null) return '';
    }

}


function showMainToolbar() {
    $('#mainToolbarContainer').show();

}

function hideMainToolbar() {
    $('#mainToolbarContainer').hide();
}


//得到业务模型的标准字段清单
function getModelStandardCols(model_id) {

}


function checkInvalidCharInSQL(showTip ,what , title) {
    if (showTip == undefined) showTip = true;
    if( title==undefined) title="";
    var sql = what;
    if( what==undefined) sql = sqlEditor.getValue();
    var invalidChar = '‘’“”（）－，。　';
    var msg = ['中文左单引号‘', '中文右单引号’', '中文左双引号“', '中文右双引号”', '中文左括号（', '中文右括号）', '中文－', '中文逗号，', '中文句号。', '中文空格　'];
    for (var i = 0; i < invalidChar.length; i++) {
        var ch = invalidChar.substr(i, 1);
        if (sql.indexOf(ch) >= 0) {
            toastr.error( title+ msg[i] + "可能引起错误");
            return false;
        }
    }
    //保存前的校验，如果没有异常，就不要提示
    if (showTip) toastr.success('没有发现可能引发异常的中文字符');
    return true;
}

function autoBuildJoin( id )
{
    $rpc("config", "tree.data.Tree_app_sqlbuild", "buildJOIN", {
            tableid: $('#id').val()   //表的配置的ID
        },
        function (retValue) {
            var ret = JSON.parse(retValue);
            let where = ret.where;
            $setClipboard(where);
            toastr.info( "关联条件已复制到剪贴板，请自行粘贴");
        });
}

function dataView() {

    save(true, function () {
        let dbpool = getTableDBPool();
        let sql = "";

        let go_dataView = function (sql_) {
            let key = $('#id').val();
            let data = {dbpool: dbpool, sql: sql_};
            localStorage.setItem(key, JSON.stringify(data));
            let url = "sqlrun.jsp?key=" + key;
            openWindow(url);
        }

        if ($('#type_table')[0].checked) {
            sql = "select * from " + $('#selfproperty').val();
            go_dataView(sql);
        } else {
            sql = sqlEditor.getValue();
            if (sql.indexOf(":") >= 0 && sql.indexOf("{") > 0 && sql.indexOf("}") > 0) {
                $rpc("config", "tree.data.Tree_app_sqlbuild", "getDataSourceColumnsList", {
                        tableid: $('#id').val()   //表的配置的ID
                    },
                    function (retValue) {
                        var ret = JSON.parse(retValue);
                        sql = ret.sql;
                        sql = sql.replace(/(\s)+1[=]2(\s)*/g, " 1=1 ");
                        sql = sql.replace(/\(1[=]2\)/g, " 1=1 ");
                        go_dataView(sql);
                    });
            } else {
                go_dataView(sql);
            }
        }


    });


}

//在字段字典中筛选几个字段用来映射
function columnFilter()
{
    findDBDictIdAndDo(function (dict_id) {

        //获取字段清单 参看  db_dict_col.js
        $rpc("config", "tree.data.Tree_app_db_dict", "getDataSourceConfigString",
            {
                pid: dict_id
            }, function (ret) {
                ret = JSON.parse(ret);
                console.dir(ret);
                var columns = ret.column;
                console.dir( columns);
                ret.limitcolumns= $('#limitcolumns').val().split(',');

                var p = {
                    theme: 'light',
                    closeIcon: true,
                    columnClass: 'col-md-6',
                    closeIconClass_: 'fa fa-close',
                    animation: 'zoom',
                    closeAnimation: 'scale',
                    boxWidth: "600px",
                    useBootstrap: false,
                    title: `字段筛选<span style="padding-left:50px;"><input type="input"  id=columnFilter 
                            onkeyup="filterColumn();"
                        style="height:32px;border:1px solid lightgray;font-size:14px; 
                                    border-radius: 16px; padding-left:16px;padding-right:30px; width:200px; " placeholder="过滤" ></span> `,
                    content: TrimPath.processDOMTemplate("template/ui/app_sqlbuild/template_sql_build_limit_column", ret),

                    buttons: {
                        ok:
                            {
                                text: "确定",
                                action: function () {
                                    var ret = [];

                                    var objs = $('.columnToExport');
                                    for (var i = 0; i < objs.length; i++) {
                                        if (objs[i].checked) ret.push( $(objs[i]).attr('data'));
                                    }
                                     $('#limitcolumns').val( ret.join(','));
                                    save(true, function(){});


                                }

                            },
                        cancel:
                            {
                                text: "关闭",
                                action: function () {
                                }
                            }
                    }
                };
                //显示一个日志窗口
                $.confirm(p);

            });


    });
}


function filterColumn()
{
    let v= $('#columnFilter').val();
    let objs= $('.selectColPanel').find('.col');
    for( let i=0;i<objs.length;i++)
    {
        let obj= $(objs[i]);
        if( obj.attr('data').indexOf(v)>0 || v=='')
        {
            obj.show()
        }else
        {
            obj.hide();
        }
    }
}

//数据字典
function dataDictView() {
    findDBDictIdAndDo(function (dict_id) {

        let url = `db_dict_cols.jsp?pid=${dict_id}&nopreview=true&height=562`;
        $.dialog({
            title: '数据字典',
            boxWidth: '1000px',
            useBootstrap: false,
            backgroundDismiss: true,
            content: `<iframe src="${url}" style="border:0; width:100%; height:600px;"></iframe>`,
        });

    });

}


function  findDBDictIdAndDo( callback){
    let id = $('#id').val();
    let dbpool = getTableDBPool();
    let type = $('#type_table')[0].checked ? 'table' : 'sql';
    let tableName = $('#selfproperty').val();
    let name = $('#selfname').val();

    let alias = $('#selfmetadata').val();

    if (dbpool == '') {
        toastr.info("请先选择实例的数据库连接池");
        return;
    }
    if (name == '') {
        toastr.info("请先输入名称");
        return;
    }

    if (type == 'table' && tableName == '') {
        toastr.info("请先输入表名称");
        return;
    }
    if (type == 'sql' && sql == '') {
        toastr.info("请先输入SQL语句");
        return;
    }


    findDBDictID({datasourcetype: type, dbpool: dbpool, name:name, tablename: tableName, alias: alias, id: id},
        callback
        );
}


function findDBDictID(param, callback) {
    $rpc("config", "tree.data.Tree_app_sqlbuild", "findDBDictID", param,
        function (retValue) {

            var ret = JSON.parse(retValue);
            if (ret.success) {
                callback(ret.id);
            } else {
                toastr.error(ret.message);
            }
        });
}


function modleInstanceDataView(dbpool, instanceName) {

    let code = $('#code').val();
    if( code=='') code= $('#id').val();

    let key = MD5(code + "-" + instanceName);
    let data = {
        dbpool: dbpool, sql: `:buildSQL('${code}', '${instanceName}'){ }`,
        inparam: $('#inparam').val()
    }
    localStorage.setItem(key, JSON.stringify(data));
    let url = "sqlrun.jsp?key=" + key;
    openWindow(url);
}

//列出所有的视图及表，供选择，
function selectTableFromDictOrModule() {

    let dbpool = getTableDBPool();

    $confirm("选择表或视图",
        `<iframe  id=selectTreeNodeFrame  style="width:100%;height:400px;border:1px solid gray;" 
                       frameborder="0" 
                       src="config_tree_select.jsp?table=app_db_dict&nodetype=node,table,view&dbpoolLimit=${dbpool}" >
           </iframe>
        `
        ,
        function () {
            var node = $('#selectTreeNodeFrame')[0].contentWindow.getSelectedNode();
            if (node == null) return null; //不会关闭

            if (node.nodetype != 'table' && node.nodetype != 'view') {
                toastr.info("请选择表或视图");
                return null;
            }

            $('#selfproperty').val(node.originalName);
            $('#selfname').val(node.value);


        }
    );


}


// 把结果集的字段列出来，供复制
function db_reSelectColumn() {

    save(true, function () {
        $rpc("config", "tree.data.Tree_app_sqlbuild", "getDataSourceColumnsList", {

                tableid: $('#id').val()   //表的配置的ID

            },
            function (retValue) {

                var ret = JSON.parse(retValue);
                if (ret.success) {


                    var p = {
                        theme: 'light',
                        closeIcon: true,
                        columnClass: 'col-md-6',
                        closeIconClass_: 'fa fa-close',
                        animation: 'zoom',
                        closeAnimation: 'scale',
                        boxWidth: "600px",
                        useBootstrap: false,
                        title: "字段信息(请按需复制)",
                        content: `<textarea 
                   style="width:100%; height:400px; border:1px solid lightgray; " >${ret.define}

---- 完整的SQL语句为：-------------------------------
${ret.sql}
                        </textarea>`,


                        buttons: {
                            cancel:
                                {
                                    text: "关闭",
                                    action: function () {
                                    }
                                }
                        }
                    };
                    //显示一个日志窗口
                    $.confirm(p);

                } else {
                    $.alert("异常：" + ret.message);
                }


            });
    });
}

function buildSQL(tip, callback) {
    if (tip == undefined) tip = true;
    $rpc("config", "tree.data.SQLBuilder", "buildSQL", {
            instanceid: $('#id').val()   //实例 的ID
        },
        function (retValue) {
            var ret = JSON.parse(retValue);
            console.dir(ret);
            if (ret.success) {

                console.info(ret.sql);
                $setClipboard(ret.sql);
                if (tip) toastr.success("语句已复制到剪切板");

                sqlEditor.setValue(ret.sql);
                formatSQL();
                if (callback) callback(ret);
            } else {
                toastr.info( ret.message);
            }


        });
}


function thisInstanceDataView() {

    buildSQL(false, function (sql) {


        let dbpool = getTableDBPool();

        let key = $('#id').val();
        let inparam=  getNodeData( g_currentTreeNode.pid).detail.inparam;
        let data = {dbpool: dbpool, sql: sql.sql ,inparam:inparam};
        localStorage.setItem(key, JSON.stringify(data));
        let url = "sqlrun.jsp?key=" + key;
        openWindow(url);
    });
}



