/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLHandshakeException;
import sun.security.action.GetPropertyAction;
import sun.security.ssl.Alert;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.HKDF;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.JsseJce;
import sun.security.ssl.PredefinedDHParameterSpecs;
import sun.security.ssl.SSLCredentials;
import sun.security.ssl.SSLKeyAgreementGenerator;
import sun.security.ssl.SSLKeyDerivation;
import sun.security.ssl.SSLMasterKeyDerivation;
import sun.security.ssl.SSLPossession;
import sun.security.ssl.SSLPossessionGenerator;
import sun.security.ssl.SSLSecretDerivation;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.SupportedGroupsExtension;
import sun.security.ssl.Utilities;
import sun.security.ssl.X509Authentication;
import sun.security.util.KeyUtil;

final class DHKeyExchange {
    static final SSLPossessionGenerator poGenerator = new DHEPossessionGenerator(false);
    static final SSLPossessionGenerator poExportableGenerator = new DHEPossessionGenerator(true);
    static final SSLKeyAgreementGenerator kaGenerator = new DHEKAGenerator();

    DHKeyExchange() {
    }

    static final class DHECredentials
    implements SSLCredentials {
        final DHPublicKey popPublicKey;
        final SupportedGroupsExtension.NamedGroup namedGroup;

        DHECredentials(DHPublicKey dHPublicKey, SupportedGroupsExtension.NamedGroup namedGroup) {
            this.popPublicKey = dHPublicKey;
            this.namedGroup = namedGroup;
        }

        static DHECredentials valueOf(SupportedGroupsExtension.NamedGroup namedGroup, byte[] byArray) throws IOException, GeneralSecurityException {
            if (namedGroup.type != SupportedGroupsExtension.NamedGroupType.NAMED_GROUP_FFDHE) {
                throw new RuntimeException("Credentials decoding:  Not FFDHE named group");
            }
            if (byArray == null || byArray.length == 0) {
                return null;
            }
            DHParameterSpec dHParameterSpec = (DHParameterSpec)namedGroup.getParameterSpec();
            if (dHParameterSpec == null) {
                return null;
            }
            KeyFactory keyFactory = JsseJce.getKeyFactory("DiffieHellman");
            DHPublicKeySpec dHPublicKeySpec = new DHPublicKeySpec(new BigInteger(1, byArray), dHParameterSpec.getP(), dHParameterSpec.getG());
            DHPublicKey dHPublicKey = (DHPublicKey)keyFactory.generatePublic(dHPublicKeySpec);
            return new DHECredentials(dHPublicKey, namedGroup);
        }
    }

    private static final class DHEKAGenerator
    implements SSLKeyAgreementGenerator {
        private static DHEKAGenerator instance = new DHEKAGenerator();

        private DHEKAGenerator() {
        }

        @Override
        public SSLKeyDerivation createKeyDerivation(HandshakeContext handshakeContext) throws IOException {
            DHEPossession dHEPossession = null;
            DHECredentials dHECredentials = null;
            for (SSLPossession sSLPossession : handshakeContext.handshakePossessions) {
                if (!(sSLPossession instanceof DHEPossession)) continue;
                DHEPossession dHEPossession2 = (DHEPossession)sSLPossession;
                for (SSLCredentials sSLCredentials : handshakeContext.handshakeCredentials) {
                    if (!(sSLCredentials instanceof DHECredentials)) continue;
                    DHECredentials dHECredentials2 = (DHECredentials)sSLCredentials;
                    if (dHEPossession2.namedGroup != null && dHECredentials2.namedGroup != null) {
                        if (!dHEPossession2.namedGroup.equals((Object)dHECredentials2.namedGroup)) continue;
                        dHECredentials = (DHECredentials)sSLCredentials;
                        break;
                    }
                    DHParameterSpec dHParameterSpec = dHEPossession2.publicKey.getParams();
                    DHParameterSpec dHParameterSpec2 = dHECredentials2.popPublicKey.getParams();
                    if (!dHParameterSpec.getP().equals(dHParameterSpec2.getP()) || !dHParameterSpec.getG().equals(dHParameterSpec2.getG())) continue;
                    dHECredentials = (DHECredentials)sSLCredentials;
                    break;
                }
                if (dHECredentials == null) continue;
                dHEPossession = (DHEPossession)sSLPossession;
                break;
            }
            if (dHEPossession == null || dHECredentials == null) {
                throw handshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No sufficient DHE key agreement parameters negotiated");
            }
            return new DHEKAKeyDerivation(handshakeContext, dHEPossession.privateKey, dHECredentials.popPublicKey);
        }

        private static final class DHEKAKeyDerivation
        implements SSLKeyDerivation {
            private final HandshakeContext context;
            private final PrivateKey localPrivateKey;
            private final PublicKey peerPublicKey;

            DHEKAKeyDerivation(HandshakeContext handshakeContext, PrivateKey privateKey, PublicKey publicKey) {
                this.context = handshakeContext;
                this.localPrivateKey = privateKey;
                this.peerPublicKey = publicKey;
            }

            @Override
            public SecretKey deriveKey(String string, AlgorithmParameterSpec algorithmParameterSpec) throws IOException {
                if (!this.context.negotiatedProtocol.useTLS13PlusSpec()) {
                    return this.t12DeriveKey(string, algorithmParameterSpec);
                }
                return this.t13DeriveKey(string, algorithmParameterSpec);
            }

            private SecretKey t12DeriveKey(String string, AlgorithmParameterSpec algorithmParameterSpec) throws IOException {
                try {
                    KeyAgreement keyAgreement = JsseJce.getKeyAgreement("DiffieHellman");
                    keyAgreement.init(this.localPrivateKey);
                    keyAgreement.doPhase(this.peerPublicKey, true);
                    SecretKey secretKey = keyAgreement.generateSecret("TlsPremasterSecret");
                    SSLMasterKeyDerivation sSLMasterKeyDerivation = SSLMasterKeyDerivation.valueOf(this.context.negotiatedProtocol);
                    if (sSLMasterKeyDerivation == null) {
                        throw new SSLHandshakeException("No expected master key derivation for protocol: " + this.context.negotiatedProtocol.name);
                    }
                    SSLKeyDerivation sSLKeyDerivation = sSLMasterKeyDerivation.createKeyDerivation(this.context, secretKey);
                    return sSLKeyDerivation.deriveKey("MasterSecret", algorithmParameterSpec);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw (SSLHandshakeException)new SSLHandshakeException("Could not generate secret").initCause(generalSecurityException);
                }
            }

            private SecretKey t13DeriveKey(String string, AlgorithmParameterSpec algorithmParameterSpec) throws IOException {
                try {
                    Object object;
                    KeyAgreement keyAgreement = JsseJce.getKeyAgreement("DiffieHellman");
                    keyAgreement.init(this.localPrivateKey);
                    keyAgreement.doPhase(this.peerPublicKey, true);
                    SecretKey secretKey = keyAgreement.generateSecret("TlsPremasterSecret");
                    CipherSuite.HashAlg hashAlg = this.context.negotiatedCipherSuite.hashAlg;
                    SSLKeyDerivation sSLKeyDerivation = this.context.handshakeKeyDerivation;
                    HKDF hKDF = new HKDF(hashAlg.name);
                    if (sSLKeyDerivation == null) {
                        object = new byte[hashAlg.hashLength];
                        SecretKeySpec secretKeySpec = new SecretKeySpec((byte[])object, "TlsPreSharedSecret");
                        SecretKey secretKey2 = hKDF.extract((byte[])object, (SecretKey)secretKeySpec, "TlsEarlySecret");
                        sSLKeyDerivation = new SSLSecretDerivation(this.context, secretKey2);
                    }
                    object = sSLKeyDerivation.deriveKey("TlsSaltSecret", null);
                    return hKDF.extract((SecretKey)object, secretKey, string);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw (SSLHandshakeException)new SSLHandshakeException("Could not generate secret").initCause(generalSecurityException);
                }
            }
        }
    }

    static final class DHEPossession
    implements SSLPossession {
        final PrivateKey privateKey;
        final DHPublicKey publicKey;
        final SupportedGroupsExtension.NamedGroup namedGroup;

        DHEPossession(SupportedGroupsExtension.NamedGroup namedGroup, SecureRandom secureRandom) {
            try {
                KeyPairGenerator keyPairGenerator = JsseJce.getKeyPairGenerator("DiffieHellman");
                DHParameterSpec dHParameterSpec = (DHParameterSpec)namedGroup.getParameterSpec();
                keyPairGenerator.initialize(dHParameterSpec, secureRandom);
                KeyPair keyPair = this.generateDHKeyPair(keyPairGenerator);
                if (keyPair == null) {
                    throw new RuntimeException("Could not generate DH keypair");
                }
                this.privateKey = keyPair.getPrivate();
                this.publicKey = (DHPublicKey)keyPair.getPublic();
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new RuntimeException("Could not generate DH keypair", generalSecurityException);
            }
            this.namedGroup = namedGroup;
        }

        DHEPossession(int n, SecureRandom secureRandom) {
            DHParameterSpec dHParameterSpec = PredefinedDHParameterSpecs.definedParams.get(n);
            try {
                KeyPairGenerator keyPairGenerator = JsseJce.getKeyPairGenerator("DiffieHellman");
                if (dHParameterSpec != null) {
                    keyPairGenerator.initialize(dHParameterSpec, secureRandom);
                } else {
                    keyPairGenerator.initialize(n, secureRandom);
                }
                KeyPair keyPair = this.generateDHKeyPair(keyPairGenerator);
                if (keyPair == null) {
                    throw new RuntimeException("Could not generate DH keypair of " + n + " bits");
                }
                this.privateKey = keyPair.getPrivate();
                this.publicKey = (DHPublicKey)keyPair.getPublic();
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new RuntimeException("Could not generate DH keypair", generalSecurityException);
            }
            this.namedGroup = SupportedGroupsExtension.NamedGroup.valueOf(this.publicKey.getParams());
        }

        DHEPossession(DHECredentials dHECredentials, SecureRandom secureRandom) {
            try {
                KeyPairGenerator keyPairGenerator = JsseJce.getKeyPairGenerator("DiffieHellman");
                keyPairGenerator.initialize(dHECredentials.popPublicKey.getParams(), secureRandom);
                KeyPair keyPair = this.generateDHKeyPair(keyPairGenerator);
                if (keyPair == null) {
                    throw new RuntimeException("Could not generate DH keypair");
                }
                this.privateKey = keyPair.getPrivate();
                this.publicKey = (DHPublicKey)keyPair.getPublic();
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new RuntimeException("Could not generate DH keypair", generalSecurityException);
            }
            this.namedGroup = dHECredentials.namedGroup;
        }

        private KeyPair generateDHKeyPair(KeyPairGenerator keyPairGenerator) throws GeneralSecurityException {
            boolean bl = !KeyUtil.isOracleJCEProvider(keyPairGenerator.getProvider().getName());
            boolean bl2 = false;
            for (int i = 0; i <= 2; ++i) {
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                if (bl) {
                    DHPublicKeySpec dHPublicKeySpec = DHEPossession.getDHPublicKeySpec(keyPair.getPublic());
                    try {
                        KeyUtil.validate(dHPublicKeySpec);
                    }
                    catch (InvalidKeyException invalidKeyException) {
                        if (bl2) {
                            throw invalidKeyException;
                        }
                        bl2 = true;
                        continue;
                    }
                }
                return keyPair;
            }
            return null;
        }

        private static DHPublicKeySpec getDHPublicKeySpec(PublicKey publicKey) {
            if (publicKey instanceof DHPublicKey) {
                DHPublicKey dHPublicKey = (DHPublicKey)publicKey;
                DHParameterSpec dHParameterSpec = dHPublicKey.getParams();
                return new DHPublicKeySpec(dHPublicKey.getY(), dHParameterSpec.getP(), dHParameterSpec.getG());
            }
            try {
                KeyFactory keyFactory = JsseJce.getKeyFactory("DiffieHellman");
                return keyFactory.getKeySpec(publicKey, DHPublicKeySpec.class);
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
                throw new RuntimeException("Unable to get DHPublicKeySpec", generalSecurityException);
            }
        }

        @Override
        public byte[] encode() {
            byte[] byArray = Utilities.toByteArray(this.publicKey.getY());
            int n = KeyUtil.getKeySize(this.publicKey) + 7 >>> 3;
            if (n > 0 && byArray.length < n) {
                byte[] byArray2 = new byte[n];
                System.arraycopy(byArray, 0, byArray2, n - byArray.length, byArray.length);
                byArray = byArray2;
            }
            return byArray;
        }
    }

    private static final class DHEPossessionGenerator
    implements SSLPossessionGenerator {
        private static final boolean useSmartEphemeralDHKeys;
        private static final boolean useLegacyEphemeralDHKeys;
        private static final int customizedDHKeySize;
        private final boolean exportable;

        private DHEPossessionGenerator(boolean bl) {
            this.exportable = bl;
        }

        @Override
        public SSLPossession createPossession(HandshakeContext handshakeContext) {
            int n;
            SupportedGroupsExtension.NamedGroup namedGroup = null;
            if (!useLegacyEphemeralDHKeys && handshakeContext.clientRequestedNamedGroups != null && !handshakeContext.clientRequestedNamedGroups.isEmpty() && (namedGroup = SupportedGroupsExtension.SupportedGroups.getPreferredGroup(handshakeContext.negotiatedProtocol, handshakeContext.algorithmConstraints, SupportedGroupsExtension.NamedGroupType.NAMED_GROUP_FFDHE, handshakeContext.clientRequestedNamedGroups)) != null) {
                return new DHEPossession(namedGroup, handshakeContext.sslContext.getSecureRandom());
            }
            int n2 = n = this.exportable ? 512 : 1024;
            if (!this.exportable) {
                if (useLegacyEphemeralDHKeys) {
                    n = 768;
                } else if (useSmartEphemeralDHKeys) {
                    PrivateKey privateKey = null;
                    ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)handshakeContext;
                    if (serverHandshakeContext.interimAuthn instanceof X509Authentication.X509Possession) {
                        privateKey = ((X509Authentication.X509Possession)serverHandshakeContext.interimAuthn).popPrivateKey;
                    }
                    if (privateKey != null) {
                        int n3 = KeyUtil.getKeySize(privateKey);
                        n = n3 <= 1024 ? 1024 : 2048;
                    }
                } else if (customizedDHKeySize > 0) {
                    n = customizedDHKeySize;
                }
            }
            return new DHEPossession(n, handshakeContext.sslContext.getSecureRandom());
        }

        static {
            String string = GetPropertyAction.privilegedGetProperty("jdk.tls.ephemeralDHKeySize");
            if (string == null || string.length() == 0) {
                useLegacyEphemeralDHKeys = false;
                useSmartEphemeralDHKeys = false;
                customizedDHKeySize = -1;
            } else if ("matched".equals(string)) {
                useLegacyEphemeralDHKeys = false;
                useSmartEphemeralDHKeys = true;
                customizedDHKeySize = -1;
            } else if ("legacy".equals(string)) {
                useLegacyEphemeralDHKeys = true;
                useSmartEphemeralDHKeys = false;
                customizedDHKeySize = -1;
            } else {
                useLegacyEphemeralDHKeys = false;
                useSmartEphemeralDHKeys = false;
                try {
                    customizedDHKeySize = Integer.parseUnsignedInt(string);
                    if (customizedDHKeySize < 1024 || customizedDHKeySize > 8192 || (customizedDHKeySize & 0x3F) != 0) {
                        throw new IllegalArgumentException("Unsupported customized DH key size: " + customizedDHKeySize + ". The key size must be multiple of 64, and range from 1024 to 8192 (inclusive)");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Invalid system property jdk.tls.ephemeralDHKeySize");
                }
            }
        }
    }
}

