/*
 * Decompiled with CFR 0.152.
 */
package print;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import print.WorkSheetView;

public class PrintBook
implements Pageable {
    private List pages = new ArrayList();
    private List pageFormats = new ArrayList();
    private WorkSheetView View;
    private JFrame pFrame;

    public PrintBook(WorkSheetView view, JFrame frame) {
        this.View = view;
        this.pFrame = frame;
    }

    public Book getBook() {
        Book book = new Book();
        int numPages = this.getNumberOfPages();
        for (int i = 0; i < numPages; ++i) {
            Printable printable = this.getPrintable(i);
            PageFormat pageFormat = this.getPageFormat(i);
            book.append(printable, pageFormat);
        }
        return book;
    }

    public void addPage(PageFormat pageFormat) {
        try {
            this.pageFormats.add(pageFormat);
            PagePrintable printable = new PagePrintable();
            this.pages.add(printable);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removePage(int pageIndex) throws IndexOutOfBoundsException {
        this.pages.remove(pageIndex);
        this.pageFormats.remove(pageIndex);
    }

    @Override
    public int getNumberOfPages() {
        return this.pages.size();
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        return (PageFormat)this.pageFormats.get(pageIndex);
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return (Printable)this.pages.get(pageIndex);
    }

    class PagePrintable
    implements Printable {
        PagePrintable() {
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
            Graphics2D g2 = (Graphics2D)graphics;
            boolean isPreview = g2.getDeviceConfiguration().getDevice().getType() == 0;
            int pageCount = PrintBook.this.View.getPageCount();
            if (pageIndex >= pageCount) {
                return 1;
            }
            PrintBook.this.View.onPrint(isPreview, g2, pageIndex);
            if (pageIndex >= pageCount) {
                return 1;
            }
            return 0;
        }
    }
}

