/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.server.provider;

import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Messages;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.encoding.xml.XMLMessage;
import com.sun.xml.internal.ws.resources.ServerMessages;
import com.sun.xml.internal.ws.server.provider.ProviderArgumentsBuilder;
import com.sun.xml.internal.ws.server.provider.ProviderEndpointModel;
import javax.activation.DataSource;
import javax.xml.transform.Source;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.http.HTTPException;

abstract class XMLProviderArgumentBuilder<T>
extends ProviderArgumentsBuilder<T> {
    XMLProviderArgumentBuilder() {
    }

    @Override
    protected Packet getResponse(Packet packet, Exception exception, WSDLPort wSDLPort, WSBinding wSBinding) {
        Packet packet2 = super.getResponse(packet, exception, wSDLPort, wSBinding);
        if (exception instanceof HTTPException && packet2.supports("javax.xml.ws.http.response.code")) {
            packet2.put("javax.xml.ws.http.response.code", ((HTTPException)exception).getStatusCode());
        }
        return packet2;
    }

    static XMLProviderArgumentBuilder createBuilder(ProviderEndpointModel providerEndpointModel, WSBinding wSBinding) {
        if (providerEndpointModel.mode == Service.Mode.PAYLOAD) {
            return new PayloadSource();
        }
        if (providerEndpointModel.datatype == Source.class) {
            return new PayloadSource();
        }
        if (providerEndpointModel.datatype == DataSource.class) {
            return new DataSourceParameter(wSBinding);
        }
        throw new WebServiceException(ServerMessages.PROVIDER_INVALID_PARAMETER_TYPE(providerEndpointModel.implClass, providerEndpointModel.datatype));
    }

    private static final class DataSourceParameter
    extends XMLProviderArgumentBuilder<DataSource> {
        private final WSBinding binding;

        DataSourceParameter(WSBinding wSBinding) {
            this.binding = wSBinding;
        }

        @Override
        public DataSource getParameter(Packet packet) {
            Message message = packet.getInternalMessage();
            return message instanceof XMLMessage.MessageDataSource ? ((XMLMessage.MessageDataSource)((Object)message)).getDataSource() : XMLMessage.getDataSource(message, this.binding.getFeatures());
        }

        @Override
        public Message getResponseMessage(DataSource dataSource) {
            return XMLMessage.create(dataSource, this.binding.getFeatures());
        }

        @Override
        protected Message getResponseMessage(Exception exception) {
            return XMLMessage.create(exception);
        }
    }

    private static final class PayloadSource
    extends XMLProviderArgumentBuilder<Source> {
        private PayloadSource() {
        }

        @Override
        public Source getParameter(Packet packet) {
            return packet.getMessage().readPayloadAsSource();
        }

        @Override
        public Message getResponseMessage(Source source) {
            return Messages.createUsingPayload(source, SOAPVersion.SOAP_11);
        }

        @Override
        protected Message getResponseMessage(Exception exception) {
            return XMLMessage.create(exception);
        }
    }
}

